#! /bin/sh
# BiBTeX2HIndex.sh script
#
# ___________________________________________________________________________________________
# ---------------------------
# Author  : Max Mignotte
# Version : 1.02
# ---------------------------
#
# USAGE :    BiBTeX2HIndex.sh  [your BibTex File]
#
# Comments:
#
# * The string AUTHOR of the Bibtex file should contain the 
#   initial(s) of the first name(s) followed by the last name, 
#   (e.g., 'A. Einstein' and thus do not put the initial(s) 
#   after the last name)
#
# * The proposed script uses [htget]
#   [http://dir.filewatcher.com/d/Other/metalab/apps/www/mirroring/htget-0.92.tar.gz.17605.html]
#   namely a file grabber that will get files from HTTP servers 
#
#   ---------------------------
#   
#   The output od this script is the file Result.txt
#
#   ---------------------------
#   Remark: Massive usage of this script (e.g., in the case of a very large number of papers in your Bibtex file
#   and/or several repeated usage of this script) may be considered by the Google Scholar server as a spam attack, 
#   and may invalidate the IP number of your computer for a while. 
#   If this happens, you get an 'Internet connection failed' error message. Nevertheless, you still can use 
#   Google Scholar from a web browser and re-used this script a bit later.
#
#   Remark2: Since this script uses Google Scholar and since Google Scholar is not perfect 
#   (e.g., some articles are bad referenced in Google Scholar with some typos and errors), the result
#   of this script is not perfect and should be manually refined (for example with supervision
#   for some references).
#
#   Nota: this shell script is constantly under construction. If you have any comments, 
#   suggestions for it, or you want to report a bug, please fell free to send me an Email
#
#_____________________________________________________________________________________________

#----Constant
#------------
NbWords=6   #Number of words of the title taken into accont in the Google Schorar research
True=1
#------------

#---------Usage-----------
#-------------------------
YES=1 Optionhelp=0
if [ $# -le 0 -o $# -gt 1 ] 
    then Optionhelp=$YES
fi
for arg in $*
do
case $arg in
 -help) Optionhelp=$YES;;
     *) 
  break
esac
done

if [ $Optionhelp == $YES ]
then
echo ""
echo "    USAGE :     H-IndexEstimation.sh  [BibTexFile]"
echo ""
exit
fi
#-------------------------


#-- Load Input Argument
#----------------------
InputBibTexFile=${1}
#----------------------


#--Clean---------------
#----------------------
for var in 1 2 3 4 5 6 7 
do
if [ -f tmp${var}.dat ] 
then
rm tmp${var}.dat
fi
done
#----------------------



#--Clean the BiBTeX File-------
#------------------------------
#>small letters
cat ${1} | tr A-Z a-z | tr \" " " > tmp1.dat

#>Remove the brace and :
for var in \{ \} :
do
ed tmp1.dat <<% 
g/$var/s//$Nothing/g
w
%
done

#>Replace booktitle by book
FlagBook=booktitle
NewFlagBook=book
ed tmp1.dat <<% 
g/$FlagBook/s//$NewFlagBook/g
w
%

#>Replace A.-A. by AA.
dotname="\.-"
ed tmp1.dat <<% 
g/$dotname/s//$Nothing/g
w
%
#-----------------------------



#--Extract Title------------------------
#---------------------------------------
NbPapers=`cat tmp1.dat | grep "title" | wc -l`


#>Extract title & Remove last character if it is a ","
cat tmp1.dat | grep "title" | cut -d = -f 2 | while read line
do
nbchar=`echo $line | wc -c`
let nbchar=nbchar-1
lastchar=`echo $line | cut -b $nbchar`

let nbchar=nbchar-1
OptEnd=1

if [ $lastchar == "," ]
then
line=`echo -n $line | cut -b 0-${nbchar}`
OptEnd=0
fi

if [ $OptEnd == 0 ]
then
echo $line >> tmp2.dat
fi

if [ $OptEnd == 1 ]
then
echo $line ... >> tmp2.dat
fi

done
#---------------------------------------



#--Extract FirstAuthor:title > tmp3.dat
#--------------------------------------
nb=0
cat tmp1.dat | grep "author" | cut -d = -f 2 |  while read line
do

let nb=nb+1

vartmp1=`echo $line | cut -d "." -f 2`
vartmp2=`echo $line | cut -d "." -f 3`
vartmp1=`echo $vartmp1`
vartmp2=`echo $vartmp2`
vartmp1=`echo $vartmp1 | cut -d " " -f 1`
vartmp2=`echo $vartmp2 | cut -d " " -f 1`
nbchar1=`echo $vartmp1 | wc -c`
nbchar2=`echo $vartmp2 | wc -c`

FirstAuthor=$vartmp1
if [ $nbchar1 == 2 ]
then
FirstAuthor=$vartmp2
fi

FirstAuthor=`echo $FirstAuthor | cut -d "," -f 1`
Title=`cat tmp2.dat | head -n $nb | tail -n 1`

NewTitle=`echo $Title | cut -d " " -f 1`
nbc=1

while [ $nbc -lt $NbWords ]; do

let nbc=nbc+1
Word=`echo $Title | cut -d " " -f $nbc`

NewTitle=${NewTitle}+$Word

done

echo $FirstAuthor : $NewTitle >> tmp3.dat
done
#--------------------------------------



#--GoogleScolar search syntax > tmp4.dat
#---------------------------------------
Http1="http://scholar.google.com/scholar?as_q="
Http2="&num=10&btnG=Search+Scholar&as_epq=&as_oq=&as_eq=&as_occt=title&as_sauthors="
Http3="&as_publication=&as_ylo=&as_yhi=&as_allsubj=all&hl=en&lr="


nb=0
cat tmp3.dat | while read line
do

FirstAuthor=`echo $line | cut -d : -f 1`
Title=`echo $line | cut -d : -f 2`
GoogleLine=${Http1}${Title}${Http2}${FirstAuthor}${Http3}

echo $GoogleLine >> tmp4.dat
done

#>Remove blank
blank=" "
ed tmp4.dat <<% 
g/$blank/s//$Nothing/g
w
%
#--------------------------------------


#----------------------------------------
#--GOOGLE SCOLAR SEARCH -----------------
#----------------------------------------
nb=0

#>Loop
cat tmp4.dat | while read line
do
let nb=nb+1

#>Clean
if [ -f temp.html ]
then
rm  temp.html
fi

if [ -f temp2.html ]
then
rm  temp2.html
fi

#>grabb file from HTTP servers
#-----------------------------
# You can modify the proposed script in order to also use 
# any other existing file grabbers that will get files 
# from HTTP servers
uhtget -- $line > temp.html
#-----------------------------

#>Load Number of citations
cat temp.html | tr ">" "\n" > temp2.html
NbCitation=`cat temp2.html | grep "Cited" | head -n 1 | cut -d "<" -f 1 | cut -d " " -f 3`

#>Load title & author for each paper
Title=`cat tmp2.dat | head -n $nb | tail -n 1`
FirstAuthor=`cat tmp3.dat | head -n $nb | tail -n 1 | cut -d : -f 1`

#>If Nb Citation=0
flag=`echo $NbCitation | wc -c`

if [ $flag -le 1 ]
then
NbCitation=0
fi

#>Record in tmp5.dat
echo ${NbCitation}      : First Author ${FirstAuthor} :${Title} >> tmp5.dat
echo Paper number ${nb} Cited by $NbCitation

done
#--------------------------------------


#--Clean-----------
#------------------
if [ -f temp.html ]
then
rm  temp.html
fi

if [ -f temp2.html ]
then
rm  temp2.html
fi
#-------------------


#--Decreasing sort
#-----------------
cat tmp5.dat | sort -n -r > tmp6.dat
#-----------------


#--Computing statistics (H & G Index)
#-----------------------------------
NbTotPap=0
NbTotCit=0
NbHCurrent=0
NbGCurrent=0
AvgCitCurrent=0
AvgCitCurrentFloat=0

nbl=`cat tmp6.dat | wc -l`

#>Boucle
for (( nb=1;nb<=$nbl;nb++ ))
do
line=`cat tmp6.dat | head -n $nb | tail -n 1`

CiteCurrent=`echo $line | cut -d : -f 1`
CiteCurrent=`echo $CiteCurrent`

let NbTotCit=NbTotCit+$CiteCurrent
let NbTotPap=NbTotPap+1
let AvgCitCurrent=$NbTotCit/$NbTotPap

if [ $CiteCurrent -gt $NbHCurrent ]
then
let NbHCurrent=NbHCurrent+1
fi 

if [ $NbTotPap -le $AvgCitCurrent ]
then
let NbGCurrent=NbGCurrent+1
fi

done

H_index=$NbHCurrent
G_index=$NbGCurrent

AvgCitCurrentFloat=`echo $NbTotCit/$NbTotPap | bc -l`
#-----------------------------------


#-Echo Statistics-----------------
#---------------------------------
echo ""
echo ""
echo Final Statistics
echo ----------------
echo Total Number of Citations = $NbTotCit
echo Average Number of Citations/Paper = $AvgCitCurrentFloat
echo H Index = $H_index
echo G Index = $G_index
echo ""
echo ""
#---------------------------------



#-Record in File result.txt
#--------------------------

#>Clean
if [ -f Result.txt ]
then
rm Result.txt
fi

#>Header
echo "" > Result.txt
echo "" >> Result.txt
echo Final Statistics  >> Result.txt
echo ----------------  >> Result.txt
echo Total Number of Citations = $NbTotCit >> Result.txt
echo Average Number of Citations/Paper = $AvgCitCurrentFloat >> Result.txt
echo H Index = $H_index >> Result.txt
echo G Index = $G_index >> Result.txt
echo "" >> Result.txt
echo "" >> Result.txt

#>Papers in decreasing order
cat tmp6.dat | while read line
do

Title=`echo $line | cut -d : -f 3`
Author=`echo $line | cut -d : -f 2`
CitedBy=`echo $line | cut -d : -f 1`

echo $Title >> Result.txt
echo $Author >> Result.txt
echo Cited By $CitedBy  >> Result.txt
echo "" >> Result.txt

done
#--------------------------

#--Final Clean--------------
#---------------------------
for var in 1 2 3 4 5 6 7 8
do
if [ -f tmp${var}.dat ] 
then
rm tmp${var}.dat
fi
done
#---------------------------


echo "End ...."
echo ""

