/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.text.NumberFormat;
import java.util.Random;
import java.util.Vector;

class DiffractionFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Thread engine = null;
    Dimension winSize;
    Dimension fullWinSize;
    Image dbimage;
    Random random;
    int gridSizeX = 200;
    int gridSizeY = 200;
    Button defaultsButton;
    Checkbox colorCheck;
    Checkbox reversedCheck;
    Checkbox memoryImageSourceCheck;
    Checkbox sizeCheck;
    Choice apertureChooser;
    Scrollbar gridBar;
    Scrollbar lengthBar;
    Scrollbar zoomBar;
    Scrollbar brightnessBar;
    double colorMult;
    double zbase;
    static final double pi = Math.PI;
    static final double pi2 = Math.PI * 2;
    double[][][] func;
    boolean functionChanged;
    boolean dragging = false;
    MemoryImageSource imageSource;
    int[] pixels;
    DiffractionCanvas cv;
    Vector apertureList;
    Aperture aperture;
    Diffraction applet;
    int angleSteps;
    int angleStepsMask;
    double angleStep;
    double[] angcos1;
    double[] angsin1;
    int[] angdirx1;
    int[] angdiry1;
    long[] angcos2;
    long[] angsin2;
    int angleSteps2;
    int angleSteps2Mask;
    static final int fixedPoint = 256;
    int[] accumR;
    int[] accumI;
    double apertureArgMult;
    double apertureArgMultRed;
    double apertureArgMultBlue;
    double[] colorLenMults;
    boolean reversed;
    boolean color;
    int selection = -1;
    double zoomFactor;
    int oldZoom = 200;
    static final double[] sn = new double[]{-2991.8191940101983, 708840.0452577386, -6.297414862058625E7, 2.5489088057337637E9, -4.429795180596978E10, 3.180162978765678E11};
    static final double[] sd = new double[]{281.3762688899943, 45584.78108065326, 5173438.887700964, 4.193202458981112E8, 2.2441179564534092E10, 6.073663894900846E11};
    static final double[] cn = new double[]{-4.9884311457357354E-8, 9.504280628298596E-6, -6.451914356839651E-4, 0.018884331939670384, -0.20552590095501388, 1.0};
    static final double[] cd = new double[]{3.99982968972496E-12, 9.154392157746574E-10, 1.2500186247959882E-7, 1.2226278902417902E-5, 8.680295429417843E-4, 0.04121420907221998, 1.0};
    static final double[] fn = new double[]{0.4215435550436775, 0.1434079197807589, 0.011522095507358577, 3.45017939782574E-4, 4.6361374928786735E-6, 3.055689837902576E-8, 1.0230451416490724E-10, 1.7201074326816183E-13, 1.3428327623306275E-16, 3.763297112699879E-20};
    static final double[] fd = new double[]{0.7515863983533789, 0.11688892585919138, 0.0064405152650885865, 1.5593440916415301E-4, 1.8462756734893055E-6, 1.1269922476399903E-8, 3.6014002958937136E-11, 5.887545336215784E-14, 4.5200143407412973E-17, 1.2544323709001127E-20};
    static final double[] gn = new double[]{0.5044420736433832, 0.1971028335255234, 0.018764858409257526, 6.840793809153931E-4, 1.1513882611188428E-5, 9.828524436884223E-8, 4.4534441586175015E-10, 1.0826804113902088E-12, 1.375554606332618E-15, 8.363544356306774E-19, 1.8695871016278324E-22};
    static final double[] gd = new double[]{1.4749575992512833, 0.33774898912002, 0.02536037414203388, 8.146791071843061E-4, 1.2754507566772912E-5, 1.0431458965757199E-7, 4.6068072814652043E-10, 1.1027321506624028E-12, 1.3879653125957886E-15, 8.391588162831187E-19, 1.8695871016278324E-22};
    static final double PI = Math.PI;
    static final double PIBYTWO = 1.5707963267948966;

    public String getAppletInfo() {
        return "Diffraction by Paul Falstad";
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    DiffractionFrame(Diffraction diffraction) {
        super("Diffraction Applet");
        this.applet = diffraction;
    }

    public void init() {
        this.apertureList = new Vector();
        Aperture aperture = new CircularAperture();
        while (aperture != null) {
            this.apertureList.addElement(aperture);
            aperture = ((Aperture)aperture).createNext();
        }
        this.setLayout(new DiffractionLayout());
        this.cv = new DiffractionCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        this.defaultsButton = new Button("Set to Defaults");
        this.add(this.defaultsButton);
        this.defaultsButton.addActionListener(this);
        this.colorCheck = new Checkbox("Tri-chromatic");
        this.colorCheck.addItemListener(this);
        this.add(this.colorCheck);
        this.reversedCheck = new Checkbox("Reversed");
        this.reversedCheck.addItemListener(this);
        this.add(this.reversedCheck);
        this.sizeCheck = new Checkbox("Show Dimensions");
        this.sizeCheck.addItemListener(this);
        this.add(this.sizeCheck);
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("java.version");
        boolean bl = false;
        if (string.indexOf("Windows") == 0 && string2.indexOf("1.1") == 0) {
            bl = true;
        }
        this.memoryImageSourceCheck = new Checkbox("Alternate Rendering", bl);
        this.memoryImageSourceCheck.addItemListener(this);
        this.add(this.memoryImageSourceCheck);
        this.apertureChooser = new Choice();
        int n = 0;
        while (n != this.apertureList.size()) {
            this.apertureChooser.add("Aperture: " + ((Aperture)this.apertureList.elementAt(n)).getName());
            ++n;
        }
        this.add(this.apertureChooser);
        this.aperture = (Aperture)this.apertureList.elementAt(0);
        this.apertureChooser.addItemListener(this);
        this.add(new Label("Aperture Scale", 1));
        this.lengthBar = new Scrollbar(0, 260, 1, 35, 500);
        this.add(this.lengthBar);
        this.lengthBar.addAdjustmentListener(this);
        this.add(new Label("Zoom", 1));
        this.zoomBar = new Scrollbar(0, 200, 1, 30, 400);
        this.add(this.zoomBar);
        this.zoomBar.addAdjustmentListener(this);
        this.add(new Label("Brightness", 1));
        this.brightnessBar = new Scrollbar(0, 50, 1, 1, 500);
        this.add(this.brightnessBar);
        this.brightnessBar.addAdjustmentListener(this);
        this.add(new Label("Image Resolution", 1));
        this.gridBar = new Scrollbar(0, 90, 2, 10, 300);
        this.add(this.gridBar);
        this.gridBar.addAdjustmentListener(this);
        this.add(new Label("http://www.falstad.com", 1));
        this.random = new Random();
        this.functionChanged = true;
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.white);
        this.zbase = 1.0 / Math.exp(4.0);
        this.resize(550, 450);
        this.handleResize();
        this.show();
    }

    void reinit() {
        this.handleResize();
    }

    void handleResize() {
        int n;
        this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        Dimension dimension = this.fullWinSize = this.cv.getSize();
        this.winSize.width = this.winSize.height = (n = this.winSize.width > this.winSize.height ? this.winSize.height : this.winSize.width);
        this.dbimage = this.createImage(dimension.width, dimension.height);
        dimension = this.winSize;
        this.pixels = new int[dimension.width * dimension.height];
        this.imageSource = new MemoryImageSource(dimension.width, dimension.height, this.pixels, 0, dimension.width);
    }

    void computeFunction() {
        int n;
        int n2;
        int n3;
        this.accumR = new int[3];
        this.accumI = new int[3];
        this.aperture = (Aperture)this.apertureList.elementAt(this.apertureChooser.getSelectedIndex());
        this.gridSizeX = this.gridSizeY = this.gridBar.getValue() & 0xFFFFFFFE;
        if (this.aperture.oneDimensional()) {
            this.gridSizeX *= 2;
            this.gridSizeY = 1;
        }
        this.func = new double[this.gridSizeX][this.gridSizeY][3];
        this.color = this.colorCheck.getState();
        int n4 = this.angleSteps = this.gridBar.getValue() >= 195 ? 1024 : 256;
        if (this.aperture.oneDimensional()) {
            this.angleSteps = this.gridBar.getValue() >= 195 ? 2048 : 1024;
        }
        this.angleStepsMask = this.angleSteps - 1;
        this.angleStep = Math.PI * 2 / (double)this.angleSteps;
        this.zoomFactor = Math.exp((double)this.zoomBar.getValue() / 50.0) * this.zbase;
        double d = Math.exp((double)this.lengthBar.getValue() / 110.0) / this.zoomFactor;
        this.angcos1 = new double[this.angleSteps];
        this.angsin1 = new double[this.angleSteps];
        this.angdirx1 = new int[this.angleSteps];
        this.angdiry1 = new int[this.angleSteps];
        int n5 = 0;
        while (n5 != this.angleSteps) {
            this.angcos1[n5] = Math.cos((double)n5 * (Math.PI * 2) / (double)this.angleSteps);
            this.angsin1[n5] = Math.sin((double)n5 * (Math.PI * 2) / (double)this.angleSteps);
            this.angdirx1[n5] = this.angcos1[n5] < 0.0 ? -1 : 1;
            this.angdiry1[n5] = this.angsin1[n5] < 0.0 ? -1 : 1;
            ++n5;
        }
        this.angleSteps2 = 4096;
        this.angleSteps2Mask = this.angleSteps2 - 1;
        this.angcos2 = new long[this.angleSteps2];
        this.angsin2 = new long[this.angleSteps2];
        this.reversed = this.reversedCheck.getState();
        float f = this.reversed ? -1.0f : 1.0f;
        this.colorLenMults = new double[3];
        n5 = 0;
        while (n5 != this.angleSteps2) {
            this.angcos2[n5] = (long)(Math.cos((double)n5 * (Math.PI * 2) / (double)this.angleSteps2) * 256.0 * (double)f);
            this.angsin2[n5] = (long)(Math.sin((double)n5 * (Math.PI * 2) / (double)this.angleSteps2) * 256.0 * (double)f);
            ++n5;
        }
        this.colorLenMults[0] = d / 1.2745098039215685;
        this.colorLenMults[1] = d;
        this.colorLenMults[2] = d / 0.9313725490196079;
        this.apertureArgMult = (double)this.angleSteps2 * 0.25;
        this.apertureArgMult *= d * d;
        this.apertureArgMultRed = this.apertureArgMult / 1.6243752402921954;
        this.apertureArgMultBlue = this.apertureArgMult / 0.8674548250672818;
        this.aperture.compute();
        int n6 = this.aperture.hasXSymmetry() ? this.gridSizeX / 2 : this.gridSizeX;
        int n7 = this.aperture.hasYSymmetry() ? this.gridSizeY / 2 : this.gridSizeY;
        int n8 = this.color ? 0 : 1;
        int n9 = n3 = this.color ? 2 : 1;
        if (this.aperture.hasDiagonalSymmetry()) {
            n2 = n8;
            while (n2 <= n3) {
                n5 = 0;
                while (n5 != n6) {
                    n = 0;
                    while (n <= n5) {
                        this.func[n][n5][n2] = this.func[n5][n][n2];
                        ++n;
                    }
                    ++n5;
                }
                ++n2;
            }
        }
        if (this.aperture.hasXSymmetry()) {
            n2 = n8;
            while (n2 <= n3) {
                n5 = 0;
                while (n5 != n6) {
                    n = 0;
                    while (n != n7) {
                        this.func[this.gridSizeX - 1 - n5][n][n2] = this.func[n5][n][n2];
                        ++n;
                    }
                    ++n5;
                }
                ++n2;
            }
        }
        if (this.aperture.hasYSymmetry()) {
            n2 = n8;
            while (n2 <= n3) {
                n5 = 0;
                while (n5 != this.gridSizeX) {
                    n = 0;
                    while (n != n7) {
                        this.func[n5][this.gridSizeX - 1 - n][n2] = this.func[n5][n][n2];
                        ++n;
                    }
                    ++n5;
                }
                ++n2;
            }
        }
        this.functionChanged = false;
    }

    void setFunction(int n, int n2) {
        int n3 = 1;
        int n4 = 1;
        if (this.color) {
            n3 = 0;
            n4 = 2;
        }
        int n5 = n3;
        while (n5 <= n4) {
            double d;
            double d2 = (double)this.accumR[n5] / (double)(this.angleSteps * 256);
            double d3 = (double)this.accumI[n5] / (double)(this.angleSteps * 256);
            this.func[n][n2][n5] = d = d2 * d2 + d3 * d3;
            ++n5;
        }
    }

    void clearAccum() {
        int n = 0;
        while (n != 3) {
            this.accumI[n] = 0;
            this.accumR[n] = 0;
            ++n;
        }
    }

    void apertureStart(double d) {
        double d2 = d * d;
        int n = (int)(d2 * this.apertureArgMult) & this.angleSteps2Mask;
        this.accumR[1] = (int)((long)this.accumR[1] - this.angcos2[n]);
        this.accumI[1] = (int)((long)this.accumI[1] - this.angsin2[n]);
        if (this.color) {
            n = (int)(d2 * this.apertureArgMultRed) & this.angleSteps2Mask;
            this.accumR[0] = (int)((long)this.accumR[0] - this.angcos2[n]);
            this.accumI[0] = (int)((long)this.accumI[0] - this.angsin2[n]);
            n = (int)(d2 * this.apertureArgMultBlue) & this.angleSteps2Mask;
            this.accumR[2] = (int)((long)this.accumR[2] - this.angcos2[n]);
            this.accumI[2] = (int)((long)this.accumI[2] - this.angsin2[n]);
        }
    }

    void apertureStop(double d) {
        double d2 = d * d;
        int n = (int)(d2 * this.apertureArgMult) & this.angleSteps2Mask;
        this.accumR[1] = (int)((long)this.accumR[1] + this.angcos2[n]);
        this.accumI[1] = (int)((long)this.accumI[1] + this.angsin2[n]);
        if (this.color) {
            n = (int)(d2 * this.apertureArgMultRed) & this.angleSteps2Mask;
            this.accumR[0] = (int)((long)this.accumR[0] + this.angcos2[n]);
            this.accumI[0] = (int)((long)this.accumI[0] + this.angsin2[n]);
            n = (int)(d2 * this.apertureArgMultBlue) & this.angleSteps2Mask;
            this.accumR[2] = (int)((long)this.accumR[2] + this.angcos2[n]);
            this.accumI[2] = (int)((long)this.accumI[2] + this.angsin2[n]);
        }
    }

    void apertureStartOrigin(boolean bl) {
        if (this.reversed) {
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            this.accumR[1] = this.accumR[1] - 256 * this.angleSteps;
            if (this.color) {
                this.accumR[0] = this.accumR[0] - 256 * this.angleSteps;
                this.accumR[2] = this.accumR[2] - 256 * this.angleSteps;
            }
        }
    }

    int sign(double d) {
        return d < 0.0 ? -1 : 1;
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateDiffraction(Graphics graphics) {
        Object object;
        boolean bl;
        boolean bl2 = bl = this.dragging && this.aperture.hideWhileDragging();
        if (this.functionChanged) {
            graphics.setColor(this.cv.getBackground());
            object = graphics.getFontMetrics();
            String string = "Calculating...";
            graphics.fillRect(0, this.fullWinSize.height - 30, 20 + ((FontMetrics)object).stringWidth(string), 30);
            graphics.setColor(Color.white);
            graphics.drawString(string, 10, this.fullWinSize.height - 10);
            this.computeFunction();
        }
        object = null;
        if (this.winSize == null || this.winSize.width == 0) {
            return;
        }
        boolean bl3 = this.memoryImageSourceCheck.getState();
        object = this.dbimage.getGraphics();
        ((Graphics)object).setColor(this.cv.getBackground());
        ((Graphics)object).fillRect(0, 0, this.fullWinSize.width, this.fullWinSize.height);
        ((Graphics)object).setColor(this.cv.getForeground());
        this.colorMult = 70.0 * Math.exp((double)this.brightnessBar.getValue() / 50.0);
        if (!bl) {
            int n = 0;
            while (n != this.gridSizeX) {
                int n2 = 0;
                while (n2 != this.gridSizeY) {
                    int n3;
                    int n4 = n * this.winSize.width / this.gridSizeX;
                    int n5 = n2 * this.winSize.height / this.gridSizeY;
                    int n6 = (n + 1) * this.winSize.width / this.gridSizeX;
                    int n7 = (n2 + 1) * this.winSize.height / this.gridSizeY;
                    int n8 = 0;
                    if (!this.color) {
                        n3 = this.getColorValue(n, n2, 1);
                        n8 = 0xFF000000 | n3 * 65793;
                    } else {
                        n8 = -16777216 + (this.getColorValue(n, n2, 0) << 16) | this.getColorValue(n, n2, 1) << 8 | this.getColorValue(n, n2, 2);
                    }
                    if (bl3) {
                        n3 = n4;
                        while (n3 < n6) {
                            int n9 = n5;
                            while (n9 < n7) {
                                this.pixels[n3 + n9 * this.winSize.width] = n8;
                                ++n9;
                            }
                            ++n3;
                        }
                    } else {
                        ((Graphics)object).setColor(new Color(n8));
                        ((Graphics)object).fillRect(n4, n5, n6 - n4, n7 - n5);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if (bl3 && !bl) {
            Image image = this.cv.createImage(this.imageSource);
            ((Graphics)object).drawImage(image, 0, 0, null);
        }
        ((Graphics)object).setColor(Color.red);
        this.aperture.drawGeometricShadow((Graphics)object);
        if (this.sizeCheck.getState()) {
            ((Graphics)object).setColor(this.cv.getBackground());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            double d = 5.1E-7;
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            double d2 = Math.exp((double)this.lengthBar.getValue() / 110.0) / this.zoomFactor;
            double d3 = this.aperture.getDimension() * d2 * Math.sqrt(d * 2.0);
            String string = "width = ";
            string = d3 > 0.001 ? string + numberFormat.format(d3 * 1000.0) + " mm" : (d3 > 1.0E-6 ? string + numberFormat.format(d3 * 1000000.0) + " \u00b5m" : string + numberFormat.format(d3 * 1.0E9) + " nm");
            int n = fontMetrics.stringWidth(string);
            if (d3 > 0.0) {
                ((Graphics)object).fillRect(this.fullWinSize.width - (20 + n), this.fullWinSize.height - 30, 20 + n, 30);
                ((Graphics)object).setColor(Color.white);
                ((Graphics)object).drawString(string, this.fullWinSize.width - (10 + n), this.fullWinSize.height - 10);
            }
        }
        graphics.drawImage(this.dbimage, 0, 0, this);
    }

    int getColorValue(int n, int n2, int n3) {
        int n4 = (int)(this.func[n][n2][n3] * this.colorMult);
        if (n4 > 255) {
            n4 = 255;
        }
        return n4;
    }

    void doZoom() {
        double d = Math.exp((double)this.zoomBar.getValue() / 50.0) * this.zbase;
        double d2 = Math.exp((double)this.oldZoom / 50.0) * this.zbase;
        double d3 = d / d2;
        this.oldZoom = this.zoomBar.getValue();
        this.aperture.rezoom(d3);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(100L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.defaultsButton) {
            this.colorCheck.setState(false);
            this.reversedCheck.setState(false);
            this.lengthBar.setValue(260);
            this.gridBar.setValue(90);
            this.oldZoom = 200;
            this.zoomBar.setValue(200);
            this.functionChanged = true;
            this.brightnessBar.setValue(this.aperture.defaultBrightness());
            this.aperture.setToDefaults();
            this.cv.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        System.out.print(((Scrollbar)adjustmentEvent.getSource()).getValue() + "\n");
        if (adjustmentEvent.getSource() != this.brightnessBar) {
            this.functionChanged = true;
        }
        if (adjustmentEvent.getSource() == this.zoomBar) {
            this.doZoom();
        }
        this.cv.repaint(100L);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selection != -1) {
            this.dragging = true;
            if (this.aperture.drag(mouseEvent.getX(), mouseEvent.getY())) {
                this.cv.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.selection != -1) {
                this.dragging = true;
                if (this.aperture.drag(mouseEvent.getX(), mouseEvent.getY())) {
                    this.cv.repaint();
                }
            }
            return;
        }
        int n = this.selection;
        this.selection = this.aperture.getSelection(mouseEvent.getX(), mouseEvent.getY());
        if (this.selection != n) {
            this.cv.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.dragging && this.selection != -1) {
            this.selection = -1;
            this.cv.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.selection != -1) {
            this.dragging = true;
            if (this.aperture.drag(mouseEvent.getX(), mouseEvent.getY())) {
                this.cv.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragging) {
            this.functionChanged = true;
            this.cv.repaint();
        }
        this.dragging = false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() != this.memoryImageSourceCheck && itemEvent.getSource() != this.sizeCheck) {
            this.functionChanged = true;
        }
        if (itemEvent.getSource() == this.apertureChooser) {
            this.aperture = (Aperture)this.apertureList.elementAt(this.apertureChooser.getSelectedIndex());
            this.brightnessBar.setValue(this.aperture.defaultBrightness());
            this.oldZoom = 200;
            this.zoomBar.setValue(200);
        }
        this.cv.repaint(100L);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }

    int fresnl(double d, double[] dArray) {
        double d2;
        double d3;
        double d4 = Math.abs(d);
        double d5 = d4 * d4;
        if (d5 < 2.5625) {
            double d6 = d5 * d5;
            d3 = d4 * d5 * this.polevl(d6, sn, 5) / this.p1evl(d6, sd, 6);
            d2 = d4 * this.polevl(d6, cn, 5) / this.polevl(d6, cd, 6);
        } else if (d4 > 36974.0) {
            d2 = 0.5;
            d3 = 0.5;
        } else {
            d5 = d4 * d4;
            double d7 = Math.PI * d5;
            double d8 = 1.0 / (d7 * d7);
            d7 = 1.0 / d7;
            double d9 = 1.0 - d8 * this.polevl(d8, fn, 9) / this.p1evl(d8, fd, 10);
            double d10 = d7 * this.polevl(d8, gn, 10) / this.p1evl(d8, gd, 11);
            d7 = 1.5707963267948966 * d5;
            double d11 = Math.cos(d7);
            double d12 = Math.sin(d7);
            d7 = Math.PI * d4;
            d2 = 0.5 + (d9 * d12 - d10 * d11) / d7;
            d3 = 0.5 - (d9 * d11 + d10 * d12) / d7;
        }
        if (d < 0.0) {
            d2 = -d2;
            d3 = -d3;
        }
        dArray[0] = d2;
        dArray[1] = d3;
        return 0;
    }

    double polevl(double d, double[] dArray, int n) {
        int n2 = 0;
        double d2 = dArray[n2++];
        int n3 = n;
        do {
            d2 = d2 * d + dArray[n2++];
        } while (--n3 > 0);
        return d2;
    }

    double p1evl(double d, double[] dArray, int n) {
        int n2 = 0;
        double d2 = d + dArray[n2++];
        int n3 = n - 1;
        do {
            d2 = d2 * d + dArray[n2++];
        } while (--n3 > 0);
        return d2;
    }

    class DoubleCircleAperture
    extends Aperture {
        double radius;
        double offset;

        DoubleCircleAperture() {
        }

        String getName() {
            return "2 circles";
        }

        Aperture createNext() {
            return null;
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.radius = 0.3;
            this.offset = 0.25;
        }

        double getDimension() {
            return (this.radius + this.offset) * 2.0;
        }

        void compute() {
            double d;
            boolean bl;
            double[] dArray = new double[4];
            double d2 = this.offset;
            double d3 = 0.0;
            boolean bl2 = bl = this.offset < this.radius;
            if (bl) {
                d3 = Math.sqrt(this.radius * this.radius - this.offset * this.offset);
                d = this.radius - 2.0 * this.offset;
                if (d > 0.0) {
                    d2 = this.offset + d;
                }
            }
            int n = 0;
            while (n != DiffractionFrame.this.gridSizeX / 2) {
                int n2 = 0;
                while (n2 != DiffractionFrame.this.gridSizeY / 2) {
                    DiffractionFrame.this.clearAccum();
                    d = (double)n / (double)DiffractionFrame.this.gridSizeX - 0.5;
                    double d4 = (double)n2 / (double)DiffractionFrame.this.gridSizeY - 0.5;
                    double d5 = -d + this.offset;
                    double d6 = -d - this.offset;
                    double d7 = -d4;
                    double d8 = d5 * d5 + d7 * d7;
                    double d9 = d6 * d6 + d7 * d7;
                    double d10 = this.radius * this.radius;
                    double d11 = d8 - d10;
                    double d12 = d9 - d10;
                    double d13 = d11 * 4.0;
                    double d14 = d12 * 4.0;
                    double d15 = 0.0;
                    double d16 = Math.PI * 2;
                    int n3 = (int)(d15 * (double)DiffractionFrame.this.angleSteps / (Math.PI * 2));
                    int n4 = (int)(d16 * (double)DiffractionFrame.this.angleSteps / (Math.PI * 2));
                    while (n3 < 0) {
                        n3 += DiffractionFrame.this.angleSteps;
                        n4 += DiffractionFrame.this.angleSteps;
                    }
                    boolean bl3 = d11 < 0.0 || d12 < 0.0;
                    DiffractionFrame.this.apertureStartOrigin(bl3);
                    int n5 = n3;
                    while (n5 < n4) {
                        double d17 = DiffractionFrame.this.angcos1[n5 & DiffractionFrame.this.angleStepsMask];
                        double d18 = DiffractionFrame.this.angsin1[n5 & DiffractionFrame.this.angleStepsMask];
                        double d19 = -2.0 * (d17 * d5 + d18 * d7);
                        double d20 = -2.0 * (d17 * d6 + d18 * d7);
                        double d21 = d19 * d19 - d13;
                        double d22 = d20 * d20 - d14;
                        if (!(d21 < 0.0) || !(d22 < 0.0)) {
                            int n6 = 0;
                            if (d21 >= 0.0) {
                                d21 = Math.sqrt(d21);
                                dArray[n6++] = 0.5 * (-d19 - d21);
                                dArray[n6++] = 0.5 * (-d19 + d21);
                            }
                            if (d22 >= 0.0) {
                                d22 = Math.sqrt(d22);
                                dArray[n6++] = 0.5 * (-d20 - d22);
                                dArray[n6++] = 0.5 * (-d20 + d22);
                            }
                            int n7 = 1;
                            while (n7 < n6) {
                                double d23 = dArray[n7];
                                int n8 = n7;
                                while (dArray[n8 - 1] > d23) {
                                    dArray[n8] = dArray[n8 - 1];
                                    if (--n8 <= 0) break;
                                }
                                dArray[n8] = d23;
                                ++n7;
                            }
                            boolean bl4 = bl3;
                            n7 = 0;
                            while (n7 != n6) {
                                double d24 = dArray[n7];
                                if (!(d24 < 0.0)) {
                                    double d25;
                                    double d26 = d + d17 * d24;
                                    double d27 = d4 + d18 * d24;
                                    if (!(bl && d26 > -d2 && d26 < d2 && d27 > -d3 && d27 < d3 && ((d26 - this.offset) * (d26 - this.offset) + (d25 = d27 * d27) < d10 || (d26 + this.offset) * (d26 + this.offset) + d25 < d10))) {
                                        if (!bl4) {
                                            DiffractionFrame.this.apertureStart(dArray[n7]);
                                            bl4 = true;
                                        } else {
                                            DiffractionFrame.this.apertureStop(dArray[n7]);
                                            bl4 = false;
                                        }
                                    }
                                }
                                ++n7;
                            }
                        }
                        ++n5;
                    }
                    DiffractionFrame.this.setFunction(n, n2);
                    ++n2;
                }
                ++n;
            }
        }

        void drawGeometricShadow(Graphics graphics) {
            int n;
            int n2 = (int)((double)DiffractionFrame.this.winSize.width * this.radius);
            int n3 = (int)((double)DiffractionFrame.this.winSize.width * this.offset);
            if (DiffractionFrame.this.selection != -1) {
                graphics.setColor(DiffractionFrame.this.selection == 0 ? Color.yellow : Color.red);
                n = 5;
                graphics.fillOval(DiffractionFrame.this.winSize.width / 2 - n3 - n, DiffractionFrame.this.winSize.height / 2 - n, n * 2, n * 2);
                graphics.fillOval(DiffractionFrame.this.winSize.width / 2 + n3 - n, DiffractionFrame.this.winSize.height / 2 - n, n * 2, n * 2);
            }
            graphics.setColor(DiffractionFrame.this.selection > 0 ? Color.yellow : Color.red);
            n = 0;
            if (this.offset < this.radius) {
                n = (int)(Math.acos(this.offset / this.radius) * 57.29577951308232);
            }
            graphics.drawArc(DiffractionFrame.this.winSize.width / 2 - n2 - n3, DiffractionFrame.this.winSize.height / 2 - n2, n2 * 2, n2 * 2, n, 360 - 2 * n);
            graphics.drawArc(DiffractionFrame.this.winSize.width / 2 - n2 + n3, DiffractionFrame.this.winSize.height / 2 - n2, n2 * 2, n2 * 2, 180 + n, 360 - 2 * n);
        }

        int getSelection(int n, int n2) {
            int n3 = (int)((double)DiffractionFrame.this.winSize.width * this.offset);
            int n4 = DiffractionFrame.this.winSize.width / 2 - n3 - n;
            int n5 = DiffractionFrame.this.winSize.width / 2 + n3 - n;
            int n6 = DiffractionFrame.this.winSize.height / 2 - n2;
            double d = Math.sqrt(n4 * n4 + n6 * n6) / (double)DiffractionFrame.this.winSize.width;
            if (Math.abs(d - this.radius) < 5.0 / (double)DiffractionFrame.this.winSize.width) {
                return 1;
            }
            if (d < 5.0 / (double)DiffractionFrame.this.winSize.width) {
                return 0;
            }
            d = Math.sqrt(n5 * n5 + n6 * n6) / (double)DiffractionFrame.this.winSize.width;
            if (Math.abs(d - this.radius) < 5.0 / (double)DiffractionFrame.this.winSize.width) {
                return 2;
            }
            if (d < 5.0 / (double)DiffractionFrame.this.winSize.width) {
                return 0;
            }
            return -1;
        }

        boolean drag(int n, int n2) {
            int n3;
            if (DiffractionFrame.this.selection == 0) {
                double d = (double)n / (double)DiffractionFrame.this.winSize.width - 0.5;
                double d2 = Math.abs(d);
                if (d2 == this.offset) {
                    return false;
                }
                this.offset = d2;
                return true;
            }
            int n4 = (int)((double)DiffractionFrame.this.winSize.width * this.offset);
            int n5 = DiffractionFrame.this.winSize.width / 2 - n4 - n;
            int n6 = DiffractionFrame.this.winSize.width / 2 + n4 - n;
            double d = DiffractionFrame.this.selection == 2 ? (double)(n6 * n6) : (double)(n5 * n5);
            double d3 = Math.sqrt(d + (double)((n3 = DiffractionFrame.this.winSize.height / 2 - n2) * n3)) / (double)DiffractionFrame.this.winSize.width;
            if (d3 == this.radius) {
                return false;
            }
            this.radius = d3;
            return true;
        }

        void rezoom(double d) {
            this.radius *= d;
            this.offset *= d;
        }
    }

    abstract class BlockAperture
    extends Aperture {
        int blockCountX;
        int blockCountY;
        boolean[][] blocks;
        double[] lineXLocations;
        double[] lineYLocations;
        int rectCount;
        double[][] rects;

        BlockAperture() {
        }

        abstract void setupRects();

        void compute() {
            this.setupRects();
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[2];
            int n = 1;
            int n2 = 1;
            if (DiffractionFrame.this.color) {
                n = 0;
                n2 = 2;
            }
            double d = DiffractionFrame.this.reversedCheck.getState() ? -1.0 : 0.0;
            int n3 = this.hasXSymmetry() ? DiffractionFrame.this.gridSizeX / 2 : DiffractionFrame.this.gridSizeX;
            int n4 = this.hasYSymmetry() ? DiffractionFrame.this.gridSizeY / 2 : DiffractionFrame.this.gridSizeY;
            int n5 = 0;
            while (n5 != n3) {
                if (this.hasDiagonalSymmetry()) {
                    n4 = n5 + 1;
                }
                double d2 = (double)n5 / (double)DiffractionFrame.this.gridSizeX - 0.5;
                int n6 = 0;
                while (n6 != n4) {
                    double d3 = (double)n6 / (double)DiffractionFrame.this.gridSizeY - 0.5;
                    int n7 = n;
                    while (n7 <= n2) {
                        double d4 = DiffractionFrame.this.colorLenMults[n7];
                        double d5 = 0.0;
                        double d6 = d;
                        int n8 = 0;
                        while (n8 != this.rectCount) {
                            DiffractionFrame.this.fresnl((this.rects[n8][0] - d2) * d4, dArray);
                            DiffractionFrame.this.fresnl((this.rects[n8][2] - d2) * d4, dArray2);
                            DiffractionFrame.this.fresnl((this.rects[n8][1] - d3) * d4, dArray3);
                            DiffractionFrame.this.fresnl((this.rects[n8][3] - d3) * d4, dArray4);
                            double d7 = dArray[0] - dArray2[0];
                            double d8 = dArray[1] - dArray2[1];
                            double d9 = dArray3[0] - dArray4[0];
                            double d10 = dArray3[1] - dArray4[1];
                            d5 += this.rects[n8][4] * (d7 * d9 - d8 * d10);
                            d6 += this.rects[n8][4] * (d7 * d10 + d8 * d9);
                            ++n8;
                        }
                        DiffractionFrame.this.func[n5][n6][n7] = d5 * d5 + d6 * d6;
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        }

        void drawGeometricShadow(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = 1;
            while (n5 < this.blockCountX) {
                n4 = 0;
                while (n4 < this.blockCountY) {
                    if (this.blocks[n5 - 1][n4] != this.blocks[n5 + 1][n4]) {
                        n3 = (int)((this.lineXLocations[n5] + 0.5) * (double)DiffractionFrame.this.winSize.width);
                        n2 = 0;
                        n = DiffractionFrame.this.winSize.height;
                        try {
                            n2 = (int)((this.lineYLocations[n4 - 1] + 0.5) * (double)DiffractionFrame.this.winSize.height);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            n = (int)((this.lineYLocations[n4 + 1] + 0.5) * (double)DiffractionFrame.this.winSize.height);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        graphics.setColor(this.isSelected(n5, -1) ? Color.yellow : Color.red);
                        graphics.drawLine(n3, n2, n3, n);
                    }
                    n4 += 2;
                }
                n5 += 2;
            }
            n5 = 0;
            while (n5 < this.blockCountX) {
                n4 = 1;
                while (n4 < this.blockCountY) {
                    if (this.blocks[n5][n4 - 1] != this.blocks[n5][n4 + 1]) {
                        n3 = (int)((this.lineYLocations[n4] + 0.5) * (double)DiffractionFrame.this.winSize.height);
                        n2 = 0;
                        n = DiffractionFrame.this.winSize.width;
                        try {
                            n2 = (int)((this.lineXLocations[n5 - 1] + 0.5) * (double)DiffractionFrame.this.winSize.width);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            n = (int)((this.lineXLocations[n5 + 1] + 0.5) * (double)DiffractionFrame.this.winSize.width);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        graphics.setColor(this.isSelected(-1, n4) ? Color.yellow : Color.red);
                        graphics.drawLine(n2, n3, n, n3);
                    }
                    n4 += 2;
                }
                n5 += 2;
            }
        }

        boolean isSelected(int n, int n2) {
            return this.isSelected(n, n2, 0);
        }

        boolean isSelected(int n, int n2, int n3) {
            if (DiffractionFrame.this.selection == -1) {
                return false;
            }
            if (DiffractionFrame.this.selection == n + 100 || DiffractionFrame.this.selection == n2 + 200) {
                return true;
            }
            if (this.hasXSymmetry() && n3 < 1 && this.blockCountX > 3 && this.isSelected(this.blockCountX - 1 - n, n2, 1)) {
                return true;
            }
            if (this.hasYSymmetry() && n3 < 2 && this.blockCountY > 3 && this.isSelected(n, this.blockCountY - 1 - n2, 2)) {
                return true;
            }
            return this.hasDiagonalSymmetry() && n3 < 3 && this.isSelected(n2, n, 3);
        }

        int getSelection(int n, int n2) {
            double d;
            double d2 = (double)n / (double)DiffractionFrame.this.winSize.width - 0.5;
            double d3 = (double)n2 / (double)DiffractionFrame.this.winSize.width - 0.5;
            double d4 = 3.0 / (double)DiffractionFrame.this.winSize.width;
            int n3 = -1;
            int n4 = 1;
            while (n4 < this.blockCountX) {
                d = Math.abs(this.lineXLocations[n4] - d2);
                if (d < d4) {
                    n3 = 100 + n4;
                    d4 = d;
                }
                n4 += 2;
            }
            n4 = 1;
            while (n4 < this.blockCountY) {
                d = Math.abs(this.lineYLocations[n4] - d3);
                if (d < d4) {
                    n3 = 200 + n4;
                    d4 = d;
                }
                n4 += 2;
            }
            return n3;
        }

        boolean drag(int n, int n2) {
            double d = (double)n / (double)DiffractionFrame.this.winSize.width - 0.5;
            double d2 = (double)n2 / (double)DiffractionFrame.this.winSize.width - 0.5;
            if (DiffractionFrame.this.selection >= 200) {
                return this.dragLine(-1, DiffractionFrame.this.selection - 200, d2, 0);
            }
            return this.dragLine(DiffractionFrame.this.selection - 100, -1, d, 0);
        }

        void rezoom(double d) {
            int n = 1;
            while (n < this.blockCountX) {
                int n2 = n;
                this.lineXLocations[n2] = this.lineXLocations[n2] * d;
                n += 2;
            }
            n = 1;
            while (n < this.blockCountY) {
                int n3 = n;
                this.lineYLocations[n3] = this.lineYLocations[n3] * d;
                n += 2;
            }
        }

        boolean dragLine(int n, int n2, double d, int n3) {
            if (n != -1) {
                if (this.hasXSymmetry() && DiffractionFrame.this.sign(this.lineXLocations[n]) != DiffractionFrame.this.sign(d)) {
                    return false;
                }
                if (n > 1 && d <= this.lineXLocations[n - 2]) {
                    return false;
                }
                if (n < this.blockCountX - 2 && d >= this.lineXLocations[n + 2]) {
                    return false;
                }
            }
            if (n2 != -1) {
                if (this.hasYSymmetry() && DiffractionFrame.this.sign(this.lineYLocations[n2]) != DiffractionFrame.this.sign(d)) {
                    return false;
                }
                if (n2 > 1 && d <= this.lineYLocations[n2 - 2]) {
                    return false;
                }
                if (n2 < this.blockCountY - 2 && d >= this.lineYLocations[n2 + 2]) {
                    return false;
                }
            }
            if (n != -1 && this.hasXSymmetry() && n3 < 1) {
                this.dragLine(this.blockCountX - 1 - n, n2, -d, 1);
            }
            if (n2 != -1 && this.hasYSymmetry() && n3 < 2) {
                this.dragLine(n, this.blockCountY - 1 - n2, -d, 2);
            }
            if (this.hasDiagonalSymmetry() && n3 < 3) {
                this.dragLine(n2, n, d, 3);
            }
            if (n != -1) {
                this.lineXLocations[n] = d;
            }
            if (n2 != -1) {
                this.lineYLocations[n2] = d;
            }
            return true;
        }

        double getDimension() {
            return this.lineXLocations[this.blockCountX - 2] - this.lineXLocations[1];
        }
    }

    class IntersectingSquaresAperture
    extends BlockAperture {
        IntersectingSquaresAperture() {
        }

        String getName() {
            return "2 squares";
        }

        Aperture createNext() {
            return new DoubleCircleAperture();
        }

        boolean hasDiagonalSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.blockCountY = 9;
            this.blockCountX = 9;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            int n = 2;
            while (n <= 6) {
                this.blocks[4][n] = true;
                this.blocks[n][4] = true;
                n += 2;
            }
            this.blocks[6][6] = true;
            this.blocks[2][2] = true;
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = -0.375;
            this.lineXLocations[3] = -0.125;
            this.lineXLocations[5] = 0.125;
            this.lineXLocations[7] = 0.375;
            this.lineYLocations[1] = -0.375;
            this.lineYLocations[3] = -0.125;
            this.lineYLocations[5] = 0.125;
            this.lineYLocations[7] = 0.375;
        }

        void setupRects() {
            this.rectCount = 3;
            this.rects = new double[3][5];
            this.rects[0][0] = this.lineXLocations[1];
            this.rects[0][1] = this.lineYLocations[1];
            this.rects[0][2] = this.lineXLocations[5];
            this.rects[0][3] = this.lineYLocations[5];
            this.rects[0][4] = 0.5;
            this.rects[1][0] = this.lineXLocations[3];
            this.rects[1][1] = this.lineYLocations[3];
            this.rects[1][2] = this.lineXLocations[7];
            this.rects[1][3] = this.lineYLocations[7];
            this.rects[1][4] = 0.5;
            this.rects[2][0] = this.lineXLocations[3];
            this.rects[2][1] = this.lineYLocations[3];
            this.rects[2][2] = this.lineXLocations[5];
            this.rects[2][3] = this.lineYLocations[5];
            this.rects[2][4] = -0.5;
        }
    }

    class PlusAperture
    extends BlockAperture {
        PlusAperture() {
        }

        String getName() {
            return "plus";
        }

        Aperture createNext() {
            return new IntersectingSquaresAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        boolean hasDiagonalSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.blockCountY = 9;
            this.blockCountX = 9;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            int n = 2;
            while (n <= 6) {
                this.blocks[4][n] = true;
                this.blocks[n][4] = true;
                n += 2;
            }
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = -0.375;
            this.lineXLocations[3] = -0.125;
            this.lineXLocations[5] = 0.125;
            this.lineXLocations[7] = 0.375;
            this.lineYLocations[1] = -0.375;
            this.lineYLocations[3] = -0.125;
            this.lineYLocations[5] = 0.125;
            this.lineYLocations[7] = 0.375;
        }

        void setupRects() {
            this.rectCount = 3;
            this.rects = new double[3][5];
            this.rects[0][0] = this.lineXLocations[1];
            this.rects[0][1] = this.lineYLocations[3];
            this.rects[0][2] = this.lineXLocations[7];
            this.rects[0][3] = this.lineYLocations[5];
            this.rects[0][4] = 0.5;
            this.rects[1][0] = this.lineXLocations[3];
            this.rects[1][1] = this.lineYLocations[1];
            this.rects[1][2] = this.lineXLocations[5];
            this.rects[1][3] = this.lineYLocations[7];
            this.rects[1][4] = 0.5;
            this.rects[2][0] = this.lineXLocations[3];
            this.rects[2][1] = this.lineYLocations[3];
            this.rects[2][2] = this.lineXLocations[5];
            this.rects[2][3] = this.lineYLocations[5];
            this.rects[2][4] = -0.5;
        }
    }

    class FrameAperture
    extends BlockAperture {
        FrameAperture() {
        }

        String getName() {
            return "frame";
        }

        Aperture createNext() {
            return new PlusAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        boolean hasDiagonalSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.blockCountY = 9;
            this.blockCountX = 9;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            int n = 2;
            while (n <= 6) {
                this.blocks[6][n] = true;
                this.blocks[2][n] = true;
                this.blocks[n][6] = true;
                this.blocks[n][2] = true;
                n += 2;
            }
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = -0.375;
            this.lineXLocations[3] = -0.125;
            this.lineXLocations[5] = 0.125;
            this.lineXLocations[7] = 0.375;
            this.lineYLocations[1] = -0.375;
            this.lineYLocations[3] = -0.125;
            this.lineYLocations[5] = 0.125;
            this.lineYLocations[7] = 0.375;
        }

        void setupRects() {
            this.rectCount = 2;
            this.rects = new double[2][5];
            this.rects[0][0] = this.lineXLocations[1];
            this.rects[0][1] = this.lineYLocations[1];
            this.rects[0][2] = this.lineXLocations[7];
            this.rects[0][3] = this.lineYLocations[7];
            this.rects[0][4] = 0.5;
            this.rects[1][0] = this.lineXLocations[3];
            this.rects[1][1] = this.lineYLocations[3];
            this.rects[1][2] = this.lineXLocations[5];
            this.rects[1][3] = this.lineYLocations[5];
            this.rects[1][4] = -0.5;
        }
    }

    class RectanglesAperture
    extends BlockAperture {
        RectanglesAperture() {
        }

        String getName() {
            return "2 rectangles";
        }

        Aperture createNext() {
            return new FrameAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.blockCountX = 9;
            this.blockCountY = 5;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            this.blocks[6][2] = true;
            this.blocks[2][2] = true;
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = -0.375;
            this.lineXLocations[3] = -0.125;
            this.lineXLocations[5] = 0.125;
            this.lineXLocations[7] = 0.375;
            this.lineYLocations[1] = -0.25;
            this.lineYLocations[3] = 0.25;
        }

        void setupRects() {
            this.rectCount = 2;
            this.rects = new double[2][5];
            double d = this.lineXLocations[1];
            this.rects[0][0] = this.lineXLocations[1];
            this.rects[0][1] = this.lineYLocations[1];
            this.rects[0][2] = this.lineXLocations[3];
            this.rects[0][3] = this.lineYLocations[3];
            this.rects[0][4] = 0.5;
            this.rects[1][0] = this.lineXLocations[5];
            this.rects[1][1] = this.lineYLocations[1];
            this.rects[1][2] = this.lineXLocations[7];
            this.rects[1][3] = this.lineYLocations[3];
            this.rects[1][4] = 0.5;
        }
    }

    class CrossAperture
    extends BlockAperture {
        CrossAperture() {
        }

        String getName() {
            return "cross";
        }

        Aperture createNext() {
            return new RectanglesAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        boolean hasDiagonalSymmetry() {
            return true;
        }

        void setToDefaults() {
            double d = 0.0625;
            this.blockCountY = 5;
            this.blockCountX = 5;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            this.blocks[2][4] = true;
            this.blocks[2][0] = true;
            this.blocks[4][2] = true;
            this.blocks[2][2] = true;
            this.blocks[0][2] = true;
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = -d;
            this.lineXLocations[3] = d;
            this.lineYLocations[1] = -d;
            this.lineYLocations[3] = d;
        }

        void setupRects() {
            this.rectCount = 3;
            this.rects = new double[3][5];
            double d = this.lineXLocations[3];
            this.rects[0][0] = -d;
            this.rects[0][1] = -1.0E8;
            this.rects[0][2] = d;
            this.rects[0][3] = 1.0E8;
            this.rects[0][4] = 0.5;
            this.rects[1][0] = -1.0E8;
            this.rects[1][1] = -d;
            this.rects[1][2] = 1.0E8;
            this.rects[1][3] = d;
            this.rects[1][4] = 0.5;
            this.rects[2][0] = -d;
            this.rects[2][1] = -d;
            this.rects[2][2] = d;
            this.rects[2][3] = d;
            this.rects[2][4] = -0.5;
        }

        double getDimension() {
            return 1.0;
        }
    }

    class CornerAperture
    extends BlockAperture {
        CornerAperture() {
        }

        String getName() {
            return "corner";
        }

        Aperture createNext() {
            return new CrossAperture();
        }

        boolean hasDiagonalSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.blockCountY = 3;
            this.blockCountX = 3;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            this.blocks[2][2] = true;
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = 0.0;
            this.lineYLocations[1] = 0.0;
        }

        void setupRects() {
            double d;
            this.rectCount = 1;
            this.rects = new double[1][5];
            this.rects[0][0] = d = this.lineXLocations[1];
            this.rects[0][1] = d;
            this.rects[0][2] = 1.0E8;
            this.rects[0][3] = 1.0E8;
            this.rects[0][4] = 0.5;
        }

        double getDimension() {
            return 0.5 - this.lineXLocations[1];
        }
    }

    class RectangularAperture
    extends BlockAperture {
        RectangularAperture() {
        }

        String getName() {
            return "rectangle";
        }

        Aperture createNext() {
            return new CornerAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.blockCountY = 5;
            this.blockCountX = 5;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            this.blocks[2][2] = true;
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = -0.25;
            this.lineXLocations[3] = 0.25;
            this.lineYLocations[1] = -0.4;
            this.lineYLocations[3] = 0.4;
        }

        void setupRects() {
            this.rectCount = 1;
            this.rects = new double[1][5];
            this.rects[0][0] = this.lineXLocations[1];
            this.rects[0][1] = this.lineYLocations[1];
            this.rects[0][2] = this.lineXLocations[3];
            this.rects[0][3] = this.lineYLocations[3];
            this.rects[0][4] = 0.5;
        }
    }

    class SquareAperture
    extends BlockAperture {
        SquareAperture() {
        }

        String getName() {
            return "square";
        }

        Aperture createNext() {
            return new RectangularAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        boolean hasDiagonalSymmetry() {
            return true;
        }

        void setToDefaults() {
            double d = 0.25;
            this.blockCountY = 5;
            this.blockCountX = 5;
            this.blocks = new boolean[this.blockCountX][this.blockCountY];
            this.blocks[2][2] = true;
            this.lineXLocations = new double[this.blockCountX];
            this.lineYLocations = new double[this.blockCountY];
            this.lineXLocations[1] = -d;
            this.lineXLocations[3] = d;
            this.lineYLocations[1] = -d;
            this.lineYLocations[3] = d;
        }

        void setupRects() {
            this.rectCount = 1;
            this.rects = new double[1][5];
            double d = this.lineXLocations[3];
            this.rects[0][0] = -d;
            this.rects[0][1] = -d;
            this.rects[0][2] = d;
            this.rects[0][3] = d;
            this.rects[0][4] = 0.5;
        }
    }

    class TripleSlitAperture
    extends OneDimensionalAperture {
        TripleSlitAperture() {
        }

        void setToDefaults() {
            this.lineCount = 6;
            this.lineLocations = new double[6];
            this.lineLocations[0] = -0.1533;
            this.lineLocations[1] = -0.1133;
            this.lineLocations[2] = -0.02;
            this.lineLocations[3] = 0.02;
            this.lineLocations[4] = 0.1133;
            this.lineLocations[5] = 0.1533;
        }

        int defaultBrightness() {
            return 210;
        }

        String getName() {
            return "triple slit";
        }

        Aperture createNext() {
            return new SquareAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }
    }

    class DoubleSlitAperture
    extends OneDimensionalAperture {
        DoubleSlitAperture() {
        }

        void setToDefaults() {
            this.lineCount = 4;
            this.lineLocations = new double[4];
            this.lineLocations[0] = -0.17;
            this.lineLocations[1] = -0.125;
            this.lineLocations[2] = 0.125;
            this.lineLocations[3] = 0.17;
        }

        int defaultBrightness() {
            return 140;
        }

        String getName() {
            return "double slit";
        }

        Aperture createNext() {
            return new TripleSlitAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }
    }

    class SlitAperture
    extends OneDimensionalAperture {
        SlitAperture() {
        }

        void setToDefaults() {
            this.lineCount = 2;
            this.lineLocations = new double[2];
            this.lineLocations[0] = -0.06;
            this.lineLocations[1] = 0.06;
        }

        int defaultBrightness() {
            return 200;
        }

        String getName() {
            return "slit";
        }

        Aperture createNext() {
            return new DoubleSlitAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }
    }

    class HalfPlaneAperture
    extends OneDimensionalAperture {
        HalfPlaneAperture() {
        }

        void setToDefaults() {
            this.lineCount = 1;
            this.lineLocations = new double[1];
            this.lineLocations[0] = 0.0;
        }

        String getName() {
            return "half plane";
        }

        Aperture createNext() {
            return new SlitAperture();
        }

        double getDimension() {
            return 0.5 - this.lineLocations[0];
        }
    }

    abstract class OneDimensionalAperture
    extends Aperture {
        public double[] lineLocations;
        public int lineCount;

        OneDimensionalAperture() {
        }

        boolean oneDimensional() {
            return true;
        }

        void compute() {
            double d;
            double[] dArray = new double[2];
            int n = 1;
            int n2 = 1;
            if (DiffractionFrame.this.color) {
                n = 0;
                n2 = 2;
            }
            int n3 = this.hasXSymmetry() ? DiffractionFrame.this.gridSizeX / 2 : DiffractionFrame.this.gridSizeX;
            double d2 = d = DiffractionFrame.this.reversedCheck.getState() ? -1.0 : 0.0;
            if (this.lineCount == 1) {
                d += 0.5;
            }
            int n4 = 0;
            while (n4 != n3) {
                double d3 = (double)n4 / (double)DiffractionFrame.this.gridSizeX - 0.5;
                int n5 = n;
                while (n5 <= n2) {
                    double d4 = DiffractionFrame.this.colorLenMults[n5];
                    double d5 = d;
                    double d6 = d;
                    int n6 = 1;
                    int n7 = 0;
                    while (n7 != this.lineCount) {
                        DiffractionFrame.this.fresnl((d3 - this.lineLocations[n7]) * d4, dArray);
                        d5 += (double)n6 * dArray[0];
                        d6 += (double)n6 * dArray[1];
                        n6 = -n6;
                        ++n7;
                    }
                    DiffractionFrame.this.func[n4][0][n5] = 0.5 * (d5 * d5 + d6 * d6);
                    ++n5;
                }
                ++n4;
            }
        }

        double getDimension() {
            return this.lineLocations[this.lineCount - 1] - this.lineLocations[0];
        }

        void drawGeometricShadow(Graphics graphics) {
            int n = -1;
            if (DiffractionFrame.this.selection != -1 && this.hasXSymmetry()) {
                n = this.lineCount - 1 - DiffractionFrame.this.selection;
            }
            int n2 = 0;
            while (n2 != this.lineCount) {
                int n3 = (int)((this.lineLocations[n2] + 0.5) * (double)DiffractionFrame.this.winSize.width);
                graphics.setColor(DiffractionFrame.this.selection == n2 || n == n2 ? Color.yellow : Color.red);
                graphics.drawLine(n3, 0, n3, DiffractionFrame.this.winSize.height - 1);
                ++n2;
            }
        }

        int getSelection(int n, int n2) {
            double d = (double)n / (double)DiffractionFrame.this.winSize.width - 0.5;
            double d2 = 3.0 / (double)DiffractionFrame.this.winSize.width;
            int n3 = -1;
            int n4 = 0;
            while (n4 != this.lineCount) {
                double d3 = Math.abs(this.lineLocations[n4] - d);
                if (d3 < d2) {
                    n3 = n4;
                    d2 = d3;
                }
                ++n4;
            }
            return n3;
        }

        boolean drag(int n, int n2) {
            double d = (double)n / (double)DiffractionFrame.this.winSize.width - 0.5;
            if (DiffractionFrame.this.selection > 0 && d <= this.lineLocations[DiffractionFrame.this.selection - 1]) {
                return false;
            }
            if (DiffractionFrame.this.selection < this.lineCount - 1 && d >= this.lineLocations[DiffractionFrame.this.selection + 1]) {
                return false;
            }
            if (this.hasXSymmetry() && DiffractionFrame.this.sign(this.lineLocations[DiffractionFrame.this.selection]) != DiffractionFrame.this.sign(d)) {
                return false;
            }
            this.lineLocations[DiffractionFrame.this.selection] = d;
            if (this.hasXSymmetry()) {
                int n3 = this.lineCount - 1 - DiffractionFrame.this.selection;
                this.lineLocations[n3] = -d;
            }
            DiffractionFrame.this.functionChanged = true;
            return true;
        }

        boolean hideWhileDragging() {
            return false;
        }

        void rezoom(double d) {
            int n = 0;
            while (n != this.lineCount) {
                int n2 = n++;
                this.lineLocations[n2] = this.lineLocations[n2] * d;
            }
        }
    }

    class CircularAperture
    extends Aperture {
        double radius;

        CircularAperture() {
        }

        String getName() {
            return "circle";
        }

        Aperture createNext() {
            return new HalfPlaneAperture();
        }

        boolean hasXSymmetry() {
            return true;
        }

        boolean hasYSymmetry() {
            return true;
        }

        boolean hasDiagonalSymmetry() {
            return true;
        }

        void setToDefaults() {
            this.radius = 0.25;
        }

        void rezoom(double d) {
            this.radius *= d;
        }

        void compute() {
            int n = 0;
            while (n != DiffractionFrame.this.gridSizeX / 2) {
                int n2 = 0;
                while (n2 <= n) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    DiffractionFrame.this.clearAccum();
                    double d5 = (double)n / (double)DiffractionFrame.this.gridSizeX - 0.5;
                    double d6 = (double)n2 / (double)DiffractionFrame.this.gridSizeY - 0.5;
                    double d7 = -d5;
                    double d8 = -d6;
                    double d9 = d7 * d7 + d8 * d8;
                    double d10 = this.radius;
                    double d11 = d9 - d10 * d10;
                    double d12 = d11 * 4.0;
                    double d13 = 0.0;
                    double d14 = Math.PI * 2;
                    if (!(d11 <= 0.0)) {
                        double d15 = Math.sqrt(d9);
                        d4 = d7 / d15;
                        d2 = Math.atan2(d8 - d4 * d10, d7 + (d3 = d8 / d15) * d10);
                        d13 = d2 < (d = Math.atan2(d8 + d4 * d10, d7 - d3 * d10)) ? d2 : d;
                        double d16 = d14 = d2 > d ? d2 : d;
                        if (d14 - d13 > Math.PI) {
                            d13 = d2 > d ? d2 : d;
                            d14 = d2 < d ? d2 : d;
                            d14 += Math.PI * 2;
                        }
                    }
                    int n3 = (int)(d13 * (double)DiffractionFrame.this.angleSteps / (Math.PI * 2));
                    int n4 = (int)(d14 * (double)DiffractionFrame.this.angleSteps / (Math.PI * 2));
                    while (n3 < 0) {
                        n3 += DiffractionFrame.this.angleSteps;
                        n4 += DiffractionFrame.this.angleSteps;
                    }
                    int n5 = n3;
                    while (n5 < n4) {
                        d4 = DiffractionFrame.this.angcos1[n5 & DiffractionFrame.this.angleStepsMask];
                        d3 = DiffractionFrame.this.angsin1[n5 & DiffractionFrame.this.angleStepsMask];
                        d2 = -2.0 * (d4 * d7 + d3 * d8);
                        d = d2 * d2 - d12;
                        if (!(d < 0.0)) {
                            d = Math.sqrt(d);
                            double d17 = 0.5 * (-d2 - d);
                            double d18 = 0.5 * (-d2 + d);
                            if (!(d17 < 0.0) || !(d18 < 0.0)) {
                                if (d17 > 0.0) {
                                    DiffractionFrame.this.apertureStart(d17);
                                }
                                DiffractionFrame.this.apertureStop(d18);
                            }
                        }
                        ++n5;
                    }
                    DiffractionFrame.this.apertureStartOrigin(d11 < 0.0);
                    DiffractionFrame.this.setFunction(n, n2);
                    ++n2;
                }
                ++n;
            }
        }

        void drawGeometricShadow(Graphics graphics) {
            if (DiffractionFrame.this.selection == 1) {
                graphics.setColor(Color.yellow);
            }
            int n = (int)((double)DiffractionFrame.this.winSize.width * this.radius);
            graphics.drawOval(DiffractionFrame.this.winSize.width / 2 - n, DiffractionFrame.this.winSize.height / 2 - n, n * 2, n * 2);
        }

        int getSelection(int n, int n2) {
            int n3 = DiffractionFrame.this.winSize.width / 2 - n;
            int n4 = DiffractionFrame.this.winSize.height / 2 - n2;
            double d = Math.sqrt(n3 * n3 + n4 * n4) / (double)DiffractionFrame.this.winSize.width;
            return Math.abs(d - this.radius) < 5.0 / (double)DiffractionFrame.this.winSize.width ? 1 : -1;
        }

        boolean drag(int n, int n2) {
            int n3 = DiffractionFrame.this.winSize.width / 2 - n;
            int n4 = DiffractionFrame.this.winSize.height / 2 - n2;
            double d = Math.sqrt(n3 * n3 + n4 * n4) / (double)DiffractionFrame.this.winSize.width;
            if (d == this.radius) {
                return false;
            }
            this.radius = d;
            return true;
        }

        double getDimension() {
            return this.radius * 2.0;
        }
    }

    abstract class Aperture {
        abstract String getName();

        abstract void compute();

        abstract Aperture createNext();

        abstract void drawGeometricShadow(Graphics var1);

        abstract int getSelection(int var1, int var2);

        abstract boolean drag(int var1, int var2);

        abstract void setToDefaults();

        int defaultBrightness() {
            return 50;
        }

        boolean oneDimensional() {
            return false;
        }

        boolean hasXSymmetry() {
            return false;
        }

        boolean hasYSymmetry() {
            return false;
        }

        boolean hasDiagonalSymmetry() {
            return false;
        }

        boolean hideWhileDragging() {
            return true;
        }

        void rezoom(double d) {
        }

        abstract double getDimension();

        Aperture() {
            this.setToDefaults();
        }
    }
}

