/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;

class DFilterFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Dimension winSize;
    Image dbimage;
    View respView;
    View impulseView;
    View phaseView;
    View stepView;
    View spectrumView;
    View waveformView;
    View poleInfoView;
    View polesView;
    Random random;
    int maxSampleCount = 70;
    int sampleCountR;
    int sampleCountTh;
    int modeCountR;
    int modeCountTh;
    int maxDispRModes = 5;
    int maxDispThModes = 5;
    public static final double epsilon = 1.0E-5;
    public static final double epsilon2 = 0.003;
    public static final double log10 = 2.302585092994046;
    public static int WINDOW_KAISER = 4;
    Checkbox soundCheck;
    Checkbox displayCheck;
    Checkbox shiftSpectrumCheck;
    CheckboxMenuItem freqCheckItem;
    CheckboxMenuItem phaseCheckItem;
    CheckboxMenuItem spectrumCheckItem;
    CheckboxMenuItem impulseCheckItem;
    CheckboxMenuItem stepCheckItem;
    CheckboxMenuItem waveformCheckItem;
    CheckboxMenuItem logFreqCheckItem;
    CheckboxMenuItem logAmpCheckItem;
    CheckboxMenuItem allWaveformCheckItem;
    CheckboxMenuItem ferrisCheckItem;
    MenuItem exitItem;
    Choice filterChooser;
    int selection;
    final int SELECT_RESPONSE = 1;
    final int SELECT_SPECTRUM = 2;
    final int SELECT_POLES = 3;
    int filterSelection;
    Choice inputChooser;
    Choice windowChooser;
    Choice rateChooser;
    Scrollbar[] auxBars;
    Label[] auxLabels;
    Label inputLabel;
    Scrollbar inputBar;
    Label shiftFreqLabel;
    Scrollbar shiftFreqBar;
    Label kaiserLabel;
    Scrollbar kaiserBar;
    boolean editingFunc;
    boolean dragStop;
    double inputW;
    static final double pi = Math.PI;
    double step;
    double waveGain = 1.52587890625E-5;
    double outputGain = 1.0;
    int sampleRate;
    int[] xpoints = new int[4];
    int[] ypoints = new int[4];
    int dragX;
    int dragY;
    int dragStartX;
    int dragStartY;
    int mouseX;
    int mouseY;
    int selectedPole;
    int selectedZero;
    int lastPoleCount = 2;
    int lastZeroCount = 2;
    boolean dragSet;
    boolean dragClear;
    boolean dragging;
    boolean unstable;
    MemoryImageSource imageSource;
    Image memimage;
    int[] pixels;
    double t;
    int pause;
    PlayThread playThread;
    Filter curFilter;
    FilterType filterType;
    double[] spectrumBuf;
    FFT spectrumFFT;
    Waveform wformInfo;
    PhaseColor[] phaseColors;
    static final int phaseColorCount = 400;
    boolean filterChanged;
    DFilterCanvas cv;
    DFilter applet;
    NumberFormat showFormat;
    boolean java2 = false;
    String[] mp3List;
    String mp3Error;
    long lastTime;
    double minlog;
    double logrange;
    double[] uresp;
    Complex[] customPoles;
    Complex[] customZeros;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public String getAppletInfo() {
        return "DFilter Series by Paul Falstad";
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    DFilterFrame(DFilter dFilter) {
        super("Digital Filters Applet v1.2");
        this.applet = dFilter;
    }

    public void init() {
        int n;
        String string;
        this.mp3List = new String[20];
        try {
            string = this.applet.getParameter("PAUSE");
            if (string != null) {
                this.pause = Integer.parseInt(string);
            }
            for (int i = 0; i < this.mp3List.length && (string = this.applet.getParameter("mp3File" + (i + 1))) != null; ++i) {
                this.mp3List[i] = string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = System.getProperty("java.class.version");
        double d = new Double(string);
        if (d >= 48.0) {
            this.java2 = true;
        }
        int n2 = 50;
        this.phaseColors = new PhaseColor[400];
        for (n = 0; n != 8; ++n) {
            for (int i = 0; i != n2; ++i) {
                double d2 = Math.atan((double)i / (double)n2);
                this.phaseColors[n * n2 + i] = this.genPhaseColor(n, d2);
            }
        }
        this.customPoles = new Complex[20];
        this.customZeros = new Complex[20];
        for (n = 0; n != this.customPoles.length; ++n) {
            this.customPoles[n] = new Complex();
        }
        for (n = 0; n != this.customZeros.length; ++n) {
            this.customZeros[n] = new Complex();
        }
        this.setLayout(new DFilterLayout());
        this.cv = new DFilterCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menuBar.add(menu);
        this.exitItem = this.getMenuItem("Exit");
        menu.add(this.exitItem);
        menu = new Menu("View");
        menuBar.add(menu);
        this.freqCheckItem = this.getCheckItem("Frequency Response", true);
        menu.add(this.freqCheckItem);
        this.phaseCheckItem = this.getCheckItem("Phase Response", false);
        menu.add(this.phaseCheckItem);
        this.spectrumCheckItem = this.getCheckItem("Spectrum", true);
        menu.add(this.spectrumCheckItem);
        this.waveformCheckItem = this.getCheckItem("Waveform", this.java2);
        menu.add(this.waveformCheckItem);
        this.impulseCheckItem = this.getCheckItem("Impulse Response", true);
        menu.add(this.impulseCheckItem);
        this.stepCheckItem = this.getCheckItem("Step Response", false);
        menu.add(this.stepCheckItem);
        menu.addSeparator();
        this.logFreqCheckItem = this.getCheckItem("Log Frequency Scale", false);
        menu.add(this.logFreqCheckItem);
        this.allWaveformCheckItem = this.getCheckItem("Show Entire Waveform", false);
        menu.add(this.allWaveformCheckItem);
        this.ferrisCheckItem = this.getCheckItem("Ferris Plot", false);
        menu.add(this.ferrisCheckItem);
        this.logAmpCheckItem = this.getCheckItem("Log Amplitude Scale", true);
        this.setMenuBar(menuBar);
        this.soundCheck = new Checkbox("Sound On");
        if (this.java2) {
            this.soundCheck.setState(true);
        } else {
            this.soundCheck.disable();
        }
        this.soundCheck.addItemListener(this);
        this.add(this.soundCheck);
        this.displayCheck = new Checkbox("Stop Display");
        this.displayCheck.addItemListener(this);
        this.add(this.displayCheck);
        this.shiftSpectrumCheck = new Checkbox("Shift Spectrum");
        this.shiftSpectrumCheck.addItemListener(this);
        this.add(this.shiftSpectrumCheck);
        this.inputChooser = new Choice();
        this.add(this.inputChooser);
        this.inputChooser.add("Input = Noise");
        this.inputChooser.add("Input = Sine Wave");
        this.inputChooser.add("Input = Sawtooth");
        this.inputChooser.add("Input = Triangle Wave");
        this.inputChooser.add("Input = Square Wave");
        this.inputChooser.add("Input = Periodic Noise");
        this.inputChooser.add("Input = Sweep");
        this.inputChooser.add("Input = Impulses");
        n = 0;
        while (this.mp3List[n] != null) {
            this.inputChooser.add("Input = " + this.mp3List[n]);
            ++n;
        }
        this.inputChooser.addItemListener(this);
        this.filterChooser = new Choice();
        this.add(this.filterChooser);
        this.filterChooser.add("Filter = FIR Low-pass");
        this.filterChooser.add("Filter = FIR High-pass");
        this.filterChooser.add("Filter = FIR Band-pass");
        this.filterChooser.add("Filter = FIR Band-stop");
        this.filterChooser.add("Filter = Custom FIR");
        this.filterChooser.add("Filter = None");
        this.filterChooser.add("Filter = Butterworth Low-pass");
        this.filterChooser.add("Filter = Butterworth High-pass");
        this.filterChooser.add("Filter = Butterworth Band-pass");
        this.filterChooser.add("Filter = Butterworth Band-stop");
        this.filterChooser.add("Filter = Chebyshev Low-pass");
        this.filterChooser.add("Filter = Chebyshev High-pass");
        this.filterChooser.add("Filter = Chebyshev Band-pass");
        this.filterChooser.add("Filter = Chebyshev Band-stop");
        this.filterChooser.add("Filter = Inv Cheby Low-pass");
        this.filterChooser.add("Filter = Inv Cheby High-pass");
        this.filterChooser.add("Filter = Inv Cheby Band-pass");
        this.filterChooser.add("Filter = Inv Cheby Band-stop");
        this.filterChooser.add("Filter = Elliptic Low-pass");
        this.filterChooser.add("Filter = Elliptic High-pass");
        this.filterChooser.add("Filter = Elliptic Band-pass");
        this.filterChooser.add("Filter = Elliptic Band-stop");
        this.filterChooser.add("Filter = Comb (+)");
        this.filterChooser.add("Filter = Comb (-)");
        this.filterChooser.add("Filter = Delay");
        this.filterChooser.add("Filter = Plucked String");
        this.filterChooser.add("Filter = Inverse Comb");
        this.filterChooser.add("Filter = Reson");
        this.filterChooser.add("Filter = Reson w/ Zeros");
        this.filterChooser.add("Filter = Notch");
        this.filterChooser.add("Filter = Moving Average");
        this.filterChooser.add("Filter = Triangle");
        this.filterChooser.add("Filter = Allpass");
        this.filterChooser.add("Filter = Gaussian");
        this.filterChooser.add("Filter = Random");
        this.filterChooser.add("Filter = Custom IIR");
        this.filterChooser.addItemListener(this);
        this.filterSelection = -1;
        this.windowChooser = new Choice();
        this.add(this.windowChooser);
        this.windowChooser.add("Window = Rectangular");
        this.windowChooser.add("Window = Hamming");
        this.windowChooser.add("Window = Hann");
        this.windowChooser.add("Window = Blackman");
        this.windowChooser.add("Window = Kaiser");
        this.windowChooser.add("Window = Bartlett");
        this.windowChooser.add("Window = Welch");
        this.windowChooser.addItemListener(this);
        this.windowChooser.select(1);
        this.rateChooser = new Choice();
        this.add(this.rateChooser);
        this.rateChooser.add("Sampling Rate = 8000");
        this.rateChooser.add("Sampling Rate = 11025");
        this.rateChooser.add("Sampling Rate = 16000");
        this.rateChooser.add("Sampling Rate = 22050");
        this.rateChooser.add("Sampling Rate = 32000");
        this.rateChooser.add("Sampling Rate = 44100");
        this.rateChooser.select(3);
        this.sampleRate = 22050;
        this.rateChooser.addItemListener(this);
        this.auxLabels = new Label[5];
        this.auxBars = new Scrollbar[5];
        for (n = 0; n != 5; ++n) {
            this.auxLabels[n] = new Label("", 1);
            this.add(this.auxLabels[n]);
            this.auxBars[n] = new Scrollbar(0, 25, 1, 1, 999);
            this.add(this.auxBars[n]);
            this.auxBars[n].addAdjustmentListener(this);
        }
        this.inputLabel = new Label("Input Frequency", 1);
        this.add(this.inputLabel);
        this.inputBar = new Scrollbar(0, 40, 1, 1, 999);
        this.add(this.inputBar);
        this.inputBar.addAdjustmentListener(this);
        this.shiftFreqLabel = new Label("Shift Frequency", 1);
        this.add(this.shiftFreqLabel);
        this.shiftFreqBar = new Scrollbar(0, 10, 1, 0, 1001);
        this.add(this.shiftFreqBar);
        this.shiftFreqBar.addAdjustmentListener(this);
        this.shiftFreqLabel.hide();
        this.shiftFreqBar.hide();
        this.kaiserLabel = new Label("Kaiser Parameter", 1);
        this.add(this.kaiserLabel);
        this.kaiserBar = new Scrollbar(0, 500, 1, 1, 999);
        this.add(this.kaiserBar);
        this.kaiserBar.addAdjustmentListener(this);
        this.random = new Random();
        this.setInputLabel();
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.showFormat = NumberFormat.getInstance();
        this.showFormat.setMaximumFractionDigits(2);
        this.resize(640, 640);
        this.handleResize();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.show();
    }

    void reinit() {
        this.setupFilter();
        this.setInputW();
    }

    MenuItem getMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    CheckboxMenuItem getCheckItem(String string, boolean bl) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.setState(bl);
        checkboxMenuItem.addItemListener(this);
        return checkboxMenuItem;
    }

    int getPower2(int n) {
        int n2;
        for (n2 = 2; n2 < n; n2 *= 2) {
        }
        return n2;
    }

    PhaseColor genPhaseColor(int n, double d) {
        d += (double)n * Math.PI / 4.0;
        int n2 = (int)(d *= 0.954929658551372);
        double d2 = d % 1.0;
        double d3 = 1.0 - d2;
        PhaseColor phaseColor = null;
        switch (n2) {
            case 0: 
            case 6: {
                phaseColor = new PhaseColor(1.0, d2, 0.0);
                break;
            }
            case 1: {
                phaseColor = new PhaseColor(d3, 1.0, 0.0);
                break;
            }
            case 2: {
                phaseColor = new PhaseColor(0.0, 1.0, d2);
                break;
            }
            case 3: {
                phaseColor = new PhaseColor(0.0, d3, 1.0);
                break;
            }
            case 4: {
                phaseColor = new PhaseColor(d2, 0.0, 1.0);
                break;
            }
            case 5: {
                phaseColor = new PhaseColor(1.0, 0.0, d3);
            }
        }
        return phaseColor;
    }

    void handleResize() {
        Dimension dimension = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        int n = 1;
        this.waveformView = null;
        this.stepView = null;
        this.phaseView = null;
        this.impulseView = null;
        this.spectrumView = null;
        this.respView = null;
        if (this.freqCheckItem.getState()) {
            ++n;
        }
        if (this.phaseCheckItem.getState()) {
            ++n;
        }
        if (this.spectrumCheckItem.getState()) {
            ++n;
        }
        if (this.waveformCheckItem.getState()) {
            ++n;
        }
        if (this.impulseCheckItem.getState()) {
            ++n;
        }
        if (this.stepCheckItem.getState()) {
            ++n;
        }
        int n2 = dimension.height / n;
        this.dbimage = this.createImage(dimension.width, dimension.height);
        int n3 = 15;
        int n4 = 0;
        if (this.freqCheckItem.getState()) {
            this.respView = this.getView(n4++, n);
        }
        if (this.phaseCheckItem.getState()) {
            this.phaseView = this.getView(n4++, n);
        }
        if (this.spectrumCheckItem.getState()) {
            this.spectrumView = this.getView(n4++, n);
        }
        if (this.waveformCheckItem.getState()) {
            this.waveformView = this.getView(n4++, n);
        }
        if (this.impulseCheckItem.getState()) {
            this.impulseView = this.getView(n4++, n);
        }
        if (this.stepCheckItem.getState()) {
            this.stepView = this.getView(n4++, n);
        }
        this.poleInfoView = this.getView(n4++, n);
        if (this.poleInfoView.height > 200) {
            this.poleInfoView.height = 200;
        }
        this.polesView = new View(this.poleInfoView.x, this.poleInfoView.y, this.poleInfoView.height, this.poleInfoView.height);
        this.getPoleBuffer();
    }

    View getView(int n, int n2) {
        int n3 = this.winSize.height / n2;
        int n4 = 5;
        int n5 = 15;
        return new View(n4, n4 + n * n3 + n5, this.winSize.width - n4 * 2, n3 - n4 * 2 - n5);
    }

    void getPoleBuffer() {
        this.pixels = null;
        if (this.java2) {
            try {
                Class<?> clazz = Class.forName("java.awt.image.BufferedImage");
                Class<?> clazz2 = Class.forName("java.awt.image.DataBufferInt");
                Class<?> clazz3 = Class.forName("java.awt.image.Raster");
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.memimage = (Image)constructor.newInstance(new Integer(this.polesView.width), new Integer(this.polesView.height), new Integer(1));
                Method method = clazz.getMethod("getRaster", null);
                Object object = method.invoke((Object)this.memimage, null);
                Object object2 = clazz3.getMethod("getDataBuffer", null).invoke(object, null);
                this.pixels = (int[])clazz2.getMethod("getData", null).invoke(object2, null);
            }
            catch (Exception exception) {
                System.out.println("BufferedImage failed");
            }
        }
        if (this.pixels == null) {
            this.pixels = new int[this.polesView.width * this.polesView.height];
            for (int i = 0; i != this.polesView.width * this.polesView.height; ++i) {
                this.pixels[i] = -16777216;
            }
            this.imageSource = new MemoryImageSource(this.polesView.width, this.polesView.height, this.pixels, 0, this.polesView.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.memimage = this.cv.createImage(this.imageSource);
        }
    }

    void centerString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, (this.winSize.width - fontMetrics.stringWidth(string)) / 2, n);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateDFilter(Graphics graphics) {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        int n5;
        double d2;
        int n6;
        int n7;
        int n8;
        int n9;
        double d3;
        Graphics graphics2 = this.dbimage.getGraphics();
        if (this.winSize == null || this.winSize.width == 0 || this.dbimage == null) {
            return;
        }
        if (this.curFilter == null) {
            Filter filter;
            this.curFilter = filter = this.filterType.genFilter();
            if (this.playThread != null) {
                this.playThread.setFilter(filter);
            }
            this.filterChanged = true;
            this.unstable = false;
        }
        if (this.playThread == null && !this.unstable && this.soundCheck.getState()) {
            this.playThread = new PlayThread();
            this.playThread.start();
        }
        if (this.displayCheck.getState()) {
            return;
        }
        graphics2.setColor(this.cv.getBackground());
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        graphics2.setColor(this.cv.getForeground());
        double d4 = 40.0 / (double)this.sampleRate;
        this.minlog = Math.log(d4);
        this.logrange = Math.log(0.5) - this.minlog;
        Complex complex = new Complex();
        if (this.respView != null) {
            int n10;
            double d5;
            this.respView.drawLabel(graphics2, "Frequency Response");
            graphics2.setColor(Color.darkGray);
            graphics2.fillRect(this.respView.x, this.respView.y, this.respView.width, this.respView.height);
            graphics2.setColor(Color.black);
            d3 = 0.069;
            n9 = 0;
            while (!((d5 = d3 * (double)n9) > 1.0)) {
                n10 = this.respView.y + (int)(d5 * (double)this.respView.height);
                graphics2.drawLine(this.respView.x, n10, this.respView.right, n10);
                n9 += 2;
            }
            n9 = 1;
            while (true) {
                d5 = this.logrange - (double)n9 * Math.log(2.0);
                n10 = 0;
                n10 = this.logFreqCheckItem.getState() ? (int)(d5 * (double)this.respView.width / this.logrange) : this.respView.width / (1 << n9);
                if (n10 <= 0) break;
                graphics2.drawLine(n10 += this.respView.x, this.respView.y, n10, this.respView.bottom);
                ++n9;
            }
            graphics2.setColor(Color.white);
            n8 = -1;
            n7 = -1;
            n10 = -1;
            n6 = -1;
            for (n9 = 0; n9 != this.respView.width; ++n9) {
                double d6;
                double d7 = 0.0;
                if (!this.logFreqCheckItem.getState()) {
                    d7 = Math.PI * (double)n9 / (double)this.respView.width;
                } else {
                    d6 = Math.exp(this.minlog + (double)n9 * this.logrange / (double)this.respView.width);
                    d7 = Math.PI * 2 * d6;
                }
                this.filterType.getResponse(d7, complex);
                d6 = complex.magSquared();
                d2 = -d3 * Math.log(d6 * d6) / 2.302585092994046;
                int n11 = n9 + this.respView.x;
                if (d2 > 1.0) {
                    if (n8 != -1) {
                        graphics2.drawLine(n8, n7, n8, this.respView.bottom);
                    }
                    n8 = -1;
                } else {
                    int n12 = this.respView.y + (int)((double)this.respView.height * d2);
                    if (n8 != -1) {
                        graphics2.drawLine(n8, n7, n11, n12);
                    } else if (n11 > this.respView.x) {
                        graphics2.drawLine(n11, this.respView.bottom, n11, n12);
                    }
                    n8 = n11;
                    n7 = n12;
                }
                if (!(this.filterType instanceof CustomFIRFilter)) continue;
                graphics2.setColor(Color.white);
                CustomFIRFilter customFIRFilter = (CustomFIRFilter)this.filterType;
                d6 = customFIRFilter.getUserResponse(d7);
                d2 = -d3 * Math.log(d6 * d6) / 2.302585092994046;
                if (d2 > 1.0) {
                    if (n10 != -1) {
                        graphics2.drawLine(n10, n6, n10, this.respView.bottom);
                    }
                    n10 = -1;
                } else {
                    int n13 = this.respView.y + (int)((double)this.respView.height * d2);
                    if (n10 != -1) {
                        graphics2.drawLine(n10, n6, n11, n13);
                    } else if (n11 > this.respView.x) {
                        graphics2.drawLine(n11, this.respView.bottom, n11, n13);
                    }
                    n10 = n11;
                    n6 = n13;
                }
                graphics2.setColor(Color.red);
            }
        }
        graphics2.setColor(Color.white);
        if (this.phaseView != null) {
            this.phaseView.drawLabel(graphics2, "Phase Response");
            graphics2.setColor(Color.darkGray);
            graphics2.fillRect(this.phaseView.x, this.phaseView.y, this.phaseView.width, this.phaseView.height);
            graphics2.setColor(Color.black);
            for (n9 = 0; n9 < 5; ++n9) {
                d3 = (double)n9 * 0.25;
                n8 = this.phaseView.y + (int)(d3 * (double)this.phaseView.height);
                graphics2.drawLine(this.phaseView.x, n8, this.phaseView.right, n8);
            }
            n9 = 1;
            while (true) {
                d3 = this.logrange - (double)n9 * Math.log(2.0);
                n8 = 0;
                n8 = this.logFreqCheckItem.getState() ? (int)(d3 * (double)this.phaseView.width / this.logrange) : this.phaseView.width / (1 << n9);
                if (n8 <= 0) break;
                graphics2.drawLine(n8 += this.phaseView.x, this.phaseView.y, n8, this.phaseView.bottom);
                ++n9;
            }
            graphics2.setColor(Color.white);
            int n14 = -1;
            n5 = -1;
            for (n9 = 0; n9 != this.phaseView.width; ++n9) {
                double d8 = 0.0;
                if (!this.logFreqCheckItem.getState()) {
                    d8 = Math.PI * (double)n9 / (double)this.phaseView.width;
                } else {
                    double d9 = Math.exp(this.minlog + (double)n9 * this.logrange / (double)this.phaseView.width);
                    d8 = Math.PI * 2 * d9;
                }
                this.filterType.getResponse(d8, complex);
                double d10 = 0.5 + complex.phase / (Math.PI * 2);
                int n15 = this.phaseView.y + (int)((double)this.phaseView.height * d10);
                n4 = n9 + this.phaseView.x;
                if (n14 != -1) {
                    graphics2.drawLine(n14, n5, n4, n15);
                } else if (n4 > this.phaseView.x) {
                    graphics2.drawLine(n4, this.phaseView.bottom, n4, n15);
                }
                n14 = n4;
                n5 = n15;
            }
        }
        int n16 = this.filterType.getPoleCount();
        n5 = this.filterType.getZeroCount();
        int n17 = 10;
        n7 = 0;
        int n18 = 0;
        n6 = 0;
        int n19 = 0;
        if (this.poleInfoView != null && (n16 > 0 || n5 > 0 || this.ferrisCheckItem.getState())) {
            Complex complex2;
            n18 = n7 = this.polesView.height / 2;
            n6 = this.polesView.x + n18;
            n19 = this.polesView.y + n7;
            n17 = n6 + n18 + 10;
            if (!this.ferrisCheckItem.getState()) {
                graphics2.setColor(Color.white);
                FontMetrics fontMetrics = graphics2.getFontMetrics();
                String string = "Poles/Zeros";
                graphics2.drawString(string, n6 - fontMetrics.stringWidth(string) / 2, this.polesView.y - 5);
                graphics2.drawOval(n6 - n18, n19 - n7, n18 * 2, n7 * 2);
                graphics2.drawLine(n6, n19 - n7, n6, n19 + n7);
                graphics2.drawLine(n6 - n7, n19, n6 + n7, n19);
                complex2 = new Complex();
                for (n9 = 0; n9 != n16; ++n9) {
                    this.filterType.getPole(n9, complex2);
                    graphics2.setColor(n9 == this.selectedPole ? Color.yellow : Color.white);
                    int n20 = n6 + (int)((double)n18 * complex2.re);
                    n3 = n19 - (int)((double)n7 * complex2.im);
                    graphics2.drawLine(n20 - 3, n3 - 3, n20 + 3, n3 + 3);
                    graphics2.drawLine(n20 - 3, n3 + 3, n20 + 3, n3 - 3);
                }
                for (n9 = 0; n9 != n5; ++n9) {
                    this.filterType.getZero(n9, complex2);
                    graphics2.setColor(n9 == this.selectedZero ? Color.yellow : Color.white);
                    int n21 = n6 + (int)((double)n18 * complex2.re);
                    n3 = n19 - (int)((double)n7 * complex2.im);
                    graphics2.drawOval(n21 - 3, n3 - 3, 6, 6);
                }
                if (this.filterChanged) {
                    this.setCustomPolesZeros();
                }
            } else {
                if (this.filterChanged) {
                    complex2 = new Complex();
                    for (n4 = 0; n4 != this.polesView.width; ++n4) {
                        for (int i = 0; i != this.polesView.height; ++i) {
                            complex2.set((double)(n4 - n18) / (double)n18, (double)(i - n18) / (double)n18);
                            if (complex2.re == 0.0 && complex2.im == 0.0) {
                                complex2.set(1.0E-30);
                            }
                            this.curFilter.evalTransfer(complex2);
                            d2 = 0.0;
                            double d11 = 0.0;
                            double d12 = Math.sqrt(complex2.mag);
                            if (d12 < 1.0) {
                                d2 = d12;
                                d11 = 1.0 - d2;
                            } else if (d12 < 2.0) {
                                d2 = 2.0 - d12;
                            }
                            d2 *= 255.0;
                            d11 *= 255.0;
                            d = complex2.phase;
                            if (d < 0.0) {
                                d += Math.PI * 2;
                            }
                            if (d >= Math.PI * 2) {
                                d -= Math.PI * 2;
                            }
                            PhaseColor phaseColor = this.phaseColors[(int)(d * 400.0 / (Math.PI * 2))];
                            this.pixels[n4 + i * this.polesView.width] = -16777216 + 65536 * (int)(phaseColor.r * d2 + d11) + 256 * (int)(phaseColor.g * d2 + d11) + 1 * (int)(phaseColor.b * d2 + d11);
                        }
                    }
                }
                if (this.imageSource != null) {
                    this.imageSource.newPixels();
                }
                graphics2.drawImage(this.memimage, this.polesView.x, this.polesView.y, null);
            }
        }
        if (this.poleInfoView != null) {
            double d13;
            graphics2.setColor(Color.white);
            String[] stringArray = new String[10];
            this.filterType.getInfo(stringArray);
            for (n9 = 0; n9 != 10 && stringArray[n9] != null; ++n9) {
            }
            if (this.wformInfo.needsFrequency()) {
                stringArray[n9++] = "Input Freq = " + (int)(this.inputW * (double)this.sampleRate / (Math.PI * 2));
            }
            stringArray[n9++] = "Output adjust = " + this.showFormat.format(-10.0 * Math.log(this.outputGain) / Math.log(0.1)) + " dB";
            for (n9 = 0; n9 != 10 && stringArray[n9] != null; ++n9) {
                graphics2.drawString(stringArray[n9], n17, this.poleInfoView.y + 5 + 20 * n9);
            }
            if ((this.respView != null && this.respView.contains(this.mouseX, this.mouseY) || this.spectrumView != null && this.spectrumView.contains(this.mouseX, this.mouseY)) && (d13 = this.getFreqFromX(this.mouseX, this.respView)) >= 0.0) {
                double d14 = Math.PI * 2 * d13;
                graphics2.setColor(Color.yellow);
                String string = "Selected Freq = " + (int)(d13 *= (double)this.sampleRate);
                if (this.respView.contains(this.mouseX, this.mouseY)) {
                    this.filterType.getResponse(d14, complex);
                    double d15 = complex.magSquared();
                    d15 = Math.log(d15 * d15) / 4.605170185988092;
                    string = string + ", Response = " + this.showFormat.format(10.0 * d15) + " dB";
                }
                graphics2.drawString(string, n17, this.poleInfoView.y + 5 + 20 * n9);
                if (n7 > 0) {
                    int n22 = n6 + (int)((double)n18 * Math.cos(d14));
                    int n23 = n19 - (int)((double)n18 * Math.sin(d14));
                    if (this.ferrisCheckItem.getState()) {
                        graphics2.setColor(Color.black);
                        graphics2.fillOval(n22 - 3, n23 - 3, 7, 7);
                    }
                    graphics2.setColor(Color.yellow);
                    graphics2.fillOval(n22 - 2, n23 - 2, 5, 5);
                }
            }
        }
        if (this.impulseView != null) {
            int n24;
            this.impulseView.drawLabel(graphics2, "Impulse Response");
            graphics2.setColor(Color.darkGray);
            graphics2.fillRect(this.impulseView.x, this.impulseView.y, this.impulseView.width, this.impulseView.height);
            graphics2.setColor(Color.black);
            graphics2.drawLine(this.impulseView.x, this.impulseView.y + this.impulseView.height / 2, this.impulseView.x + this.impulseView.width - 1, this.impulseView.y + this.impulseView.height / 2);
            graphics2.setColor(Color.white);
            int n25 = this.curFilter.getImpulseOffset();
            double[] dArray = this.curFilter.getImpulseResponse(n25);
            int n26 = this.curFilter.getImpulseLen(n25, dArray);
            int n27 = -1;
            n3 = -1;
            double d16 = 0.5 / this.max(dArray);
            int n28 = n24 = n26 < 50 ? 50 : n26;
            if (n26 < n24 && n24 < dArray.length - n25) {
                n26 = n24;
            }
            for (n9 = 0; n9 != n26; ++n9) {
                n2 = n25 + n9;
                d = dArray[n2] * d16;
                int n29 = this.impulseView.y + (int)((double)this.impulseView.height * (0.5 - d));
                n = this.impulseView.x + this.impulseView.width * n9 / n24;
                if (n26 < 100) {
                    graphics2.drawLine(n, this.impulseView.y + this.impulseView.height / 2, n, n29);
                    graphics2.fillOval(n - 2, n29 - 2, 5, 5);
                    continue;
                }
                if (n27 != -1) {
                    graphics2.drawLine(n27, n3, n, n29);
                }
                n27 = n;
                n3 = n29;
            }
        }
        if (this.stepView != null) {
            int n30;
            this.stepView.drawLabel(graphics2, "Step Response");
            graphics2.setColor(Color.darkGray);
            graphics2.fillRect(this.stepView.x, this.stepView.y, this.stepView.width, this.stepView.height);
            graphics2.setColor(Color.black);
            graphics2.drawLine(this.stepView.x, this.stepView.y + this.stepView.height / 2, this.stepView.x + this.stepView.width - 1, this.stepView.y + this.stepView.height / 2);
            graphics2.setColor(Color.white);
            int n31 = this.curFilter.getStepOffset();
            double[] dArray = this.curFilter.getStepResponse(n31);
            int n32 = this.curFilter.getStepLen(n31, dArray);
            int n33 = -1;
            n3 = -1;
            double d17 = 0.5 / this.max(dArray);
            int n34 = n30 = n32 < 50 ? 50 : n32;
            if (n32 < n30 && n30 < dArray.length - n31) {
                n32 = n30;
            }
            for (n9 = 0; n9 != n32; ++n9) {
                n2 = n31 + n9;
                d = dArray[n2] * d17;
                int n35 = this.stepView.y + (int)((double)this.stepView.height * (0.5 - d));
                n = this.stepView.x + this.stepView.width * n9 / n30;
                if (n32 < 100) {
                    graphics2.drawLine(n, this.stepView.y + this.stepView.height / 2, n, n35);
                    graphics2.fillOval(n - 2, n35 - 2, 5, 5);
                    continue;
                }
                if (n33 != -1) {
                    graphics2.drawLine(n33, n3, n, n35);
                }
                n33 = n;
                n3 = n35;
            }
        }
        if (this.playThread != null) {
            int n36 = this.playThread.spectrumLen;
            if (this.spectrumBuf == null || this.spectrumBuf.length != n36 * 2) {
                this.spectrumBuf = new double[n36 * 2];
            }
            int n37 = this.playThread.spectrumOffset;
            int n38 = this.playThread.fbufmask;
            int n39 = 0;
            n9 = 0;
            while (n9 != n36) {
                n3 = n38 & n37 + n9;
                this.spectrumBuf[n39] = this.playThread.fbufLo[n3] + this.playThread.fbufRo[n3];
                this.spectrumBuf[n39 + 1] = 0.0;
                ++n9;
                n39 += 2;
            }
        } else {
            this.spectrumBuf = null;
        }
        if (this.waveformView != null && this.spectrumBuf != null) {
            this.waveformView.drawLabel(graphics2, "Waveform");
            graphics2.setColor(Color.darkGray);
            graphics2.fillRect(this.waveformView.x, this.waveformView.y, this.waveformView.width, this.waveformView.height);
            graphics2.setColor(Color.black);
            graphics2.drawLine(this.waveformView.x, this.waveformView.y + this.waveformView.height / 2, this.waveformView.x + this.waveformView.width - 1, this.waveformView.y + this.waveformView.height / 2);
            graphics2.setColor(Color.white);
            int n40 = -1;
            int n41 = -1;
            if (this.waveGain < 0.1) {
                this.waveGain = 0.1;
            }
            double d18 = 0.0;
            for (n9 = 0; n9 != this.spectrumBuf.length; n9 += 2) {
                if (this.spectrumBuf[n9] > d18) {
                    d18 = this.spectrumBuf[n9];
                }
                if (!(this.spectrumBuf[n9] < -d18)) continue;
                d18 = -this.spectrumBuf[n9];
            }
            if (this.waveGain > 1.0 / d18) {
                this.waveGain = 1.0 / d18;
            } else if (this.waveGain * 1.05 < 1.0 / d18) {
                this.waveGain *= 1.05;
            }
            double d19 = 0.5 * this.waveGain;
            int n42 = this.waveformView.width;
            if (n42 > this.spectrumBuf.length || this.allWaveformCheckItem.getState()) {
                n42 = this.spectrumBuf.length;
            }
            for (n9 = 0; n9 < n42; n9 += 2) {
                double d20 = 0.5 - this.spectrumBuf[n9] * d19;
                int n43 = (int)((double)this.waveformView.height * d20);
                if (n43 > this.waveformView.height) {
                    n40 = -1;
                    continue;
                }
                int n44 = this.waveformView.y + n43;
                int n45 = this.waveformView.x + n9 * this.waveformView.width / n42;
                if (n40 != -1) {
                    graphics2.drawLine(n40, n41, n45, n44);
                }
                n40 = n45;
                n41 = n44;
            }
        }
        if (this.spectrumView != null && this.spectrumBuf != null) {
            double d21;
            this.spectrumView.drawLabel(graphics2, "Spectrum");
            graphics2.setColor(Color.darkGray);
            graphics2.fillRect(this.spectrumView.x, this.spectrumView.y, this.spectrumView.width, this.spectrumView.height);
            graphics2.setColor(Color.black);
            double d22 = 0.138;
            n9 = 0;
            while (!((d21 = d22 * (double)n9) > 1.0)) {
                int n46 = this.spectrumView.y + (int)(d21 * (double)this.spectrumView.height);
                graphics2.drawLine(this.spectrumView.x, n46, this.spectrumView.x + this.spectrumView.width, n46);
                ++n9;
            }
            n9 = 1;
            while (true) {
                d21 = this.logrange - (double)n9 * Math.log(2.0);
                int n47 = 0;
                n47 = this.logFreqCheckItem.getState() ? (int)(d21 * (double)this.spectrumView.width / this.logrange) : this.spectrumView.width / (1 << n9);
                if (n47 <= 0) break;
                graphics2.drawLine(n47 += this.spectrumView.x, this.spectrumView.y, n47, this.spectrumView.bottom);
                ++n9;
            }
            graphics2.setColor(Color.white);
            int n48 = this.spectrumBuf.length / 2;
            double d23 = Math.PI * 2 / (double)(this.spectrumBuf.length - 2);
            for (n9 = 0; n9 != this.spectrumBuf.length; n9 += 2) {
                double d24 = 0.54 - 0.46 * Math.cos((double)n9 * d23);
                int n49 = n9;
                this.spectrumBuf[n49] = this.spectrumBuf[n49] * d24;
            }
            if (this.spectrumFFT == null || this.spectrumFFT.size != this.spectrumBuf.length / 2) {
                this.spectrumFFT = new FFT(this.spectrumBuf.length / 2);
            }
            this.spectrumFFT.transform(this.spectrumBuf, false);
            double d25 = (double)this.spectrumView.width / Math.log(this.spectrumBuf.length / 2 + 1);
            int n50 = -1;
            n2 = -1;
            double d26 = 1.0 / (double)(this.spectrumBuf.length / 2);
            d26 = this.logAmpCheckItem.getState() ? (d26 /= 65536.0) : (d26 /= 768.0);
            d26 *= d26;
            double[] dArray = new double[this.spectrumView.width];
            if (this.logFreqCheckItem.getState()) {
                for (n9 = 0; n9 != this.spectrumBuf.length / 2; n9 += 2) {
                    double d27 = (double)n9 / (double)this.spectrumBuf.length;
                    int n51 = (int)((double)dArray.length * (Math.log(d27) - this.minlog) / this.logrange);
                    if (n51 < 0) continue;
                    int n52 = n51;
                    dArray[n52] = dArray[n52] + (this.spectrumBuf[n9] * this.spectrumBuf[n9] + this.spectrumBuf[n9 + 1] * this.spectrumBuf[n9 + 1]);
                }
            } else {
                for (n9 = 0; n9 != this.spectrumBuf.length / 2; n9 += 2) {
                    int n53 = n = dArray.length * n9 * 2 / this.spectrumBuf.length;
                    dArray[n53] = dArray[n53] + (this.spectrumBuf[n9] * this.spectrumBuf[n9] + this.spectrumBuf[n9 + 1] * this.spectrumBuf[n9 + 1]);
                }
            }
            int n54 = dArray.length;
            for (n9 = 0; n9 != this.spectrumView.width; ++n9) {
                double d28 = dArray[n9] * d26;
                d28 = this.logAmpCheckItem.getState() ? -d22 * Math.log(d28) / 2.302585092994046 : 1.0 - d28;
                int n55 = (int)((double)this.spectrumView.height * d28);
                if (n55 > this.spectrumView.height) continue;
                int n56 = this.spectrumView.y + n55;
                int n57 = this.spectrumView.x + n9 * this.spectrumView.width / n54;
                graphics2.drawLine(n57, n56, n57, this.spectrumView.y + this.spectrumView.height - 1);
            }
        }
        if (this.spectrumView != null && !this.java2) {
            graphics2.setColor(Color.white);
            this.centerString(graphics2, "Need java 2 for sound", this.spectrumView.y + this.spectrumView.height / 2);
        }
        if (this.unstable) {
            graphics2.setColor(Color.red);
            this.centerString(graphics2, "Filter is unstable", this.winSize.height / 2);
        }
        if (this.mp3Error != null) {
            graphics2.setColor(Color.red);
            this.centerString(graphics2, this.mp3Error, this.winSize.height / 2 + 20);
        }
        if (this.respView != null && this.respView.contains(this.mouseX, this.mouseY)) {
            graphics2.setColor(Color.yellow);
            graphics2.drawLine(this.mouseX, this.respView.y, this.mouseX, this.respView.y + this.respView.height - 1);
        }
        if (this.spectrumView != null && this.spectrumView.contains(this.mouseX, this.mouseY)) {
            graphics2.setColor(Color.yellow);
            graphics2.drawLine(this.mouseX, this.spectrumView.y, this.mouseX, this.spectrumView.y + this.spectrumView.height - 1);
        }
        this.filterChanged = false;
        graphics.drawImage(this.dbimage, 0, 0, this);
    }

    void setCutoff(double d) {
    }

    void setCustomPolesZeros() {
        int n;
        if (this.filterType instanceof CustomIIRFilter) {
            return;
        }
        int n2 = this.filterType.getPoleCount();
        int n3 = this.filterType.getZeroCount();
        Complex complex = new Complex();
        int n4 = 0;
        for (n = 0; n != n2; ++n) {
            this.filterType.getPole(n, complex);
            if (!(complex.im >= 0.0)) continue;
            this.customPoles[n4++].set(complex);
            this.customPoles[n4++].set(complex.re, -complex.im);
            if (n4 == this.customPoles.length) break;
        }
        this.lastPoleCount = n4;
        n4 = 0;
        for (n = 0; n != n3; ++n) {
            this.filterType.getZero(n, complex);
            if (!(complex.im >= 0.0)) continue;
            this.customZeros[n4++].set(complex);
            this.customZeros[n4++].set(complex.re, -complex.im);
            if (n4 == this.customZeros.length) break;
        }
        this.lastZeroCount = n4;
    }

    int countPoints(double[] dArray, int n) {
        int n2 = dArray.length;
        double d = 0.0;
        int n3 = 0;
        double d2 = 123.0;
        for (int i = n; i < n2; ++i) {
            double d3 = Math.abs(dArray[i]);
            if (d3 > d) {
                d = d3;
            }
            if (Math.abs(d3 - d2) > d * 0.003) {
                n3 = i - n + 1;
            }
            d2 = d3;
        }
        return n3;
    }

    double max(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i != dArray.length; ++i) {
            double d2 = Math.abs(dArray[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    double getFreqFromX(int n, View view) {
        double d = 0.5 * (double)(n - view.x) / (double)view.width;
        if (d <= 0.0 || d >= 0.5) {
            return -1.0;
        }
        if (this.logFreqCheckItem.getState()) {
            return Math.exp(this.minlog + 2.0 * d * this.logrange);
        }
        return d;
    }

    void setupFilter() {
        int n = this.filterChooser.getSelectedIndex();
        switch (n) {
            case 0: {
                this.filterType = new SincLowPassFilter();
                break;
            }
            case 1: {
                this.filterType = new SincHighPassFilter();
                break;
            }
            case 2: {
                this.filterType = new SincBandPassFilter();
                break;
            }
            case 3: {
                this.filterType = new SincBandStopFilter();
                break;
            }
            case 4: {
                this.filterType = new CustomFIRFilter();
                break;
            }
            case 5: {
                this.filterType = new NoFilter();
                break;
            }
            case 6: {
                this.filterType = new ButterLowPass();
                break;
            }
            case 7: {
                this.filterType = new ButterHighPass();
                break;
            }
            case 8: {
                this.filterType = new ButterBandPass();
                break;
            }
            case 9: {
                this.filterType = new ButterBandStop();
                break;
            }
            case 10: {
                this.filterType = new ChebyLowPass();
                break;
            }
            case 11: {
                this.filterType = new ChebyHighPass();
                break;
            }
            case 12: {
                this.filterType = new ChebyBandPass();
                break;
            }
            case 13: {
                this.filterType = new ChebyBandStop();
                break;
            }
            case 14: {
                this.filterType = new InvChebyLowPass();
                break;
            }
            case 15: {
                this.filterType = new InvChebyHighPass();
                break;
            }
            case 16: {
                this.filterType = new InvChebyBandPass();
                break;
            }
            case 17: {
                this.filterType = new InvChebyBandStop();
                break;
            }
            case 18: {
                this.filterType = new EllipticLowPass();
                break;
            }
            case 19: {
                this.filterType = new EllipticHighPass();
                break;
            }
            case 20: {
                this.filterType = new EllipticBandPass();
                break;
            }
            case 21: {
                this.filterType = new EllipticBandStop();
                break;
            }
            case 22: {
                this.filterType = new CombFilter(1);
                break;
            }
            case 23: {
                this.filterType = new CombFilter(-1);
                break;
            }
            case 24: {
                this.filterType = new DelayFilter();
                break;
            }
            case 25: {
                this.filterType = new PluckedStringFilter();
                break;
            }
            case 26: {
                this.filterType = new InverseCombFilter();
                break;
            }
            case 27: {
                this.filterType = new ResonatorFilter();
                break;
            }
            case 28: {
                this.filterType = new ResonatorZeroFilter();
                break;
            }
            case 29: {
                this.filterType = new NotchFilter();
                break;
            }
            case 30: {
                this.filterType = new MovingAverageFilter();
                break;
            }
            case 31: {
                this.filterType = new TriangleFilter();
                break;
            }
            case 32: {
                this.filterType = new AllPassFilter();
                break;
            }
            case 33: {
                this.filterType = new GaussianFilter();
                break;
            }
            case 34: {
                this.filterType = new RandomFilter();
                break;
            }
            case 35: {
                this.filterType = new CustomIIRFilter();
            }
        }
        if (this.filterSelection != n) {
            int n2;
            this.filterSelection = n;
            for (n2 = 0; n2 != this.auxBars.length; ++n2) {
                this.auxBars[n2].setMaximum(999);
            }
            int n3 = this.filterType.select();
            for (n2 = 0; n2 != n3; ++n2) {
                this.auxLabels[n2].show();
                this.auxBars[n2].show();
            }
            for (n2 = n3; n2 != this.auxBars.length; ++n2) {
                this.auxLabels[n2].hide();
                this.auxBars[n2].hide();
            }
            if (this.filterType.needsWindow()) {
                this.windowChooser.show();
                this.setWindow();
            } else {
                this.windowChooser.hide();
                this.setWindow();
            }
            this.validate();
        }
        this.filterType.setup();
        this.curFilter = null;
    }

    void setInputLabel() {
        this.wformInfo = this.getWaveformObject();
        String string = this.wformInfo.getInputText();
        if (string == null) {
            this.inputLabel.hide();
            this.inputBar.hide();
        } else {
            this.inputLabel.setText(string);
            this.inputLabel.show();
            this.inputBar.show();
        }
        this.validate();
    }

    Waveform getWaveformObject() {
        Waveform waveform;
        int n = this.inputChooser.getSelectedIndex();
        switch (n) {
            case 0: {
                waveform = new NoiseWaveform();
                break;
            }
            case 1: {
                waveform = new SineWaveform();
                break;
            }
            case 2: {
                waveform = new SawtoothWaveform();
                break;
            }
            case 3: {
                waveform = new TriangleWaveform();
                break;
            }
            case 4: {
                waveform = new SquareWaveform();
                break;
            }
            case 5: {
                waveform = new PeriodicNoiseWaveform();
                break;
            }
            case 6: {
                waveform = new SweepWaveform();
                break;
            }
            case 7: {
                waveform = new ImpulseWaveform();
                break;
            }
            default: {
                waveform = new Mp3Waveform(n - 8);
            }
        }
        return waveform;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint(this.pause);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(this.pause);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exitItem) {
            this.applet.destroyFrame();
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setupFilter();
        System.out.print(((Scrollbar)adjustmentEvent.getSource()).getValue() + "\n");
        if (adjustmentEvent.getSource() == this.inputBar) {
            this.setInputW();
        }
        this.cv.repaint(this.pause);
    }

    void setInputW() {
        this.inputW = Math.PI * (double)this.inputBar.getValue() / 1000.0;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.edit(mouseEvent);
        this.cv.repaint(this.pause);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dragX = this.mouseX = mouseEvent.getX();
        this.dragY = this.mouseY = mouseEvent.getY();
        this.cv.repaint(this.pause);
        if (this.respView != null && this.respView.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.selection = 1;
        }
        if (this.spectrumView != null && this.spectrumView.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.selection = 2;
        }
        if (this.polesView != null && this.polesView.contains(mouseEvent.getX(), mouseEvent.getY()) && !this.ferrisCheckItem.getState()) {
            this.selection = 3;
            this.selectPoleZero(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void selectPoleZero(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.selectedZero = -1;
        this.selectedPole = -1;
        int n8 = n7 = this.polesView.height / 2;
        int n9 = this.polesView.x + n8;
        int n10 = this.polesView.y + n7;
        Complex complex = new Complex();
        int n11 = this.filterType.getPoleCount();
        int n12 = this.filterType.getZeroCount();
        int n13 = 10000;
        for (n6 = 0; n6 != n11; ++n6) {
            this.filterType.getPole(n6, complex);
            n5 = n9 + (int)((double)n8 * complex.re);
            n4 = n10 - (int)((double)n7 * complex.im);
            n3 = this.distanceSq(n5, n4, n, n2);
            if (n3 > n13) continue;
            n13 = n3;
            this.selectedPole = n6;
            this.selectedZero = -1;
        }
        for (n6 = 0; n6 != n12; ++n6) {
            this.filterType.getZero(n6, complex);
            n5 = n9 + (int)((double)n8 * complex.re);
            n4 = n10 - (int)((double)n7 * complex.im);
            n3 = this.distanceSq(n5, n4, n, n2);
            if (n3 >= n13) continue;
            n13 = n3;
            this.selectedPole = -1;
            this.selectedZero = n6;
        }
    }

    int distanceSq(int n, int n2, int n3, int n4) {
        return (n - n3) * (n - n3) + (n2 - n4) * (n2 - n4);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
        this.edit(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void edit(MouseEvent mouseEvent) {
        double d;
        if (this.selection == 1) {
            if (this.filterType instanceof CustomFIRFilter) {
                this.editCustomFIRFilter(mouseEvent);
                return;
            }
            d = this.getFreqFromX(mouseEvent.getX(), this.respView);
            if (d < 0.0) {
                return;
            }
            this.filterType.setCutoff(d);
            this.setupFilter();
        }
        if (this.selection == 2) {
            if (!this.wformInfo.needsFrequency()) {
                return;
            }
            d = this.getFreqFromX(mouseEvent.getX(), this.spectrumView);
            if (d < 0.0) {
                return;
            }
            this.inputW = Math.PI * 2 * d;
            this.inputBar.setValue((int)(2000.0 * d));
        }
        if (this.selection == 3 && this.filterType instanceof CustomIIRFilter) {
            this.editCustomIIRFilter(mouseEvent);
            return;
        }
    }

    void editCustomFIRFilter(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.dragX == n) {
            this.editCustomFIRFilterPoint(n, n2);
            this.dragY = n2;
        } else {
            int n3 = n < this.dragX ? n : this.dragX;
            int n4 = n < this.dragX ? n2 : this.dragY;
            int n5 = n > this.dragX ? n : this.dragX;
            int n6 = n > this.dragX ? n2 : this.dragY;
            this.dragX = n;
            this.dragY = n2;
            for (n = n3; n <= n5; ++n) {
                n2 = n4 + (n6 - n4) * (n - n3) / (n5 - n3);
                this.editCustomFIRFilterPoint(n, n2);
            }
        }
        this.setupFilter();
    }

    void editCustomFIRFilterPoint(int n, int n2) {
        double d = this.getFreqFromX(n, this.respView) * 2.0;
        double d2 = this.getFreqFromX(n + 1, this.respView) * 2.0;
        n2 -= this.respView.y;
        double d3 = 0.069;
        double d4 = Math.exp((double)(-n2) * Math.log(10.0) / (d3 * 4.0 * (double)this.respView.height));
        if (d4 >= 1.0) {
            d4 = 1.0;
        }
        ((CustomFIRFilter)this.filterType).edit(d, d2, d4);
    }

    void editCustomIIRFilter(MouseEvent mouseEvent) {
        int n;
        if (this.ferrisCheckItem.getState()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = n = this.polesView.height / 2;
        int n5 = this.polesView.x + n4;
        int n6 = this.polesView.y + n;
        Complex complex = new Complex();
        complex.set((double)(n2 - n5) / (double)n4, (double)(n3 - n6) / (double)n);
        ((CustomIIRFilter)this.filterType).editPoleZero(complex);
        this.setupFilter();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.filterChanged = true;
        if (itemEvent.getSource() == this.displayCheck) {
            this.cv.repaint(this.pause);
            return;
        }
        if (itemEvent.getSource() == this.inputChooser) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.setInputLabel();
        }
        if (itemEvent.getSource() == this.rateChooser) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.inputW *= (double)this.sampleRate;
            switch (this.rateChooser.getSelectedIndex()) {
                case 0: {
                    this.sampleRate = 8000;
                    break;
                }
                case 1: {
                    this.sampleRate = 11025;
                    break;
                }
                case 2: {
                    this.sampleRate = 16000;
                    break;
                }
                case 3: {
                    this.sampleRate = 22050;
                    break;
                }
                case 4: {
                    this.sampleRate = 32000;
                    break;
                }
                case 5: {
                    this.sampleRate = 44100;
                }
            }
            this.inputW /= (double)this.sampleRate;
        }
        if (itemEvent.getSource() == this.shiftSpectrumCheck) {
            if (this.shiftSpectrumCheck.getState()) {
                this.shiftFreqLabel.show();
                this.shiftFreqBar.show();
            } else {
                this.shiftFreqLabel.hide();
                this.shiftFreqBar.hide();
            }
            this.validate();
        }
        if (itemEvent.getSource() == this.windowChooser) {
            this.setWindow();
        }
        if (itemEvent.getSource() instanceof CheckboxMenuItem) {
            this.handleResize();
        } else {
            this.setupFilter();
        }
        this.cv.repaint(this.pause);
    }

    void setWindow() {
        if (this.windowChooser.getSelectedIndex() == WINDOW_KAISER && this.filterType.needsWindow()) {
            this.kaiserLabel.show();
            this.kaiserBar.show();
        } else {
            this.kaiserLabel.hide();
            this.kaiserBar.hide();
        }
        this.validate();
    }

    void setSampleRate(int n) {
        int n2 = 0;
        switch (n) {
            case 8000: {
                n2 = 0;
                break;
            }
            case 11025: {
                n2 = 1;
                break;
            }
            case 16000: {
                n2 = 2;
                break;
            }
            case 22050: {
                n2 = 3;
                break;
            }
            case 32000: {
                n2 = 4;
                break;
            }
            case 44100: {
                n2 = 5;
            }
        }
        this.rateChooser.select(n2);
        this.sampleRate = n;
    }

    String getOmegaText(double d) {
        return (int)(d * (double)this.sampleRate / (Math.PI * 2)) + " Hz";
    }

    double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    double acosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    String getUnitText(double d, String string) {
        double d2 = Math.abs(d);
        if (d2 < 1.0E-17) {
            return "0 " + string;
        }
        if (d2 < 1.0E-12) {
            return this.showFormat.format(d * 1.0E15) + " f" + string;
        }
        if (d2 < 1.0E-9) {
            return this.showFormat.format(d * 1.0E12) + " p" + string;
        }
        if (d2 < 1.0E-6) {
            return this.showFormat.format(d * 1.0E9) + " n" + string;
        }
        if (d2 < 0.001) {
            return this.showFormat.format(d * 1000000.0) + " \u03bc" + string;
        }
        if (d2 < 0.01 || string.compareTo("m") != 0 && d2 < 1.0) {
            return this.showFormat.format(d * 1000.0) + " m" + string;
        }
        if (d2 < 1.0) {
            return this.showFormat.format(d * 100.0) + " c" + string;
        }
        if (d2 < 1000.0) {
            return this.showFormat.format(d) + " " + string;
        }
        if (d2 < 1000000.0) {
            return this.showFormat.format(d * 0.001) + " k" + string;
        }
        if (d2 < 1.0E9) {
            return this.showFormat.format(d * 1.0E-6) + " M" + string;
        }
        if (d2 < 1.0E12) {
            return this.showFormat.format(d * 1.0E-9) + " G" + string;
        }
        if (d2 < 1.0E15) {
            return this.showFormat.format(d * 1.0E-12) + " T" + string;
        }
        return d + " " + string;
    }

    double bessi0(double d) {
        double d2;
        double d3;
        double d4 = Math.abs(d);
        if (d3 < 3.75) {
            double d5 = d / 3.75;
            d5 *= d5;
            d2 = 1.0 + d5 * (3.5156229 + d5 * (3.0899424 + d5 * (1.2067492 + d5 * (0.2659732 + d5 * (0.0360768 + d5 * 0.0045813)))));
        } else {
            double d6 = 3.75 / d4;
            d2 = Math.exp(d4) / Math.sqrt(d4) * (0.39894228 + d6 * (0.01328592 + d6 * (0.00225319 + d6 * (-0.00157565 + d6 * (0.00916281 + d6 * (-0.02057706 + d6 * (0.02635537 + d6 * (-0.01647633 + d6 * 0.00392377))))))));
        }
        return d2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CustomIIRFilter
    extends IIRFilterType {
        int npoles;
        int nzeros;

        CustomIIRFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("# of Pole Pairs");
            DFilterFrame.this.auxBars[0].setMaximum(10);
            DFilterFrame.this.auxBars[0].setValue(DFilterFrame.this.lastPoleCount / 2);
            return 1;
        }

        void setup() {
            this.npoles = this.nzeros = DFilterFrame.this.auxBars[0].getValue() * 2;
        }

        void getPole(int n, Complex complex) {
            complex.set(DFilterFrame.this.customPoles[n]);
        }

        int getPoleCount() {
            return this.npoles;
        }

        void getZero(int n, Complex complex) {
            complex.set(DFilterFrame.this.customZeros[n]);
        }

        int getZeroCount() {
            return this.nzeros;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Custom IIR";
            stringArray[1] = this.npoles + " poles and zeros";
        }

        void editPoleZero(Complex complex) {
            if (complex.mag > 1.1) {
                return;
            }
            if (DFilterFrame.this.selectedPole != -1) {
                DFilterFrame.this.customPoles[DFilterFrame.this.selectedPole].set(complex);
                DFilterFrame.this.customPoles[DFilterFrame.this.selectedPole ^ 1].set(complex.re, -complex.im);
            }
            if (DFilterFrame.this.selectedZero != -1) {
                DFilterFrame.this.customZeros[DFilterFrame.this.selectedZero].set(complex);
                DFilterFrame.this.customZeros[DFilterFrame.this.selectedZero ^ 1].set(complex.re, -complex.im);
            }
        }
    }

    class NoFilter
    extends FilterType {
        NoFilter() {
        }

        void getResponse(double d, Complex complex) {
            complex.set(1.0);
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[1];
            directFilter.aList[0] = 1.0;
            return directFilter;
        }
    }

    class CustomFIRFilter
    extends FIRFilterType {
        CustomFIRFilter() {
            if (DFilterFrame.this.uresp == null) {
                DFilterFrame.this.uresp = new double[1024];
            }
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Order");
            DFilterFrame.this.auxBars[0].setValue(120);
            DFilterFrame.this.auxBars[0].setMaximum(1600);
            for (int i = 0; i != 512; ++i) {
                DFilterFrame.this.uresp[i] = 1.0;
            }
            return 1;
        }

        void setup() {
        }

        double getUserResponse(double d) {
            double d2 = DFilterFrame.this.uresp[(int)(d * (double)DFilterFrame.this.uresp.length / Math.PI)];
            return d2 * d2;
        }

        void edit(double d, double d2, double d3) {
            int n = (int)(d2 * (double)DFilterFrame.this.uresp.length);
            for (int i = (int)(d * (double)DFilterFrame.this.uresp.length); i < n; ++i) {
                if (i < 0 || i >= DFilterFrame.this.uresp.length) continue;
                DFilterFrame.this.uresp[i] = d3;
            }
        }

        Filter genFilter() {
            int n;
            int n2 = DFilterFrame.this.auxBars[0].getValue();
            int n3 = DFilterFrame.this.uresp.length * 4;
            double[] dArray = new double[n3];
            int n4 = n3 / 2;
            int n5 = n4 / 2;
            for (n = 0; n != n5; ++n) {
                double d;
                dArray[n * 2] = d = DFilterFrame.this.uresp[n] / (double)n4;
                if (n <= 0) continue;
                dArray[n3 - n * 2] = d;
            }
            new FFT(n4).transform(dArray, true);
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[n2];
            directFilter.nList = new int[n2];
            for (n = 0; n != n2; ++n) {
                int n6 = (n - n2 / 2) * 2;
                directFilter.aList[n] = dArray[n6 & n3 - 1] * this.getWindow(n, n2);
                directFilter.nList[n] = n;
            }
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            int n = DFilterFrame.this.auxBars[0].getValue();
            stringArray[0] = "Order: " + n;
        }

        boolean needsWindow() {
            return true;
        }
    }

    class TriangleFilter
    extends FIRFilterType {
        int ni;
        double n;

        TriangleFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Cutoff Frequency");
            DFilterFrame.this.auxBars[0].setValue(500);
            return 1;
        }

        void setup() {
            this.n = 4000.0 / (double)DFilterFrame.this.auxBars[0].getValue();
            if (this.n > 1000.0) {
                this.n = 1000.0;
            }
            this.ni = (int)this.n;
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[this.ni + 1];
            double d = 0.0;
            double d2 = this.n / 2.0;
            int n = 0;
            while ((double)n < this.n) {
                double d3 = 0.0;
                d3 = (double)n < d2 ? (double)n / d2 : 2.0 - (double)n / d2;
                d += d3;
                directFilter.aList[n] = d3;
                ++n;
            }
            n = 0;
            while (n != directFilter.aList.length) {
                int n2 = n++;
                directFilter.aList[n2] = directFilter.aList[n2] / d;
            }
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Triangle (FIR)";
            stringArray[1] = "Cutoff: " + DFilterFrame.this.getOmegaText(Math.PI * 4 / this.n);
            stringArray[2] = "Length: " + DFilterFrame.this.showFormat.format(this.n);
        }
    }

    class MovingAverageFilter
    extends FIRFilterType {
        double n;
        int ni;

        MovingAverageFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Cutoff Frequency");
            DFilterFrame.this.auxBars[0].setValue(500);
            return 1;
        }

        void setup() {
            this.n = 2000.0 / (double)DFilterFrame.this.auxBars[0].getValue();
            if (this.n > 1000.0) {
                this.n = 1000.0;
            }
            this.ni = (int)this.n;
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[this.ni + 1];
            for (int i = 0; i != this.ni; ++i) {
                directFilter.aList[i] = 1.0 / this.n;
            }
            directFilter.aList[i] = (this.n - (double)this.ni) / this.n;
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Moving Average (FIR)";
            stringArray[1] = "Cutoff: " + DFilterFrame.this.getOmegaText(Math.PI * 2 / this.n);
            stringArray[2] = "Length: " + DFilterFrame.this.showFormat.format(this.n);
        }
    }

    class SincBandPassFilter
    extends SincBandStopFilter {
        SincBandPassFilter() {
            this.invert = true;
        }
    }

    class SincBandStopFilter
    extends FIRFilterType {
        int n;
        double wc1;
        double wc2;
        double mult;
        double peak;
        double[] resp;
        boolean invert;

        SincBandStopFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Center Frequency");
            DFilterFrame.this.auxLabels[1].setText(this.invert ? "Passband Width" : "Stopband Width");
            DFilterFrame.this.auxLabels[2].setText("Order");
            DFilterFrame.this.auxBars[0].setValue(500);
            DFilterFrame.this.auxBars[1].setValue(50);
            DFilterFrame.this.auxBars[2].setValue(140);
            DFilterFrame.this.auxBars[2].setMaximum(1600);
            return 3;
        }

        void setup() {
            double d = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            double d2 = (double)DFilterFrame.this.auxBars[1].getValue() * Math.PI / 1000.0;
            this.wc1 = d - d2;
            this.wc2 = d + d2;
            if (this.wc1 < 0.0) {
                this.wc1 = 0.0;
            }
            if (this.wc2 > Math.PI) {
                this.wc2 = Math.PI;
            }
            this.n = DFilterFrame.this.auxBars[2].getValue();
        }

        int getPoleCount() {
            return 0;
        }

        void getPole(int n, Complex complex) {
        }

        Filter genFilter() {
            int n;
            int n2;
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[this.n + 1];
            double[] dArray = new double[this.n + 1];
            int n3 = this.n / 2;
            double d = 0.0;
            for (n2 = 0; n2 != this.n; ++n2) {
                n = n2 - n3;
                directFilter.aList[n2] = (n == 0 ? this.wc1 : Math.sin(this.wc1 * (double)n) / (double)n) * this.getWindow(n2, this.n);
                d += directFilter.aList[n2];
            }
            if (d > 0.0) {
                n2 = 0;
                while (n2 != this.n) {
                    int n4 = n2++;
                    directFilter.aList[n4] = directFilter.aList[n4] / d;
                }
            }
            d = 0.0;
            for (n2 = 0; n2 != this.n; ++n2) {
                n = n2 - n3;
                dArray[n2] = (n == 0 ? this.wc2 : Math.sin(this.wc2 * (double)n) / (double)n) * this.getWindow(n2, this.n);
                d += dArray[n2];
            }
            n2 = 0;
            while (n2 != this.n) {
                int n5 = n2++;
                dArray[n5] = dArray[n5] / d;
            }
            for (n2 = 0; n2 != this.n; ++n2) {
                int n6 = n2;
                directFilter.aList[n6] = directFilter.aList[n6] - dArray[n2];
            }
            int n7 = n3;
            directFilter.aList[n7] = directFilter.aList[n7] + 1.0;
            if (this.invert) {
                for (n2 = 0; n2 != this.n; ++n2) {
                    directFilter.aList[n2] = -directFilter.aList[n2];
                }
                int n8 = n3;
                directFilter.aList[n8] = directFilter.aList[n8] + 1.0;
            }
            if (this.n == 1) {
                directFilter.aList[0] = 1.0;
            }
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = this.invert ? "Passband: " : "Stopband: ";
            stringArray[0] = stringArray[0] + DFilterFrame.this.getOmegaText(this.wc1) + " - " + DFilterFrame.this.getOmegaText(this.wc2);
            stringArray[1] = "Order: " + this.n;
        }

        boolean needsWindow() {
            return true;
        }
    }

    class SincHighPassFilter
    extends SincLowPassFilter {
        SincHighPassFilter() {
            this.invert = true;
        }
    }

    class SincLowPassFilter
    extends FIRFilterType {
        int n;
        double wc;
        double mult;
        double peak;
        double[] resp;
        boolean invert;

        SincLowPassFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Cutoff Frequency");
            DFilterFrame.this.auxLabels[1].setText("Order");
            DFilterFrame.this.auxBars[0].setValue(this.invert ? 500 : 100);
            DFilterFrame.this.auxBars[1].setValue(120);
            DFilterFrame.this.auxBars[1].setMaximum(1600);
            return 2;
        }

        void setup() {
            this.wc = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            this.n = DFilterFrame.this.auxBars[1].getValue();
        }

        Filter genFilter() {
            int n;
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[this.n];
            int n2 = this.n / 2;
            double d = 0.0;
            for (n = 0; n != this.n; ++n) {
                int n3 = n - n2;
                directFilter.aList[n] = (n3 == 0 ? this.wc : Math.sin(this.wc * (double)n3) / (double)n3) * this.getWindow(n, this.n);
                d += directFilter.aList[n];
            }
            n = 0;
            while (n != this.n) {
                int n4 = n++;
                directFilter.aList[n4] = directFilter.aList[n4] / d;
            }
            if (this.invert) {
                for (n = 0; n != this.n; ++n) {
                    directFilter.aList[n] = -directFilter.aList[n];
                }
                int n5 = n2;
                directFilter.aList[n5] = directFilter.aList[n5] + 1.0;
            }
            if (this.n == 1) {
                directFilter.aList[0] = 1.0;
            }
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Cutoff freq: " + DFilterFrame.this.getOmegaText(this.wc);
            stringArray[1] = "Order: " + this.n;
        }

        boolean needsWindow() {
            return true;
        }
    }

    abstract class FIRFilterType
    extends FilterType {
        double[] response;

        FIRFilterType() {
        }

        void getResponse(double d, Complex complex) {
            if (this.response == null) {
                complex.set(0.0);
                return;
            }
            int n = (int)((double)this.response.length * d / (Math.PI * 2));
            if ((n &= 0xFFFFFFFE) < 0) {
                n = 0;
            }
            if (n >= this.response.length) {
                n = this.response.length - 2;
            }
            complex.set(this.response[n], this.response[n + 1]);
        }

        double getWindow(int n, int n2) {
            if (n2 == 1) {
                return 1.0;
            }
            double d = Math.PI * 2 * (double)n / (double)(n2 - 1);
            double d2 = n2 / 2;
            switch (DFilterFrame.this.windowChooser.getSelectedIndex()) {
                case 0: {
                    return 1.0;
                }
                case 1: {
                    return 0.54 - 0.46 * Math.cos(d);
                }
                case 2: {
                    return 0.5 - 0.5 * Math.cos(d);
                }
                case 3: {
                    return 0.42 - 0.5 * Math.cos(d) + 0.08 * Math.cos(2.0 * d);
                }
                case 4: {
                    double d3 = (double)DFilterFrame.this.kaiserBar.getValue() * Math.PI / 120.0;
                    double d4 = (double)(2 * n) / (double)n2 - 1.0;
                    return DFilterFrame.this.bessi0(d3 * Math.sqrt(1.0 - d4 * d4));
                }
                case 5: {
                    return (double)n < d2 ? (double)n / d2 : 2.0 - (double)n / d2;
                }
                case 6: {
                    double d5 = ((double)n - d2) / d2;
                    return 1.0 - d5 * d5;
                }
            }
            return 0.0;
        }

        void setResponse(DirectFilter directFilter) {
            int n;
            int n2;
            this.response = new double[8192];
            if (directFilter.nList.length != directFilter.aList.length) {
                directFilter.nList = new int[directFilter.aList.length];
                for (n2 = 0; n2 != directFilter.aList.length; ++n2) {
                    directFilter.nList[n2] = n2;
                }
            }
            for (n2 = 0; n2 != directFilter.aList.length; ++n2) {
                this.response[directFilter.nList[n2] * 2] = directFilter.aList[n2];
            }
            new FFT(this.response.length / 2).transform(this.response, false);
            double d = 0.0;
            for (n = 0; n != this.response.length; n += 2) {
                double d2 = this.response[n] * this.response[n] + this.response[n + 1] * this.response[n + 1];
                if (!(d < d2)) continue;
                d = d2;
            }
            d = Math.sqrt(d);
            n = 0;
            while (n != this.response.length) {
                int n3 = n++;
                this.response[n3] = this.response[n3] / d;
            }
            n = 0;
            while (n != directFilter.aList.length) {
                int n4 = n++;
                directFilter.aList[n4] = directFilter.aList[n4] / d;
            }
        }
    }

    class BoxFilter
    extends FIRFilterType {
        double cw;
        double r;
        double norm;
        int n;

        BoxFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Fundamental Freq");
            DFilterFrame.this.auxBars[0].setValue(500);
            DFilterFrame.this.auxLabels[1].setText("Position");
            DFilterFrame.this.auxBars[1].setValue(300);
            DFilterFrame.this.auxLabels[2].setText("Length/Width");
            DFilterFrame.this.auxBars[2].setValue(100);
            DFilterFrame.this.auxLabels[3].setText("Order");
            DFilterFrame.this.auxBars[3].setMaximum(1600);
            DFilterFrame.this.auxBars[3].setValue(100);
            return 4;
        }

        void setCutoff(double d) {
        }

        void setup() {
            this.cw = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            if (this.cw < 0.147) {
                this.cw = 0.147;
            }
            this.r = (double)DFilterFrame.this.auxBars[1].getValue() / 1000.0;
            this.n = DFilterFrame.this.auxBars[3].getValue();
        }

        Filter genFilter() {
            int n;
            int n2;
            DirectFilter directFilter = new DirectFilter();
            int n3 = 20;
            double[][] dArray = new double[n3][n3];
            double[][] dArray2 = new double[n3][n3];
            double d = this.r * Math.PI;
            double d2 = 1.5707963267948966;
            double d3 = (double)DFilterFrame.this.auxBars[2].getValue() / 100.0;
            for (n2 = 0; n2 != n3; ++n2) {
                for (n = 0; n != n3; ++n) {
                    dArray[n2][n] = this.cw * Math.sqrt((double)(n2 * n2) + (double)(n * n) / d3);
                    dArray2[n2][n] = Math.cos((double)n2 * d) * Math.cos((double)n * d2);
                }
            }
            dArray2[0][0] = 0.0;
            directFilter.aList = new double[this.n];
            double d4 = 0.0;
            double d5 = -2.5 / (double)this.n;
            for (int i = 0; i != this.n; ++i) {
                double d6 = 0.0;
                for (n2 = 0; n2 != n3; ++n2) {
                    for (n = 0; n != n3; ++n) {
                        double d7 = (double)i * dArray[n2][n];
                        d6 += dArray2[n2][n] * Math.cos(d7);
                    }
                }
                directFilter.aList[i] = d6 * Math.exp(d5 * (double)i);
                d4 += d6;
            }
            n2 = 0;
            while (n2 != this.n) {
                int n4 = n2++;
                directFilter.aList[n4] = directFilter.aList[n4] / d4;
            }
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Order: " + this.n;
        }
    }

    class RandomFilter
    extends FIRFilterType {
        int n;

        RandomFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Order");
            DFilterFrame.this.auxBars[0].setMaximum(1600);
            DFilterFrame.this.auxBars[0].setValue(100);
            return 1;
        }

        void setCutoff(double d) {
        }

        void setup() {
            this.n = DFilterFrame.this.auxBars[0].getValue();
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[this.n];
            for (int i = 0; i != this.n; ++i) {
                directFilter.aList[i] = (double)DFilterFrame.this.random.nextInt() * this.getWindow(i, this.n);
            }
            this.setResponse(directFilter);
            return directFilter;
        }

        boolean needsWindow() {
            return true;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Random (FIR)";
            stringArray[1] = "Order: " + this.n;
        }
    }

    class GaussianFilter
    extends FIRFilterType {
        int n;
        double cw;

        GaussianFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Offset");
            DFilterFrame.this.auxBars[0].setMaximum(1000);
            DFilterFrame.this.auxBars[0].setValue(100);
            DFilterFrame.this.auxLabels[1].setText("Width");
            DFilterFrame.this.auxBars[1].setMaximum(1000);
            DFilterFrame.this.auxBars[1].setValue(100);
            DFilterFrame.this.auxLabels[2].setText("Order");
            DFilterFrame.this.auxBars[2].setMaximum(1600);
            DFilterFrame.this.auxBars[2].setValue(160);
            return 3;
        }

        void setup() {
            this.n = DFilterFrame.this.auxBars[2].getValue();
            this.cw = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[this.n];
            double d = (double)DFilterFrame.this.auxBars[1].getValue() / 100000.0;
            int n = this.n / 2;
            for (int i = 0; i != this.n; ++i) {
                int n2 = i - n;
                directFilter.aList[i] = Math.exp(-d * (double)n2 * (double)n2) * Math.cos((double)n2 * this.cw) * this.getWindow(i, this.n);
            }
            this.setResponse(directFilter);
            return directFilter;
        }

        boolean needsWindow() {
            return true;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Gaussian (FIR)";
            stringArray[1] = "Order: " + this.n;
        }
    }

    class PluckedStringFilter
    extends IIRFilterType {
        int n;
        double mult;

        PluckedStringFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Fundamental");
            DFilterFrame.this.auxBars[0].setValue(20);
            DFilterFrame.this.auxLabels[1].setText("Sharpness");
            DFilterFrame.this.auxBars[1].setValue(970);
            return 2;
        }

        void setup() {
            this.n = 2000 / DFilterFrame.this.auxBars[0].getValue();
            this.mult = 0.5 * Math.exp(-0.5 + (double)DFilterFrame.this.auxBars[1].getValue() / 2000.0);
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[]{1.0, 1.0, 0.0, 0.0};
            directFilter.bList = new double[]{1.0, 0.0, -this.mult, -this.mult};
            directFilter.nList = new int[]{0, 1, this.n, this.n + 1};
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Plucked String (IIR); Resonance every " + DFilterFrame.this.getOmegaText(Math.PI * 2 / (double)this.n);
            stringArray[1] = "Delay: " + this.n + " samples, " + DFilterFrame.this.getUnitText((double)this.n / (double)DFilterFrame.this.sampleRate, "s");
        }
    }

    class AllPassFilter
    extends IIRFilterType {
        double a;

        AllPassFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Phase Delay");
            DFilterFrame.this.auxBars[0].setValue(500);
            return 1;
        }

        void setup() {
            double d = (double)DFilterFrame.this.auxBars[0].getValue() / 1000.0;
            this.a = (1.0 - d) / (1.0 + d);
        }

        void getPole(int n, Complex complex) {
            complex.set(-this.a);
        }

        int getPoleCount() {
            return 1;
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[2];
            directFilter.bList = new double[2];
            directFilter.nList = new int[]{0, 1};
            directFilter.aList[0] = this.a;
            directFilter.aList[1] = 1.0;
            directFilter.bList[0] = 1.0;
            directFilter.bList[1] = this.a;
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Allpass Fractional Delay (IIR)";
        }
    }

    class NotchFilter
    extends IIRFilterType {
        double wc;
        double a;
        double b;
        double bw;

        NotchFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Notch Frequency");
            DFilterFrame.this.auxBars[0].setValue(500);
            DFilterFrame.this.auxLabels[1].setText("Bandwidth");
            DFilterFrame.this.auxBars[1].setValue(900);
            return 2;
        }

        void setup() {
            this.wc = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            this.bw = (double)DFilterFrame.this.auxBars[1].getValue() * Math.PI / 2000.0;
            this.a = (1.0 - Math.tan(this.bw / 2.0)) / (1.0 + Math.tan(this.bw / 2.0));
            this.b = Math.cos(this.wc);
        }

        void getPole(int n, Complex complex) {
            complex.set(-4.0 * this.a + (this.b + this.a * this.b) * (this.b + this.a * this.b));
            complex.sqrt();
            if (n == 1) {
                complex.mult(-1.0);
            }
            complex.add(this.b + this.a * this.b);
            complex.mult(0.5);
        }

        int getPoleCount() {
            return 2;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Notch (IIR)";
            stringArray[1] = "Notch Frequency: " + DFilterFrame.this.getOmegaText(this.wc);
            stringArray[2] = "Bandwidth: " + DFilterFrame.this.getOmegaText(this.bw);
        }

        int getZeroCount() {
            return 2;
        }

        void getZero(int n, Complex complex) {
            complex.set(this.b * this.b - 1.0);
            complex.sqrt();
            if (n == 1) {
                complex.mult(-1.0);
            }
            complex.add(this.b);
        }
    }

    class ResonatorZeroFilter
    extends ResonatorFilter {
        ResonatorZeroFilter() {
        }

        int getZeroCount() {
            return 2;
        }

        void getZero(int n, Complex complex) {
            complex.set(n == 0 ? 1.0 : -1.0);
        }
    }

    class ResonatorFilter
    extends IIRFilterType {
        double r;
        double wc;

        ResonatorFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Resonant Frequency");
            DFilterFrame.this.auxBars[0].setValue(500);
            DFilterFrame.this.auxLabels[1].setText("Sharpness");
            DFilterFrame.this.auxBars[1].setValue(900);
            return 2;
        }

        void setup() {
            this.wc = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            double d = (double)(-DFilterFrame.this.auxBars[1].getValue() * 3) / 1000.0;
            this.r = 1.0 - Math.pow(10.0, d);
        }

        void getPole(int n, Complex complex) {
            complex.setMagPhase(this.r, n == 1 ? -this.wc : this.wc);
        }

        int getPoleCount() {
            return 2;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Reson (IIR)";
            stringArray[1] = "Res. Frequency: " + DFilterFrame.this.getOmegaText(this.wc);
        }
    }

    class DelayFilter
    extends CombFilter {
        DelayFilter() {
            super(1);
        }

        void getResponse(double d, Complex complex) {
            if (this.n > 212) {
                complex.set(1.0);
            } else {
                super.getResponse(d, complex);
            }
        }

        void setCutoff(double d) {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("Delay");
            DFilterFrame.this.auxBars[0].setValue(300);
            DFilterFrame.this.auxLabels[1].setText("Strength");
            DFilterFrame.this.auxBars[1].setValue(700);
            return 2;
        }

        void setup() {
            this.n = DFilterFrame.this.auxBars[0].getValue() * 16384 / 1000;
            this.mult = (double)DFilterFrame.this.auxBars[1].getValue() / 1250.0;
            this.peak = 1.0 / (1.0 - this.mult);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Delay (IIR)";
            stringArray[1] = "Delay: " + this.n + " samples, " + DFilterFrame.this.getUnitText((double)this.n / (double)DFilterFrame.this.sampleRate, "s");
            double d = 340.0 * (double)this.n / (double)DFilterFrame.this.sampleRate / 2.0;
            stringArray[2] = "Echo Distance: " + DFilterFrame.this.getUnitText(d, "m");
            if (d > 1.0) {
                stringArray[2] = stringArray[2] + " (" + DFilterFrame.this.showFormat.format(d * 3.28084) + " ft)";
            }
        }
    }

    class InverseCombFilter
    extends FIRFilterType {
        int n;
        double mult;
        double peak;

        InverseCombFilter() {
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("2nd Zero");
            DFilterFrame.this.auxBars[0].setValue(60);
            DFilterFrame.this.auxLabels[1].setText("Sharpness");
            DFilterFrame.this.auxBars[1].setValue(1000);
            return 2;
        }

        void setup() {
            this.n = 1990 / DFilterFrame.this.auxBars[0].getValue();
            this.mult = (double)DFilterFrame.this.auxBars[1].getValue() / 1000.0;
            this.peak = 1.0 + this.mult;
        }

        void getZero(int n, Complex complex) {
            complex.setMagPhase(Math.pow(this.mult, 1.0 / (double)this.n), Math.PI * 2 * (double)n / (double)this.n);
        }

        int getZeroCount() {
            return this.n;
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[]{1.0 / this.peak, -this.mult / this.peak};
            directFilter.nList = new int[]{0, this.n};
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Inverse Comb (FIR)";
            stringArray[1] = "Zeros every " + DFilterFrame.this.getOmegaText(Math.PI * 2 / (double)this.n);
        }
    }

    class CombFilter
    extends IIRFilterType {
        int n;
        int sign;
        double mult;
        double peak;

        CombFilter(int n) {
            this.sign = n;
        }

        int select() {
            DFilterFrame.this.auxLabels[0].setText("1st Pole");
            DFilterFrame.this.auxBars[0].setValue(60);
            DFilterFrame.this.auxLabels[1].setText("Sharpness");
            DFilterFrame.this.auxBars[1].setValue(700);
            return 2;
        }

        void setup() {
            this.n = 2000 / DFilterFrame.this.auxBars[0].getValue();
            this.mult = (double)DFilterFrame.this.auxBars[1].getValue() / 1000.0;
            this.peak = 1.0 / (1.0 - this.mult);
        }

        void getPole(int n, Complex complex) {
            int n2 = this.sign == 1 ? 0 : 1;
            complex.setMagPhase(Math.pow(this.mult, 1.0 / (double)this.n), Math.PI * (double)(n2 + 2 * n) / (double)this.n);
        }

        Filter genFilter() {
            DirectFilter directFilter = new DirectFilter();
            directFilter.aList = new double[]{1.0 / this.peak, 0.0};
            directFilter.bList = new double[]{0.0, (double)(-this.sign) * this.mult};
            directFilter.nList = new int[]{0, this.n};
            this.setResponse(directFilter);
            return directFilter;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Comb (IIR); Resonance every " + DFilterFrame.this.getOmegaText(Math.PI * 2 / (double)this.n);
            stringArray[1] = "Delay: " + this.n + " samples, " + DFilterFrame.this.getUnitText((double)this.n / (double)DFilterFrame.this.sampleRate, "s");
            double d = 340.0 * (double)this.n / (double)(DFilterFrame.this.sampleRate * 2);
            stringArray[2] = "Tube length: " + DFilterFrame.this.getUnitText(d, "m");
            stringArray[2] = this.sign == -1 ? stringArray[2] + " (closed)" : stringArray[2] + " (open)";
        }

        int getPoleCount() {
            return this.n;
        }

        int getZeroCount() {
            return this.n;
        }

        void getZero(int n, Complex complex) {
            complex.set(0.0);
        }
    }

    class EllipticBandStop
    extends EllipticBandPass {
        EllipticBandStop() {
        }

        void getPole(int n, Complex complex) {
            this.getBandStopPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getEllipticZero(n / 2, complex, 1.5707963267948966);
            this.bandStopXform(n, complex);
        }
    }

    class EllipticBandPass
    extends EllipticFilterType {
        EllipticBandPass() {
        }

        int select() {
            int n = this.selectBandPass();
            DFilterFrame.this.auxBars[2].setValue(5);
            this.selectElliptic(n);
            return n + 2;
        }

        void setup() {
            this.setupBandPass();
            this.setupElliptic(3);
        }

        void getPole(int n, Complex complex) {
            this.getBandPassPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getEllipticZero(n / 2, complex, 1.5707963267948966);
            this.bandPassXform(n, complex);
        }

        int getPoleCount() {
            return this.n * 2;
        }

        int getZeroCount() {
            return this.n * 2;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Elliptic (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoBandPass(stringArray, this instanceof EllipticBandStop);
            this.getInfoElliptic(stringArray);
        }
    }

    class EllipticHighPass
    extends EllipticLowPass {
        EllipticHighPass() {
        }

        void getPole(int n, Complex complex) {
            this.getSPole(n, complex, Math.PI - this.wc);
            this.bilinearXform(complex);
            complex.mult(-1.0);
        }

        void getZero(int n, Complex complex) {
            this.getEllipticZero(n, complex, Math.PI - this.wc);
            complex.mult(-1.0);
        }
    }

    class EllipticLowPass
    extends EllipticFilterType {
        EllipticLowPass() {
        }

        int select() {
            int n = this.selectLowPass();
            this.selectElliptic(n);
            return n + 2;
        }

        void setup() {
            this.setupLowPass();
            this.setupElliptic(2);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Elliptic (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoLowPass(stringArray);
            this.getInfoElliptic(stringArray);
        }

        void getZero(int n, Complex complex) {
            this.getEllipticZero(n, complex, this.wc);
        }
    }

    abstract class EllipticFilterType
    extends PoleFilterType {
        double p0;
        double q;
        double[] zeros;
        double K;
        double Kprime;
        double[] c1 = new double[100];
        double[] b1 = new double[100];
        double[] a1 = new double[100];
        double[] d1 = new double[100];
        double[] q1 = new double[100];
        double[] z1 = new double[100];
        double[] f1 = new double[100];
        double[] s1 = new double[100];
        double[] p = new double[100];
        double[] zw1 = new double[100];
        double[] zf1 = new double[100];
        double[] zq1 = new double[100];
        double[] rootR = new double[100];
        double[] rootI = new double[100];
        int nin;
        int m;
        int n2;
        int em;
        double e;

        EllipticFilterType() {
        }

        void selectElliptic(int n) {
            DFilterFrame.this.auxLabels[n].setText("Passband Ripple");
            DFilterFrame.this.auxBars[n].setValue(60);
            DFilterFrame.this.auxLabels[n + 1].setText("Transition Band Width");
            DFilterFrame.this.auxBars[n + 1].setValue(100);
        }

        void setupElliptic(int n) {
            double d;
            double d2;
            int n2;
            double d3 = (double)DFilterFrame.this.auxBars[n].getValue() / 25.0;
            double d4 = Math.pow(10.0, d3 * 0.1) - 1.0;
            double d5 = (Math.exp((double)DFilterFrame.this.auxBars[n + 1].getValue() / 1000.0) - 1.0) * 5.0 + 1.0;
            this.Kprime = this.ellipticK(Math.sqrt(1.0 - 1.0 / (d5 * d5)));
            this.K = this.ellipticK(1.0 / d5);
            int n3 = (this.n & 1) == 1 ? 0 : 1;
            double[] dArray = new double[this.n / 2 + 1];
            this.zeros = new double[this.n + 1];
            for (n2 = 1; n2 <= this.n / 2; ++n2) {
                d2 = (double)(2 * n2 - n3) * this.K / (double)this.n;
                double d6 = this.calcSn(d2);
                double d7 = 1.0 / (d6 *= Math.PI * 2 / this.K);
                this.zeros[n2 - 1] = d7;
                dArray[n2] = d7;
            }
            this.zeros[this.n / 2] = 1.0E30;
            d2 = 0.15915494309189535;
            this.nin = this.n % 2;
            this.n2 = this.n / 2;
            double[] dArray2 = new double[this.n2 + 1];
            for (n2 = 1; n2 <= this.n2; ++n2) {
                d = dArray[this.n2 + 1 - n2];
                this.z1[n2] = Math.sqrt(1.0 - 1.0 / (d * d));
            }
            d = Math.pow(10.0, 0.1 * d3) - 1.0;
            this.e = Math.sqrt(d);
            double d8 = d2 * d2;
            this.m = this.nin + 2 * this.n2;
            this.em = 2 * (this.m / 2);
            double d9 = Math.PI * 2;
            this.calcfz();
            this.calcqz();
            if (this.m > this.em) {
                this.c1[2 * this.m] = 0.0;
            }
            for (n2 = 0; n2 <= 2 * this.m; n2 += 2) {
                this.a1[this.m - n2 / 2] = this.c1[n2] + this.d1[n2];
            }
            double d10 = this.factorFinder(this.m);
            int n4 = 0;
            while (n4 < this.em / 2) {
                int n5 = ++n4;
                this.p[n5] = this.p[n5] / 10.0;
                int n6 = n4;
                this.q1[n6] = this.q1[n6] / 100.0;
                double d11 = 1.0 + this.p[n4] + this.q1[n4];
                this.b1[n4] = (1.0 + this.p[n4] / 2.0) * d8 / d11;
                this.zf1[n4] = d2 / Math.pow(d11, 0.25);
                this.zq1[n4] = 1.0 / Math.sqrt(Math.abs(2.0 * (1.0 - this.b1[n4] / (this.zf1[n4] * this.zf1[n4]))));
                this.zw1[n4] = d9 * this.zf1[n4];
                this.rootR[n4] = -0.5 * this.zw1[n4] / this.zq1[n4];
                this.rootR[n4 + this.em / 2] = this.rootR[n4];
                this.rootI[n4] = 0.5 * Math.sqrt(Math.abs(this.zw1[n4] * this.zw1[n4] / (this.zq1[n4] * this.zq1[n4]) - 4.0 * this.zw1[n4] * this.zw1[n4]));
                this.rootI[n4 + this.em / 2] = -this.rootI[n4];
            }
            if (d10 != 0.0) {
                this.rootR[n4 + 1 + this.em / 2] = -Math.sqrt(d8 / (0.1 * d10 - 1.0)) * d9;
                this.rootI[n4 + 1 + this.em / 2] = 0.0;
            }
        }

        void calcfz() {
            int n = 1;
            if (this.nin == 1) {
                this.s1[n++] = 1.0;
            }
            while (n <= this.nin + this.n2) {
                double d = this.z1[n - this.nin];
                this.s1[n + this.n2] = d;
                this.s1[n] = d;
                ++n;
            }
            this.genProductPoly(this.nin + 2 * this.n2);
            for (n = 0; n <= this.em; n += 2) {
                this.a1[n] = this.e * this.b1[n];
            }
            for (n = 0; n <= 2 * this.em; n += 2) {
                this.calcfz2(n);
            }
        }

        void genProductPoly(int n) {
            this.b1[0] = this.s1[1];
            this.b1[1] = 1.0;
            for (int i = 2; i <= n; ++i) {
                int n2;
                this.a1[0] = this.s1[i] * this.b1[0];
                for (n2 = 1; n2 <= i - 1; ++n2) {
                    this.a1[n2] = this.b1[n2 - 1] + this.s1[i] * this.b1[n2];
                }
                for (n2 = 0; n2 != i; ++n2) {
                    this.b1[n2] = this.a1[n2];
                }
                this.b1[i] = 1.0;
            }
        }

        void calcfz2(int n) {
            int n2 = 0;
            int n3 = 0;
            if (n < this.em + 2) {
                n2 = 0;
                n3 = n;
            }
            if (n > this.em) {
                n2 = n - this.em;
                n3 = this.em;
            }
            this.c1[n] = 0.0;
            for (int i = n2; i <= n3; i += 2) {
                int n4 = n;
                this.c1[n4] = this.c1[n4] + this.a1[i] * (this.a1[n - i] * Math.pow(10.0, this.m - n / 2));
            }
        }

        void calcqz() {
            int n;
            for (n = 1; n <= this.nin; ++n) {
                this.s1[n] = -10.0;
            }
            while (n <= this.nin + this.n2) {
                this.s1[n] = -10.0 * this.z1[n - this.nin] * this.z1[n - this.nin];
                ++n;
            }
            while (n <= this.nin + 2 * this.n2) {
                this.s1[n] = this.s1[n - this.n2];
                ++n;
            }
            this.genProductPoly(this.m);
            int n2 = (this.nin & 1) == 1 ? -1 : 1;
            for (n = 0; n <= 2 * this.m; n += 2) {
                this.d1[n] = (double)n2 * this.b1[n / 2];
            }
        }

        double factorFinder(int n) {
            double d = 0.0;
            int n2 = 1;
            while (n2 <= n) {
                int n3 = n2++;
                this.a1[n3] = this.a1[n3] / this.a1[0];
            }
            this.c1[0] = 1.0;
            this.b1[0] = 1.0;
            this.a1[0] = 1.0;
            int n4 = 0;
            while (n > 2) {
                double d2;
                double d3;
                double d4 = 0.0;
                double d5 = 0.0;
                ++n4;
                do {
                    this.b1[1] = this.a1[1] - d4;
                    this.c1[1] = this.b1[1] - d4;
                    for (n2 = 2; n2 <= n; ++n2) {
                        this.b1[n2] = this.a1[n2] - d4 * this.b1[n2 - 1] - d5 * this.b1[n2 - 2];
                    }
                    for (n2 = 2; n2 < n; ++n2) {
                        this.c1[n2] = this.b1[n2] - d4 * this.c1[n2 - 1] - d5 * this.c1[n2 - 2];
                    }
                    int n5 = n - 2;
                    int n6 = n - 3;
                    int n7 = n - 1;
                    double d6 = this.c1[n5] * this.c1[n5] + this.c1[n6] * (this.b1[n7] - this.c1[n7]);
                    if (d6 == 0.0) {
                        d6 = 0.001;
                    }
                    d3 = (this.b1[n7] * this.c1[n5] - this.b1[n] * this.c1[n6]) / d6;
                    d4 += d3;
                    d2 = (this.b1[n] * this.c1[n5] - this.b1[n7] * (this.c1[n7] - this.b1[n7])) / d6;
                    d5 += d2;
                } while (!(Math.abs(d3 + d2) < 1.0E-6));
                this.p[n4] = d4;
                this.q1[n4] = d5;
                this.a1[1] = this.a1[1] - d4;
                n -= 2;
                for (n2 = 2; n2 <= n; ++n2) {
                    int n8 = n2;
                    this.a1[n8] = this.a1[n8] - (d4 * this.a1[n2 - 1] + d5 * this.a1[n2 - 2]);
                }
                if (n > 2) continue;
            }
            if (n == 2) {
                this.p[++n4] = this.a1[1];
                this.q1[n4] = this.a1[2];
            }
            if (n == 1) {
                d = -this.a1[1];
            }
            return d;
        }

        double calcSn(double d) {
            double d2 = 0.0;
            double d3 = Math.exp(-Math.PI * this.Kprime / this.K);
            double d4 = 1.5707963267948966 * d / this.K;
            int n = 0;
            while (true) {
                double d5 = Math.pow(d3, (double)n + 0.5);
                d2 += d5 * Math.sin((double)(2 * n + 1) * d4) / (1.0 - d5 * d5);
                if (d5 < 1.0E-7) break;
                ++n;
            }
            return d2;
        }

        double ellipticK(double d) {
            double d2;
            double[] dArray = new double[50];
            double[] dArray2 = new double[50];
            dArray[0] = Math.atan(d / Math.sqrt(1.0 - d * d));
            dArray2[0] = 1.5707963267948966;
            int n = 0;
            do {
                double d3 = 2.0 / (1.0 + Math.sin(dArray[n])) - 1.0;
                double d4 = Math.sin(dArray[n]) * Math.sin(dArray2[n]);
                dArray[n + 1] = Math.atan(Math.sqrt(1.0 - d3 * d3) / d3);
                dArray2[n + 1] = 0.5 * (dArray2[n] + Math.atan(d4 / Math.sqrt(1.0 - d4 * d4)));
            } while (!((d2 = 1.0 - dArray[n + 1] * 2.0 / Math.PI) < 1.0E-7) && ++n != 49);
            double d5 = 1.0;
            for (int i = 1; i <= n; ++i) {
                d5 *= 1.0 + Math.cos(dArray[i]);
            }
            double d6 = 0.7853981633974483 + dArray2[n] / 2.0;
            return Math.log(Math.tan(d6)) * d5;
        }

        void getSPole(int n, Complex complex, double d) {
            double d2 = Math.tan(d * 0.5);
            complex.set(this.rootR[n + 1] * d2, this.rootI[n + 1] * d2);
        }

        void getEllipticZero(int n, Complex complex, double d) {
            double d2 = Math.tan(d * 0.5);
            complex.set(0.0, this.zeros[n / 2] * d2);
            if ((n & 1) == 1) {
                complex.im = -complex.im;
            }
            this.bilinearXform(complex);
        }

        void getInfoElliptic(String[] stringArray) {
        }

        int getPoleCount() {
            return this.n;
        }

        int getZeroCount() {
            return this.n;
        }
    }

    class InvChebyBandStop
    extends InvChebyBandPass {
        InvChebyBandStop() {
        }

        void getPole(int n, Complex complex) {
            this.getBandStopPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getChebyZero(n / 2, complex, 1.5707963267948966);
            this.bandStopXform(n, complex);
        }
    }

    class InvChebyBandPass
    extends InvChebyFilterType {
        InvChebyBandPass() {
        }

        int select() {
            int n = this.selectBandPass();
            this.selectCheby(n++);
            return n;
        }

        void setup() {
            this.setupBandPass();
            this.setupCheby(3);
        }

        void getPole(int n, Complex complex) {
            this.getBandPassPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getChebyZero(n / 2, complex, 1.5707963267948966);
            this.bandPassXform(n, complex);
        }

        int getPoleCount() {
            return this.n * 2;
        }

        int getZeroCount() {
            return this.n * 2;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Inv Cheby (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoBandPass(stringArray, this instanceof InvChebyBandStop);
            this.getInfoCheby(stringArray);
        }
    }

    class ChebyBandStop
    extends ChebyBandPass {
        ChebyBandStop() {
        }

        void getPole(int n, Complex complex) {
            this.getBandStopPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getBandStopZero(n, complex);
        }
    }

    class ChebyBandPass
    extends ChebyFilterType {
        ChebyBandPass() {
        }

        int select() {
            int n = this.selectBandPass();
            this.selectCheby(n++);
            return n;
        }

        void setup() {
            this.setupBandPass();
            this.setupCheby(3);
        }

        void getPole(int n, Complex complex) {
            this.getBandPassPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getBandPassZero(n, complex);
        }

        int getPoleCount() {
            return this.n * 2;
        }

        int getZeroCount() {
            return this.n * 2;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Chebyshev (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoBandPass(stringArray, this instanceof ChebyBandStop);
            this.getInfoCheby(stringArray);
        }
    }

    class ButterBandStop
    extends ButterBandPass {
        ButterBandStop() {
        }

        void getPole(int n, Complex complex) {
            this.getBandStopPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getBandStopZero(n, complex);
        }
    }

    class ButterBandPass
    extends ButterFilterType {
        ButterBandPass() {
        }

        int select() {
            return this.selectBandPass();
        }

        void setup() {
            this.setupBandPass();
        }

        void getPole(int n, Complex complex) {
            this.getBandPassPole(n, complex);
        }

        void getZero(int n, Complex complex) {
            this.getBandPassZero(n, complex);
        }

        int getPoleCount() {
            return this.n * 2;
        }

        int getZeroCount() {
            return this.n * 2;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Butterworth (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoBandPass(stringArray, this instanceof ButterBandStop);
        }
    }

    class InvChebyHighPass
    extends InvChebyLowPass {
        InvChebyHighPass() {
        }

        void getPole(int n, Complex complex) {
            this.getSPole(n, complex, Math.PI - this.wc);
            this.bilinearXform(complex);
            complex.mult(-1.0);
        }

        void getZero(int n, Complex complex) {
            this.getChebyZero(n, complex, Math.PI - this.wc);
            complex.mult(-1.0);
        }
    }

    class InvChebyLowPass
    extends InvChebyFilterType {
        InvChebyLowPass() {
        }

        int select() {
            int n = this.selectLowPass();
            this.selectCheby(n++);
            return n;
        }

        void setup() {
            this.setupLowPass();
            this.setupCheby(2);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Inverse Chebyshev (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoLowPass(stringArray);
            this.getInfoCheby(stringArray);
        }

        void getZero(int n, Complex complex) {
            this.getChebyZero(n, complex, this.wc);
        }
    }

    class ChebyHighPass
    extends ChebyLowPass {
        ChebyHighPass() {
            this.sign = -1;
        }
    }

    class ChebyLowPass
    extends ChebyFilterType {
        ChebyLowPass() {
            this.sign = 1;
        }

        int select() {
            int n = this.selectLowPass();
            this.selectCheby(n++);
            return n;
        }

        void setup() {
            this.setupLowPass();
            this.setupCheby(2);
        }

        void getPole(int n, Complex complex) {
            super.getPole(n, complex);
            complex.mult(this.sign);
        }

        void getZero(int n, Complex complex) {
            complex.set(-this.sign);
        }

        int getPoleCount() {
            return this.n;
        }

        int getZeroCount() {
            return this.n;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Chebyshev (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoLowPass(stringArray);
            this.getInfoCheby(stringArray);
        }
    }

    abstract class InvChebyFilterType
    extends ChebyFilterType {
        double scale;

        InvChebyFilterType() {
        }

        void selectCheby(int n) {
            DFilterFrame.this.auxLabels[n].setText("Stopband Attenuation");
            DFilterFrame.this.auxBars[n].setValue(600);
        }

        void setupCheby(int n) {
            this.epsilon = Math.exp((double)(-DFilterFrame.this.auxBars[n].getValue()) / 120.0);
            this.scale = DFilterFrame.this.cosh(DFilterFrame.this.acosh(1.0 / this.epsilon) / (double)this.n);
        }

        void getSPole(int n, Complex complex, double d) {
            d = Math.PI - d;
            super.getSPole(n, complex, d);
            complex.recip();
            complex.mult(this.scale);
        }

        void getChebyZero(int n, Complex complex, double d) {
            double d2 = 1.0 / Math.cos((double)(2 * n + 1) * Math.PI / (double)(2 * this.n)) * this.scale;
            double d3 = Math.sin(0.7853981633974483 - d / 2.0) / Math.sin(0.7853981633974483 + d / 2.0);
            complex.set(1.0 + d3, d2 * (1.0 - d3));
            Complex complex2 = new Complex(1.0 + d3, d2 * (d3 - 1.0));
            complex.div(complex2);
        }

        void getInfoCheby(String[] stringArray) {
            stringArray[2] = "Stopband attenuation: " + DFilterFrame.this.showFormat.format(-10.0 * Math.log(1.0 + 1.0 / (this.epsilon * this.epsilon)) / 2.302585092994046) + " dB";
        }

        int getPoleCount() {
            return this.n;
        }

        int getZeroCount() {
            return this.n;
        }
    }

    abstract class ChebyFilterType
    extends PoleFilterType {
        double epsilon;
        int sign;

        ChebyFilterType() {
        }

        void selectCheby(int n) {
            DFilterFrame.this.auxLabels[n].setText("Passband Ripple");
            DFilterFrame.this.auxBars[n].setValue(60);
        }

        void setupCheby(int n) {
            int n2 = DFilterFrame.this.auxBars[n].getValue();
            double d = 0.0;
            d = n2 < 300 ? (double)(5 * n2) / 300.0 : 5.0 + (double)(45 * (n2 - 300)) / 700.0;
            double d2 = Math.exp(-d * 0.1 * 2.302585092994046);
            this.epsilon = Math.sqrt(1.0 / d2 - 1.0);
        }

        void getSPole(int n, Complex complex, double d) {
            Complex complex2 = new Complex();
            double d2 = 1.0 / this.epsilon + Math.sqrt(1.0 + 1.0 / (this.epsilon * this.epsilon));
            double d3 = 0.5 * (Math.pow(d2, 1.0 / (double)this.n) - Math.pow(d2, -1.0 / (double)this.n));
            double d4 = 0.5 * (Math.pow(d2, 1.0 / (double)this.n) + Math.pow(d2, -1.0 / (double)this.n));
            double d5 = 1.5707963267948966 + (double)(2 * n + 1) * Math.PI / (double)(2 * this.n);
            if (this.sign == -1) {
                d = Math.PI - d;
            }
            complex.setMagPhase(Math.tan(d * 0.5), d5);
            complex.re *= d3;
            complex.im *= d4;
            complex.setMagPhase();
        }

        void getInfoCheby(String[] stringArray) {
            stringArray[2] = "Ripple: " + DFilterFrame.this.showFormat.format(-10.0 * Math.log(1.0 / (1.0 + this.epsilon * this.epsilon)) / 2.302585092994046) + " dB";
        }
    }

    class ButterHighPass
    extends ButterLowPass {
        ButterHighPass() {
            this.sign = -1;
        }
    }

    class ButterLowPass
    extends ButterFilterType {
        int sign = 1;

        ButterLowPass() {
        }

        int select() {
            return this.selectLowPass();
        }

        void setup() {
            this.setupLowPass();
        }

        void getZero(int n, Complex complex) {
            complex.set(-this.sign);
        }

        int getPoleCount() {
            return this.n;
        }

        int getZeroCount() {
            return this.n;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "Butterworth (IIR), " + this.getPoleCount() + "-pole";
            this.getInfoLowPass(stringArray);
        }
    }

    abstract class ButterFilterType
    extends PoleFilterType {
        ButterFilterType() {
        }

        void getSPole(int n, Complex complex, double d) {
            double d2 = 1.5707963267948966 + (double)(2 * n + 1) * Math.PI / (double)(2 * this.n);
            complex.setMagPhase(Math.tan(d * 0.5), d2);
        }
    }

    abstract class PoleFilterType
    extends IIRFilterType {
        int n;
        double wc;
        double wc2;

        PoleFilterType() {
        }

        abstract void getSPole(int var1, Complex var2, double var3);

        void getPole(int n, Complex complex) {
            this.getSPole(n, complex, this.wc);
            this.bilinearXform(complex);
        }

        void bilinearXform(Complex complex) {
            Complex complex2 = new Complex(complex);
            complex.add(1.0);
            complex2.mult(-1.0);
            complex2.add(1.0);
            complex.div(complex2);
        }

        int selectLowPass() {
            DFilterFrame.this.auxLabels[0].setText("Cutoff Frequency");
            DFilterFrame.this.auxLabels[1].setText("Number of Poles");
            DFilterFrame.this.auxBars[1].setMaximum(40);
            DFilterFrame.this.auxBars[0].setValue(100);
            DFilterFrame.this.auxBars[1].setValue(4);
            return 2;
        }

        int selectBandPass() {
            DFilterFrame.this.auxLabels[0].setText("Center Frequency");
            DFilterFrame.this.auxLabels[1].setText("Passband Width");
            DFilterFrame.this.auxLabels[2].setText("Number of Poles");
            DFilterFrame.this.auxBars[2].setMaximum(20);
            DFilterFrame.this.auxBars[0].setValue(500);
            DFilterFrame.this.auxBars[1].setValue(200);
            DFilterFrame.this.auxBars[2].setValue(6);
            return 3;
        }

        void getBandPassPole(int n, Complex complex) {
            this.getSPole(n / 2, complex, 1.5707963267948966);
            this.bilinearXform(complex);
            this.bandPassXform(n, complex);
        }

        void bandPassXform(int n, Complex complex) {
            double d = Math.cos((this.wc + this.wc2) * 0.5) / Math.cos((this.wc - this.wc2) * 0.5);
            double d2 = 1.0 / Math.tan(0.5 * (this.wc - this.wc2));
            Complex complex2 = new Complex();
            complex2.addMult(4.0 * (d2 * d2 * (d * d - 1.0) + 1.0), complex);
            complex2.add(8.0 * (d2 * d2 * (d * d - 1.0) - 1.0));
            complex2.mult(complex);
            complex2.add(4.0 * (d2 * d2 * (d * d - 1.0) + 1.0));
            complex2.sqrt();
            if ((n & 1) == 0) {
                complex2.mult(-1.0);
            }
            complex2.addMult(2.0 * d * d2, complex);
            complex2.add(2.0 * d * d2);
            Complex complex3 = new Complex();
            complex3.addMult(2.0 * (d2 - 1.0), complex);
            complex3.add(2.0 * (1.0 + d2));
            complex2.div(complex3);
            complex.set(complex2);
        }

        void getBandStopPole(int n, Complex complex) {
            this.getSPole(n / 2, complex, 1.5707963267948966);
            this.bilinearXform(complex);
            this.bandStopXform(n, complex);
        }

        void getBandStopZero(int n, Complex complex) {
            complex.set(-1.0, 0.0);
            this.bandStopXform(n, complex);
        }

        void bandStopXform(int n, Complex complex) {
            double d = Math.cos((this.wc + this.wc2) * 0.5) / Math.cos((this.wc - this.wc2) * 0.5);
            double d2 = Math.tan(0.5 * (this.wc - this.wc2));
            Complex complex2 = new Complex();
            complex2.addMult(4.0 * (d2 * d2 + d * d - 1.0), complex);
            complex2.add(8.0 * (d2 * d2 - d * d + 1.0));
            complex2.mult(complex);
            complex2.add(4.0 * (d * d + d2 * d2 - 1.0));
            complex2.sqrt();
            complex2.mult((n & 1) == 0 ? 0.5 : -0.5);
            complex2.add(d);
            complex2.addMult(-d, complex);
            Complex complex3 = new Complex(d2 + 1.0, 0.0);
            complex3.addMult(d2 - 1.0, complex);
            complex2.div(complex3);
            complex.set(complex2);
        }

        void getBandPassZero(int n, Complex complex) {
            if (n >= this.n) {
                complex.set(1.0);
            } else {
                complex.set(-1.0);
            }
        }

        void setupLowPass() {
            this.wc = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            this.n = DFilterFrame.this.auxBars[1].getValue();
        }

        void setupBandPass() {
            double d = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            double d2 = (double)DFilterFrame.this.auxBars[1].getValue() * Math.PI / 1000.0;
            this.wc = d + d2 / 2.0;
            this.wc2 = d - d2 / 2.0;
            if (this.wc2 < 0.0) {
                this.wc2 = 1.0E-8;
            }
            if (this.wc >= Math.PI) {
                this.wc = 3.141592643589793;
            }
            this.n = DFilterFrame.this.auxBars[2].getValue();
        }

        void getInfoLowPass(String[] stringArray) {
            stringArray[1] = "Cutoff freq: " + DFilterFrame.this.getOmegaText(this.wc);
        }

        void getInfoBandPass(String[] stringArray, boolean bl) {
            stringArray[1] = (bl ? "Stopband: " : "Passband: ") + DFilterFrame.this.getOmegaText(this.wc2) + " - " + DFilterFrame.this.getOmegaText(this.wc);
        }
    }

    abstract class IIRFilterType
    extends FilterType {
        double[] response;

        IIRFilterType() {
        }

        void getResponse(double d, Complex complex) {
            if (this.response == null) {
                complex.set(0.0);
                return;
            }
            int n = (int)((double)this.response.length * d / Math.PI);
            if ((n &= 0xFFFFFFFE) < 0) {
                n = 0;
            }
            if (n >= this.response.length) {
                n = this.response.length - 1;
            }
            complex.set(this.response[n], this.response[n + 1]);
        }

        void setResponse(DirectFilter directFilter) {
            int n;
            this.response = new double[8192];
            Complex complex = new Complex();
            Complex complex2 = new Complex();
            Complex complex3 = new Complex();
            double d = 0.0;
            directFilter.bList[0] = 1.0;
            if (directFilter.aList.length != directFilter.bList.length) {
                System.out.println("length mismatch " + directFilter.aList.length + " " + directFilter.bList.length);
            }
            for (n = 0; n != this.response.length; n += 2) {
                complex2.set(0.0);
                complex3.set(0.0);
                boolean bl = false;
                for (int i = 0; i != directFilter.aList.length; ++i) {
                    complex.setMagPhase(1.0, -Math.PI * (double)n * (double)directFilter.nList[i] / (double)this.response.length);
                    complex2.addMult(directFilter.aList[i], complex);
                    complex3.addMult(directFilter.bList[i], complex);
                }
                complex2.div(complex3);
                if (complex2.mag > d) {
                    d = complex2.mag;
                }
                this.response[n] = complex2.re;
                this.response[n + 1] = complex2.im;
            }
            n = 0;
            while (n != this.response.length) {
                int n2 = n++;
                this.response[n2] = this.response[n2] / d;
            }
            n = 0;
            while (n != directFilter.aList.length) {
                int n3 = n++;
                directFilter.aList[n3] = directFilter.aList[n3] / d;
            }
        }

        void setResponse(CascadeFilter cascadeFilter) {
            int n;
            this.response = new double[4096];
            Complex complex = new Complex();
            Complex complex2 = new Complex();
            Complex complex3 = new Complex();
            Complex complex4 = new Complex();
            Complex complex5 = new Complex();
            Complex complex6 = new Complex();
            double d = 0.0;
            for (n = 0; n != this.response.length; n += 2) {
                complex3.set(1.0);
                complex6.set(1.0);
                boolean bl = false;
                complex.setMagPhase(1.0, -Math.PI * (double)n / (double)this.response.length);
                complex2.setMagPhase(1.0, -Math.PI * (double)n * 2.0 / (double)this.response.length);
                for (int i = 0; i != cascadeFilter.size; ++i) {
                    complex4.set(cascadeFilter.b0[i]);
                    complex5.set(1.0);
                    complex4.addMult(cascadeFilter.b1[i], complex);
                    complex5.addMult(-cascadeFilter.a1[i], complex);
                    complex4.addMult(cascadeFilter.b2[i], complex2);
                    complex5.addMult(-cascadeFilter.a2[i], complex2);
                    complex3.mult(complex4);
                    complex6.mult(complex5);
                }
                complex3.div(complex6);
                if (complex3.mag > d) {
                    d = complex3.mag;
                }
                this.response[n] = complex3.re;
                this.response[n + 1] = complex3.im;
            }
            n = 0;
            while (n != this.response.length) {
                int n2 = n++;
                this.response[n2] = this.response[n2] / d;
            }
            cascadeFilter.b0[0] = cascadeFilter.b0[0] / d;
            cascadeFilter.b1[0] = cascadeFilter.b1[0] / d;
            cascadeFilter.b2[0] = cascadeFilter.b2[0] / d;
        }

        Filter genFilter() {
            double d;
            double d2;
            int n;
            int n2 = this.getPoleCount();
            CascadeFilter cascadeFilter = new CascadeFilter((n2 + 1) / 2);
            Complex complex = new Complex();
            int n3 = 0;
            for (n = 0; n != n2; ++n) {
                this.getPole(n, complex);
                if (Math.abs(complex.im) < 1.0E-6) {
                    complex.im = 0.0;
                }
                if (complex.im < 0.0) continue;
                if (complex.im == 0.0) {
                    d2 = -complex.re;
                    cascadeFilter.setAStage(-d2, 0.0);
                    continue;
                }
                d2 = -2.0 * complex.re;
                d = complex.magSquared();
                cascadeFilter.setAStage(-d2, -d);
            }
            n2 = this.getZeroCount();
            n3 = 0;
            for (n = 0; n != n2; ++n) {
                this.getZero(n, complex);
                if (Math.abs(complex.im) < 1.0E-6) {
                    complex.im = 0.0;
                }
                if (complex.im < 0.0) continue;
                if (complex.im == 0.0) {
                    cascadeFilter.setBStage(-complex.re, 1.0, 0.0);
                    continue;
                }
                d2 = -2.0 * complex.re;
                d = complex.magSquared();
                cascadeFilter.setBStage(d, d2, 1.0);
            }
            this.setResponse(cascadeFilter);
            return cascadeFilter;
        }
    }

    abstract class FilterType {
        FilterType() {
        }

        int select() {
            return 0;
        }

        void setup() {
        }

        abstract void getResponse(double var1, Complex var3);

        int getPoleCount() {
            return 0;
        }

        int getZeroCount() {
            return 0;
        }

        void getPole(int n, Complex complex) {
            complex.set(0.0);
        }

        void getZero(int n, Complex complex) {
            complex.set(0.0);
        }

        abstract Filter genFilter();

        void getInfo(String[] stringArray) {
        }

        boolean needsWindow() {
            return false;
        }

        void setCutoff(double d) {
            DFilterFrame.this.auxBars[0].setValue((int)(2000.0 * d));
        }
    }

    class CascadeFilter
    extends Filter {
        double[] a1;
        double[] a2;
        double[] b0;
        double[] b1;
        double[] b2;
        int size;
        Complex cm2;
        Complex cm1;
        Complex top;
        Complex bottom;

        CascadeFilter(int n) {
            this.size = n;
            this.a1 = new double[n];
            this.a2 = new double[n];
            this.b0 = new double[n];
            this.b1 = new double[n];
            this.b2 = new double[n];
            for (int i = 0; i != n; ++i) {
                this.b0[i] = 1.0;
            }
        }

        double[] createState() {
            return new double[this.size * 3];
        }

        void setAStage(double d, double d2) {
            for (int i = 0; i != this.size; ++i) {
                if (this.a1[i] == 0.0 && this.a2[i] == 0.0) {
                    this.a1[i] = d;
                    this.a2[i] = d2;
                    return;
                }
                if (this.a2[i] != 0.0 || d2 != 0.0) continue;
                this.a2[i] = -this.a1[i] * d;
                int n = i;
                this.a1[n] = this.a1[n] + d;
                return;
            }
            System.out.println("setAStage failed");
        }

        void setBStage(double d, double d2, double d3) {
            for (int i = 0; i != this.size; ++i) {
                if (this.b1[i] == 0.0 && this.b2[i] == 0.0) {
                    this.b0[i] = d;
                    this.b1[i] = d2;
                    this.b2[i] = d3;
                    return;
                }
                if (this.b2[i] != 0.0 || d3 != 0.0) continue;
                this.b2[i] = this.b1[i] * d2;
                this.b1[i] = this.b1[i] * d + this.b0[i] * d2;
                int n = i;
                this.b0[n] = this.b0[n] * d;
                return;
            }
            System.out.println("setBStage failed");
        }

        void run(double[] dArray, double[] dArray2, int n, int n2, int n3, double[] dArray3) {
            double d = 0.0;
            for (int i = 0; i != n3; ++i) {
                int n4 = n + i;
                int n5 = n4 & n2;
                d = dArray[n5];
                for (int j = 0; j != this.size; ++j) {
                    int n6 = j * 3;
                    double d2 = dArray3[n6 + 1];
                    dArray3[n6 + 2] = d2;
                    double d3 = d2;
                    double d4 = dArray3[n6];
                    dArray3[n6 + 1] = d4;
                    double d5 = d4;
                    double d6 = dArray3[n6] = d + this.a1[j] * d5 + this.a2[j] * d3;
                    d = this.b0[j] * d6 + this.b1[j] * d5 + this.b2[j] * d3;
                }
                dArray2[n5] = d;
            }
        }

        void evalTransfer(Complex complex) {
            if (this.cm1 == null) {
                this.cm1 = new Complex();
                this.cm2 = new Complex();
                this.top = new Complex();
                this.bottom = new Complex();
            }
            this.cm1.set(complex);
            this.cm1.recip();
            this.cm2.set(this.cm1);
            this.cm2.square();
            complex.set(1.0);
            for (int i = 0; i != this.size; ++i) {
                this.top.set(this.b0[i]);
                this.top.addMult(this.b1[i], this.cm1);
                this.top.addMult(this.b2[i], this.cm2);
                this.bottom.set(1.0);
                this.bottom.addMult(-this.a1[i], this.cm1);
                this.bottom.addMult(-this.a2[i], this.cm2);
                complex.mult(this.top);
                complex.div(this.bottom);
            }
        }

        int getImpulseOffset() {
            return 0;
        }

        int getStepOffset() {
            return 0;
        }

        int getLength() {
            return 1;
        }
    }

    class DirectFilter
    extends Filter {
        double[] aList = new double[]{1.0};
        double[] bList = null;
        int[] nList = new int[]{0};
        Complex czn;
        Complex top;
        Complex bottom;

        DirectFilter() {
        }

        int getLength() {
            return this.aList.length;
        }

        boolean useConvolve() {
            return this.bList == null && this.aList.length > 25;
        }

        void dump() {
            System.out.print("a ");
            this.dump(this.aList);
            if (this.bList != null) {
                System.out.print("b ");
                this.dump(this.bList);
            }
        }

        void dump(double[] dArray) {
            for (int i = 0; i != dArray.length; ++i) {
                System.out.print(dArray[i] + " ");
            }
            System.out.println("");
        }

        void evalTransfer(Complex complex) {
            if (this.czn == null) {
                this.czn = new Complex();
                this.top = new Complex();
                this.bottom = new Complex();
            }
            this.czn.set(1.0);
            this.top.set(0.0);
            this.bottom.set(0.0);
            int n = 0;
            for (int i = 0; i != this.aList.length; ++i) {
                int n2 = this.nList[i];
                while (n < n2) {
                    if (n + 3 < n2) {
                        this.czn.set(complex);
                        this.czn.pow(-n2);
                        n = n2;
                        break;
                    }
                    this.czn.div(complex);
                    ++n;
                }
                this.top.addMult(this.aList[i], this.czn);
                if (this.bList == null) continue;
                this.bottom.addMult(this.bList[i], this.czn);
            }
            if (this.bList != null) {
                this.top.div(this.bottom);
            }
            complex.set(this.top);
        }

        void run(double[] dArray, double[] dArray2, int n, int n2, int n3, double[] dArray3) {
            int n4 = n;
            double d = 0.0;
            for (int i = 0; i != n3; ++i) {
                int n5;
                int n6;
                n4 = n + i;
                int n7 = n4 & n2;
                d = dArray[n7] * this.aList[0];
                if (this.bList == null) {
                    for (n6 = 1; n6 < this.aList.length; ++n6) {
                        n5 = n4 - this.nList[n6] & n2;
                        d += dArray[n5] * this.aList[n6];
                    }
                } else {
                    for (n6 = 1; n6 < this.aList.length; ++n6) {
                        n5 = n4 - this.nList[n6] & n2;
                        d += dArray[n5] * this.aList[n6] - dArray2[n5] * this.bList[n6];
                    }
                }
                dArray2[n7] = d;
            }
        }

        boolean isSimpleAList() {
            if (this.bList != null) {
                return false;
            }
            return this.nList[this.nList.length - 1] == this.nList.length - 1;
        }

        int getImpulseOffset() {
            if (this.isSimpleAList()) {
                return 0;
            }
            return this.getStepOffset();
        }

        int getStepOffset() {
            int n = 0;
            for (int i = 0; i != this.aList.length; ++i) {
                if (this.nList[i] <= n) continue;
                n = this.nList[i];
            }
            return n;
        }

        double[] getImpulseResponse(int n) {
            if (this.isSimpleAList()) {
                return this.aList;
            }
            return super.getImpulseResponse(n);
        }

        int getImpulseLen(int n, double[] dArray) {
            if (this.isSimpleAList()) {
                return this.aList.length;
            }
            return DFilterFrame.this.countPoints(dArray, n);
        }
    }

    abstract class Filter {
        Filter() {
        }

        abstract void run(double[] var1, double[] var2, int var3, int var4, int var5, double[] var6);

        abstract void evalTransfer(Complex var1);

        abstract int getImpulseOffset();

        abstract int getStepOffset();

        abstract int getLength();

        boolean useConvolve() {
            return false;
        }

        double[] getImpulseResponse(int n) {
            int n2 = 1000;
            double[] dArray = new double[n + n2];
            double[] dArray2 = new double[n + n2];
            dArray[n] = 1.0;
            double[] dArray3 = this.createState();
            this.run(dArray, dArray2, n, -1, n2, dArray3);
            return dArray2;
        }

        double[] getStepResponse(int n) {
            int n2 = 1000;
            double[] dArray = new double[n + n2];
            double[] dArray2 = new double[n + n2];
            for (int i = n; i != dArray.length; ++i) {
                dArray[i] = 1.0;
            }
            double[] dArray3 = this.createState();
            this.run(dArray, dArray2, n, -1, n2, dArray3);
            return dArray2;
        }

        int getImpulseLen(int n, double[] dArray) {
            return DFilterFrame.this.countPoints(dArray, n);
        }

        int getStepLen(int n, double[] dArray) {
            return DFilterFrame.this.countPoints(dArray, n);
        }

        double[] createState() {
            return null;
        }
    }

    class Complex {
        public double re;
        public double im;
        public double mag;
        public double phase;

        Complex() {
            this.phase = 0.0;
            this.mag = 0.0;
            this.im = 0.0;
            this.re = 0.0;
        }

        Complex(double d, double d2) {
            this.set(d, d2);
        }

        Complex(Complex complex) {
            this.set(complex.re, complex.im);
        }

        double magSquared() {
            return this.mag * this.mag;
        }

        void set(double d, double d2) {
            this.re = d;
            this.im = d2;
            this.setMagPhase();
        }

        void set(double d) {
            this.re = d;
            this.im = 0.0;
            this.setMagPhase();
        }

        void set(Complex complex) {
            this.re = complex.re;
            this.im = complex.im;
            this.mag = complex.mag;
            this.phase = complex.phase;
        }

        void add(double d) {
            this.re += d;
            this.setMagPhase();
        }

        void add(double d, double d2) {
            this.re += d;
            this.im += d2;
            this.setMagPhase();
        }

        void add(Complex complex) {
            this.re += complex.re;
            this.im += complex.im;
            this.setMagPhase();
        }

        void addMult(double d, Complex complex) {
            this.re += complex.re * d;
            this.im += complex.im * d;
            this.setMagPhase();
        }

        void square() {
            this.set(this.re * this.re - this.im * this.im, 2.0 * this.re * this.im);
        }

        void sqrt() {
            this.setMagPhase(Math.sqrt(this.mag), this.phase * 0.5);
        }

        void mult(double d, double d2) {
            this.set(this.re * d - this.im * d2, this.re * d2 + this.im * d);
        }

        void mult(double d) {
            this.re *= d;
            this.im *= d;
            this.mag *= d;
        }

        void mult(Complex complex) {
            this.mult(complex.re, complex.im);
        }

        void setMagPhase() {
            this.mag = Math.sqrt(this.re * this.re + this.im * this.im);
            this.phase = Math.atan2(this.im, this.re);
        }

        void setMagPhase(double d, double d2) {
            this.mag = d;
            this.phase = d2;
            this.re = d * Math.cos(d2);
            this.im = d * Math.sin(d2);
        }

        void recip() {
            double d = this.re * this.re + this.im * this.im;
            this.set(this.re / d, -this.im / d);
        }

        void div(Complex complex) {
            double d = complex.re * complex.re + complex.im * complex.im;
            this.mult(complex.re / d, -complex.im / d);
        }

        void rotate(double d) {
            this.setMagPhase(this.mag, (this.phase + d) % (Math.PI * 2));
        }

        void conjugate() {
            this.im = -this.im;
            this.phase = -this.phase;
        }

        void pow(double d) {
            double d2 = Math.atan2(this.im, this.re);
            this.phase *= d;
            double d3 = Math.pow(this.re * this.re + this.im * this.im, d * 0.5);
            this.setMagPhase(d3, this.phase);
        }
    }

    class PlayThread
    extends Thread {
        SourceDataLine line;
        Waveform wform;
        boolean shutdownRequested = false;
        boolean stereo;
        Filter filt;
        Filter newFilter;
        double[] fbufLi;
        double[] fbufRi;
        double[] fbufLo;
        double[] fbufRo;
        double[] stateL;
        double[] stateR;
        int fbufmask;
        int fbufsize;
        int spectrumOffset;
        int spectrumLen;
        int inbp;
        int outbp;
        int spectCt;
        double[] impulseBuf;
        double[] convolveBuf;
        int convBufPtr;
        FFT convFFT;
        byte[] ob;

        PlayThread() {
        }

        void requestShutdown() {
            this.shutdownRequested = true;
        }

        void setFilter(Filter filter) {
            this.newFilter = filter;
        }

        void openLine() {
            try {
                this.stereo = this.wform.getChannels() == 2;
                AudioFormat audioFormat = new AudioFormat(DFilterFrame.this.sampleRate, 16, 2, true, false);
                DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = DFilterFrame.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new LineUnavailableException("sorry, the sound format cannot be played");
                }
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(audioFormat, DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 4));
                this.line.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            DFilterFrame.this.playThread = null;
        }

        void doRun() {
            DFilterFrame.this.rateChooser.enable();
            this.wform = DFilterFrame.this.getWaveformObject();
            DFilterFrame.this.mp3Error = null;
            DFilterFrame.this.unstable = false;
            if (!this.wform.start()) {
                DFilterFrame.this.cv.repaint();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.fbufsize = 32768;
            this.fbufmask = this.fbufsize - 1;
            this.fbufLi = new double[this.fbufsize];
            this.fbufRi = new double[this.fbufsize];
            this.fbufLo = new double[this.fbufsize];
            this.fbufRo = new double[this.fbufsize];
            this.openLine();
            this.spectCt = 0;
            this.outbp = 0;
            this.inbp = 0;
            int n = this.stereo ? 2 : 1;
            DFilterFrame.this.outputGain = 1.0;
            this.newFilter = this.filt = DFilterFrame.this.curFilter;
            this.spectrumLen = DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 12);
            int n2 = 0;
            boolean bl = true;
            boolean bl2 = false;
            this.ob = new byte[16384];
            int n3 = 0;
            while (!this.shutdownRequested && DFilterFrame.this.soundCheck.getState() && DFilterFrame.this.applet.ogf != null) {
                int n4;
                int n5;
                if (this.newFilter != null) {
                    n2 = 0;
                    bl = true;
                    if (this.wform instanceof SweepWaveform || this.wform instanceof SineWaveform) {
                        bl = false;
                    }
                    DFilterFrame.this.outputGain = 1.0;
                    if (this.filt == null || this.filt.getLength() != this.newFilter.getLength()) {
                        this.spectCt = 0;
                        this.outbp = 0;
                        this.inbp = 0;
                        this.convBufPtr = 0;
                    }
                    this.filt = this.newFilter;
                    this.newFilter = null;
                    this.impulseBuf = null;
                    bl2 = this.filt.useConvolve();
                    this.stateL = this.filt.createState();
                    this.stateR = this.filt.createState();
                }
                if ((n5 = this.wform.getData()) == 0) break;
                short[] sArray = this.wform.buffer;
                int n6 = this.inbp;
                for (n4 = 0; n4 < n5; n4 += n) {
                    this.fbufLi[n6] = sArray[n4];
                    n6 = n6 + 1 & this.fbufmask;
                }
                n6 = this.inbp;
                if (this.stereo) {
                    for (n4 = 0; n4 < n5; n4 += 2) {
                        this.fbufRi[n6] = sArray[n4 + 1];
                        n6 = n6 + 1 & this.fbufmask;
                    }
                } else {
                    for (n4 = 0; n4 < n5; ++n4) {
                        this.fbufRi[n6] = this.fbufLi[n6];
                        n6 = n6 + 1 & this.fbufmask;
                    }
                }
                if (DFilterFrame.this.shiftSpectrumCheck.getState()) {
                    double d = (double)DFilterFrame.this.shiftFreqBar.getValue() * Math.PI / 1000.0;
                    if (d > Math.PI) {
                        d = Math.PI;
                    }
                    n6 = this.inbp;
                    for (n4 = 0; n4 < n5; n4 += n) {
                        double d2 = Math.cos(d * (double)n3++);
                        int n7 = n6;
                        this.fbufLi[n7] = this.fbufLi[n7] * d2;
                        int n8 = n6;
                        this.fbufRi[n8] = this.fbufRi[n8] * d2;
                        n6 = n6 + 1 & this.fbufmask;
                    }
                }
                int n9 = n5 / n;
                if (bl2) {
                    this.doConvolveFilter(n9, bl);
                } else {
                    this.doFilter(n9);
                    if (DFilterFrame.this.unstable) break;
                    int n10 = n9 * 4;
                    this.doOutput(n10, bl);
                }
                if (DFilterFrame.this.unstable) break;
                if (this.spectCt >= this.spectrumLen) {
                    this.spectrumOffset = this.outbp - this.spectrumLen & this.fbufmask;
                    this.spectCt -= this.spectrumLen;
                    DFilterFrame.this.cv.repaint();
                }
                if (!bl || (n2 += n9) < DFilterFrame.this.sampleRate) continue;
                n2 = 0;
                bl = false;
            }
            if (this.shutdownRequested || DFilterFrame.this.unstable || !DFilterFrame.this.soundCheck.getState()) {
                this.line.flush();
            } else {
                this.line.drain();
            }
            DFilterFrame.this.cv.repaint();
        }

        void doFilter(int n) {
            this.filt.run(this.fbufLi, this.fbufLo, this.inbp, this.fbufmask, n, this.stateL);
            this.filt.run(this.fbufRi, this.fbufRo, this.inbp, this.fbufmask, n, this.stateR);
            this.inbp = this.inbp + n & this.fbufmask;
            double d = this.fbufLo[this.inbp - 1 & this.fbufmask];
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                DFilterFrame.this.unstable = true;
            }
        }

        void doConvolveFilter(int n, boolean bl) {
            int n2;
            int n3 = this.inbp;
            double[] dArray = ((DirectFilter)this.filt).aList;
            int n4 = DFilterFrame.this.getPower2(512 + dArray.length * 2);
            if (this.convolveBuf == null || this.convolveBuf.length != n4) {
                this.convolveBuf = new double[n4];
            }
            if (this.impulseBuf == null) {
                this.impulseBuf = new double[n4];
                for (n2 = 0; n2 != dArray.length; ++n2) {
                    this.impulseBuf[n2 * 2] = dArray[n2];
                }
                this.convFFT = new FFT(this.convolveBuf.length / 2);
                this.convFFT.transform(this.impulseBuf, false);
            }
            int n5 = this.convBufPtr;
            int n6 = this.convolveBuf.length + 2 - 2 * dArray.length;
            n2 = 0;
            while (n2 != n) {
                int n7 = n3 & this.fbufmask;
                this.convolveBuf[n5] = this.fbufLi[n7];
                this.convolveBuf[n5 + 1] = this.fbufRi[n7];
                if ((n5 += 2) == n6) {
                    int n8;
                    int n9;
                    this.convFFT.transform(this.convolveBuf, false);
                    double d = 2.0 / (double)n4;
                    for (n9 = 0; n9 != n4; n9 += 2) {
                        double d2 = this.convolveBuf[n9] * this.impulseBuf[n9] - this.convolveBuf[n9 + 1] * this.impulseBuf[n9 + 1];
                        double d3 = this.convolveBuf[n9] * this.impulseBuf[n9 + 1] + this.convolveBuf[n9 + 1] * this.impulseBuf[n9];
                        this.convolveBuf[n9] = d2 * d;
                        this.convolveBuf[n9 + 1] = d3 * d;
                    }
                    this.convFFT.transform(this.convolveBuf, true);
                    int n10 = this.outbp;
                    int n11 = n4 - n6;
                    n9 = 0;
                    while (n9 != n11) {
                        int n12 = n8 = n10 & this.fbufmask;
                        this.fbufLo[n12] = this.fbufLo[n12] + this.convolveBuf[n9];
                        int n13 = n8;
                        this.fbufRo[n13] = this.fbufRo[n13] + this.convolveBuf[n9 + 1];
                        n9 += 2;
                        ++n10;
                    }
                    while (n9 != n4) {
                        n8 = n10 & this.fbufmask;
                        this.fbufLo[n8] = this.convolveBuf[n9];
                        this.fbufRo[n8] = this.convolveBuf[n9 + 1];
                        n9 += 2;
                        ++n10;
                    }
                    n5 = 0;
                    this.doOutput(n6 * 2, bl);
                    for (n9 = 0; n9 != n4; ++n9) {
                        this.convolveBuf[n9] = 0.0;
                    }
                }
                ++n2;
                ++n3;
            }
            this.inbp = n3 & this.fbufmask;
            this.convBufPtr = n5;
        }

        void doOutput(int n, boolean bl) {
            int n2;
            int n3;
            if (this.ob.length < n) {
                this.ob = new byte[n];
            }
            while (true) {
                int n4;
                int n5;
                n3 = 0;
                n2 = this.outbp;
                for (n5 = 0; n5 < n; n5 += 4) {
                    n4 = (int)(this.fbufLo[n2] * DFilterFrame.this.outputGain);
                    if (n4 > n3) {
                        n3 = n4;
                    }
                    if (n4 < -n3) {
                        n3 = -n4;
                    }
                    this.ob[n5 + 1] = (byte)(n4 >> 8);
                    this.ob[n5] = (byte)n4;
                    n2 = n2 + 1 & this.fbufmask;
                }
                n2 = this.outbp;
                for (n5 = 2; n5 < n; n5 += 4) {
                    n4 = (int)(this.fbufRo[n2] * DFilterFrame.this.outputGain);
                    if (n4 > n3) {
                        n3 = n4;
                    }
                    if (n4 < -n3) {
                        n3 = -n4;
                    }
                    this.ob[n5 + 1] = (byte)(n4 >> 8);
                    this.ob[n5] = (byte)n4;
                    n2 = n2 + 1 & this.fbufmask;
                }
                if (n3 > Short.MAX_VALUE) {
                    DFilterFrame.this.outputGain *= 30000.0 / (double)n3;
                    if (!(DFilterFrame.this.outputGain < 1.0E-8) && !Double.isInfinite(DFilterFrame.this.outputGain)) continue;
                    DFilterFrame.this.unstable = true;
                    break;
                }
                if (!bl || n3 >= 24000) break;
                if (n3 == 0) {
                    if (DFilterFrame.this.outputGain == 1.0) break;
                    DFilterFrame.this.outputGain = 1.0;
                    continue;
                }
                DFilterFrame.this.outputGain *= 30000.0 / (double)n3;
            }
            if (DFilterFrame.this.unstable) {
                return;
            }
            n3 = this.outbp;
            this.outbp = n2;
            this.line.write(this.ob, 0, n);
            this.spectCt += n / 4;
        }
    }

    class ImpulseWaveform
    extends Waveform {
        int ix;

        ImpulseWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            return true;
        }

        int getData() {
            int n = DFilterFrame.this.inputBar.getValue() / 51 + 1;
            int n2 = 10000 / n;
            for (int i = 0; i != this.buffer.length; ++i) {
                int n3 = 0;
                if (this.ix % n2 == 0) {
                    n3 = Short.MAX_VALUE;
                }
                ++this.ix;
                this.buffer[i] = n3;
            }
            return this.buffer.length;
        }

        String getInputText() {
            return "Impulse Frequency";
        }

        boolean needsFrequency() {
            return false;
        }
    }

    class SweepWaveform
    extends Waveform {
        int ix;
        double omega;
        double nextOmega;
        double t;
        double startOmega;

        SweepWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.nextOmega = this.omega = 251.32741228718345 / (double)DFilterFrame.this.sampleRate;
            this.startOmega = this.omega;
            this.t = 0.0;
            return true;
        }

        int getData() {
            double d = 1.0;
            double d2 = 0.0;
            double d3 = 1.0 / (0.66 * (double)DFilterFrame.this.sampleRate);
            double d4 = 1 / (DFilterFrame.this.sampleRate * 16);
            if (DFilterFrame.this.logFreqCheckItem.getState()) {
                d = Math.pow(Math.PI * 2 / this.startOmega, 2.0 * (d4 + (d3 - d4) * (double)DFilterFrame.this.inputBar.getValue() / 1000.0));
            } else {
                d2 = (Math.PI * 2 - this.startOmega) * (d4 + (d3 - d4) * (double)DFilterFrame.this.inputBar.getValue() / 1000.0);
            }
            for (int i = 0; i != this.buffer.length; ++i) {
                ++this.ix;
                this.t += this.omega;
                if (this.t > Math.PI * 2) {
                    this.t -= Math.PI * 2;
                    this.omega = this.nextOmega;
                    if (this.nextOmega > Math.PI) {
                        this.omega = this.nextOmega = this.startOmega;
                    }
                }
                this.buffer[i] = (short)(Math.sin(this.t) * 32000.0);
                this.nextOmega = this.nextOmega * d + d2;
            }
            return this.buffer.length;
        }

        String getInputText() {
            return "Sweep Speed";
        }

        boolean needsFrequency() {
            return false;
        }
    }

    class SquareWaveform
    extends Waveform {
        int ix;
        double omega;
        short[] smbuf;

        SquareWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        int getData() {
            int n;
            int n2 = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (n2 != this.smbuf.length) {
                this.smbuf = new short[n2];
                for (n = 0; n != n2 / 2; ++n) {
                    this.smbuf[n] = 32000;
                }
                if ((n2 & 1) > 0) {
                    this.smbuf[n++] = 0;
                }
                while (n != n2) {
                    this.smbuf[n] = -32000;
                    ++n;
                }
            }
            n = 0;
            while (n != this.buffer.length) {
                if (this.ix >= n2) {
                    this.ix = 0;
                }
                this.buffer[n] = this.smbuf[this.ix];
                ++n;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class SawtoothWaveform
    extends Waveform {
        int ix;
        short[] smbuf;

        SawtoothWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        int getData() {
            int n;
            int n2 = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (n2 != this.smbuf.length) {
                this.smbuf = new short[n2];
                double d = (double)n2 / 2.0;
                for (n = 0; n != n2; ++n) {
                    this.smbuf[n] = (short)(((double)n / d - 1.0) * 32000.0);
                }
            }
            n = 0;
            while (n != this.buffer.length) {
                if (this.ix >= n2) {
                    this.ix = 0;
                }
                this.buffer[n] = this.smbuf[this.ix];
                ++n;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class TriangleWaveform
    extends Waveform {
        int ix;
        short[] smbuf;

        TriangleWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        int getData() {
            int n;
            int n2 = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (n2 != this.smbuf.length) {
                this.smbuf = new short[n2];
                double d = (double)n2 / 2.0;
                n = 0;
                while ((double)n < d) {
                    this.smbuf[n] = (short)((double)n / d * 64000.0 - 32000.0);
                    ++n;
                }
                while (n != n2) {
                    this.smbuf[n] = (short)((2.0 - (double)n / d) * 64000.0 - 32000.0);
                    ++n;
                }
            }
            n = 0;
            while (n != this.buffer.length) {
                if (this.ix >= n2) {
                    this.ix = 0;
                }
                this.buffer[n] = this.smbuf[this.ix];
                ++n;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class SineWaveform
    extends Waveform {
        int ix;

        SineWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            return true;
        }

        int getData() {
            for (int i = 0; i != this.buffer.length; ++i) {
                ++this.ix;
                this.buffer[i] = (short)(Math.sin((double)this.ix * DFilterFrame.this.inputW) * 32000.0);
            }
            return this.buffer.length;
        }
    }

    class PeriodicNoiseWaveform
    extends Waveform {
        short[] smbuf;
        int ix;

        PeriodicNoiseWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.smbuf = new short[1];
            this.ix = 0;
            return true;
        }

        int getData() {
            int n;
            int n2 = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (n2 != this.smbuf.length) {
                this.smbuf = new short[n2];
                for (n = 0; n != n2; ++n) {
                    this.smbuf[n] = (short)DFilterFrame.this.random.nextInt();
                }
            }
            n = 0;
            while (n != this.buffer.length) {
                if (this.ix >= n2) {
                    this.ix = 0;
                }
                this.buffer[n] = this.smbuf[this.ix];
                ++n;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class NoiseWaveform
    extends Waveform {
        NoiseWaveform() {
        }

        boolean start() {
            this.getBuffer();
            return true;
        }

        int getData() {
            for (int i = 0; i != this.buffer.length; ++i) {
                this.buffer[i] = (short)DFilterFrame.this.random.nextInt();
            }
            return this.buffer.length;
        }

        String getInputText() {
            return null;
        }

        boolean needsFrequency() {
            return false;
        }
    }

    class Mp3Waveform
    extends Waveform {
        Decoder decoder;
        Bitstream bitstream;
        Header header;
        boolean first;
        SampleBuffer output;
        String fileName;
        BufferedInputStream bis;

        Mp3Waveform(int n) {
            this.fileName = DFilterFrame.this.mp3List[n];
        }

        boolean start() {
            this.first = false;
            try {
                if (this.bis != null) {
                    try {
                        this.bis.reset();
                    }
                    catch (Exception exception) {
                        this.bis = null;
                    }
                }
                if (this.bis == null) {
                    URL uRL = new URL(DFilterFrame.this.applet.getCodeBase() + this.fileName);
                    Object object = uRL.getContent();
                    if (object instanceof BufferedInputStream) {
                        this.bis = (BufferedInputStream)object;
                    } else {
                        FilterInputStream filterInputStream = (FilterInputStream)object;
                        this.bis = new BufferedInputStream(filterInputStream);
                    }
                    this.bis.mark(200000);
                }
                this.bitstream = new Bitstream(this.bis);
                this.header = this.bitstream.readFrame();
                this.decoder = new Decoder();
                this.output = (SampleBuffer)this.decoder.decodeFrame(this.header, this.bitstream);
                DFilterFrame.this.setSampleRate(this.decoder.getOutputFrequency());
                DFilterFrame.this.rateChooser.disable();
                this.first = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DFilterFrame.this.mp3Error = "Can't open " + this.fileName;
                return false;
            }
            return true;
        }

        int getData() {
            if (!this.first) {
                try {
                    this.bitstream.closeFrame();
                    this.header = this.bitstream.readFrame();
                    if (this.header == null) {
                        if (!this.start()) {
                            return 0;
                        }
                        return this.getData();
                    }
                    this.output = (SampleBuffer)this.decoder.decodeFrame(this.header, this.bitstream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 0;
                }
            } else {
                this.first = false;
            }
            this.buffer = this.output.getBuffer();
            return this.output.getBufferLength();
        }

        int getChannels() {
            return this.decoder.getOutputChannels();
        }

        String getInputText() {
            return null;
        }

        boolean needsFrequency() {
            return false;
        }
    }

    abstract class Waveform {
        short[] buffer;

        Waveform() {
        }

        boolean start() {
            return true;
        }

        abstract int getData();

        int getChannels() {
            return 2;
        }

        void getBuffer() {
            this.buffer = new short[DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 12) * this.getChannels()];
        }

        String getInputText() {
            return "Input Frequency";
        }

        boolean needsFrequency() {
            return true;
        }
    }

    class FFT {
        double[] wtabf;
        double[] wtabi;
        int size;

        FFT(int n) {
            this.size = n;
            if ((this.size & this.size - 1) != 0) {
                System.out.println("size must be power of two!");
            }
            this.calcWTable();
        }

        void calcWTable() {
            this.wtabf = new double[this.size];
            this.wtabi = new double[this.size];
            for (int i = 0; i != this.size; i += 2) {
                double d = 3.1415926535;
                double d2 = d * (double)i / (double)this.size;
                this.wtabf[i] = Math.cos(d2);
                this.wtabf[i + 1] = Math.sin(d2);
                this.wtabi[i] = this.wtabf[i];
                this.wtabi[i + 1] = -this.wtabf[i + 1];
            }
        }

        void transform(double[] dArray, boolean bl) {
            double d;
            double d2;
            double d3;
            double d4;
            int n;
            int n2 = 0;
            int n3 = this.size * 2;
            if ((this.size & this.size - 1) != 0) {
                System.out.println("size must be power of two!");
            }
            for (n = 0; n != n3; n += 2) {
                if (n > n2) {
                    double d5 = dArray[n];
                    dArray[n] = dArray[n2];
                    dArray[n2] = d5;
                    d5 = dArray[n + 1];
                    dArray[n + 1] = dArray[n2 + 1];
                    dArray[n2 + 1] = d5;
                }
                int n4 = this.size;
                while ((n4 & n2) != 0) {
                    n2 &= ~n4;
                    n4 >>= 1;
                }
                n2 |= n4;
            }
            int n5 = this.size << 1;
            double[] dArray2 = bl ? this.wtabi : this.wtabf;
            for (n = 0; n != n3; n += 4) {
                d4 = dArray[n];
                d3 = dArray[n + 1];
                d2 = dArray[n + 2];
                d = dArray[n + 3];
                dArray[n] = d4 + d2;
                dArray[n + 1] = d3 + d;
                dArray[n + 2] = d4 - d2;
                dArray[n + 3] = d3 - d;
            }
            n5 >>= 1;
            int n6 = bl ? -1 : 1;
            for (n = 0; n != n3; n += 8) {
                d4 = dArray[n];
                d3 = dArray[n + 1];
                d2 = dArray[n + 4];
                d = dArray[n + 5];
                dArray[n] = d4 + d2;
                dArray[n + 1] = d3 + d;
                dArray[n + 4] = d4 - d2;
                dArray[n + 5] = d3 - d;
                d4 = dArray[n + 2];
                d3 = dArray[n + 3];
                d2 = dArray[n + 6] * (double)n6;
                d = dArray[n + 7] * (double)n6;
                dArray[n + 2] = d4 - d;
                dArray[n + 3] = d3 + d2;
                dArray[n + 6] = d4 + d;
                dArray[n + 7] = d3 - d2;
            }
            n5 >>= 1;
            for (int i = 16; i <= n3; i <<= 1) {
                int n7 = i >> 1;
                n5 >>= 1;
                for (n = 0; n != 1000; ++n) {
                }
                for (n = 0; n < n3; n += i) {
                    int n8 = 0;
                    n2 = n;
                    while (n2 != n + n7) {
                        double d6 = dArray2[n8];
                        double d7 = dArray2[n8 + 1];
                        d4 = dArray[n2];
                        d3 = dArray[n2 + 1];
                        int n9 = n2 + n7;
                        d2 = dArray[n9];
                        d = dArray[n9 + 1];
                        double d8 = d2 * d6 - d * d7;
                        double d9 = d2 * d7 + d * d6;
                        dArray[n2] = d4 + d8;
                        dArray[n2 + 1] = d3 + d9;
                        dArray[n9] = d4 - d8;
                        dArray[n9 + 1] = d3 - d9;
                        n2 += 2;
                        n8 += n5;
                    }
                }
            }
        }
    }

    class PhaseColor {
        public double r;
        public double g;
        public double b;

        PhaseColor(double d, double d2, double d3) {
            this.r = d;
            this.g = d2;
            this.b = d3;
        }
    }

    class View
    extends Rectangle {
        int right;
        int bottom;

        View(Dimension dimension) {
            super(dimension);
        }

        View(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.right = n + n3 - 1;
            this.bottom = n2 + n4 - 1;
        }

        void drawLabel(Graphics graphics, String string) {
            graphics.setColor(Color.white);
            DFilterFrame.this.centerString(graphics, string, this.y - 5);
        }
    }
}

