package FFT;




/**
 * Diese Klasse realisiert die 2D Fourier-Transformation.
 * Grundlage des Algorithmus ist die 1d-fft.Die 2D-ft kann auf die 1D-fft zurueckgefuehrt werden.
 * So kann bei einem 2 dimensionalem Bild erst 
 * Zeilenweise transformiert werden und dann spaltenweise.
 * Die Struktur des Pseudcodes ist hier zu erkennen:
 * 
 *Iterative-FFT(a)
 * 
 * Bit-Reverse-Copy(a,A)   Methode siehe unten!!!
 * n <-- length[a] 
 * for s <-- 1 to lg n
 *   do m <-- 2^s
 *      Wm <-- exp (2*PI/m)
 *      W <-- 1
 *      for j <-- 0 to m/2-1
 *        do for k <-- j to n-1 by m   "by m" bedeutet k jeweils um m erhhen.
 *             do t <-- W*A[k+m/2]
 *                u <-- A[k]
 *                A[k] <-- u+t
 *                A[k+m/2] <-- u-t
 *           W <-- W*Wm
 * return A
 * 
 * 
 * Bit-Reverse-Copy(a,A)
 *  for k <--0 to n-1
 *    do A[rev(k)]=a[k]
 * 
 * rev(k) spiegelt dabei die Bits von k: z.B: 001 --> 100 
 */

public class fft {
    
    public void FFT1d(boolean dir, int m, double[] real, double[] imag)  //  dir gendert....true == alte 1
    {
       long nn,k,i2,l,l1,l2; // i, j und i1 als int bezeichnen
       int i,j, i1;
       double c1,c2,tmp,t1,t2,u1,u2,z;

       /* Calculate the number of points */
       nn = 1;
       for (i=0;i<m;i++) nn *= 2;


       i2 = nn >> 1;
       j = 0;

       for (i=0;i<nn-1;i++) {
             if (i < j) {
    			tmp= real[i]; real[i]=real[j]; real[j]=tmp; //swap x[i] and x[j]
                tmp= imag[i]; imag[i]=imag[j]; imag[j]=tmp; //swap y[i] and y[j]
             }
             k = i2;
             while (k <= j) {
                j -= k;
                k >>= 1;
             }
             j += k;
       }


       /* Compute the FFT */
          c1 = -1.0;
          c2 = 0.0;
          l2 = 1;
          for (l=0;l<m;l++) {
             l1 = l2;
             l2 <<= 1;
             u1 = 1.0;
             u2 = 0.0;
             for (j=0;j<l1;j++) {
                for (i=j;i<nn;i+=l2) {
                   i1 = i + (int)l1;
                   t1 = u1 * real[i1] - u2 * imag[i1];
                   t2 = u1 * imag[i1] + u2 * real[i1];
                   real[i1] = real[i] - t1;
                   imag[i1] = imag[i] - t2;
                   real[i] += t1;
                   imag[i] += t2;
                }
                z =  u1 * c1 - u2 * c2;
                u2 = u1 * c2 + u2 * c1;
                u1 = z;
             }
             c2 = Math.sqrt((1.0 - c1) / 2.0);
             if (dir) c2 = -c2;
             c1 = Math.sqrt((1.0 + c1) / 2.0);
       }


       /* Scaling for forward transform */
       if (dir) {
          for (i=0;i<nn;i++) {

       	        real[i] /= (double)nn;
                imag[i] /= (double)nn;
          }
       }
    }



    /**
     * Realisiert die 2D Fouriertransformation.
     * Dem Konstruktor werden Real-und Imaginaerteil
     * des Bildes uebergeben,wobei der Imaginaerteil
     * bei Hintransformation natuerlich null sein muss.
     * Ob vor-oder zuruecktransformiert werden soll,wird durch
     * die boolsche Variable 'vor' angegeben.
     */
    public void fft2D(doubleiRPImage Re, doubleiRPImage Im,boolean Vor)
    {
    	int nx=Re.GetSizeX();
    	int ny=Re.GetSizeY();
    	int i,j,ofs,half1,half2;
    	double[] real;
    	double[] imag;


    	int m;

    	//m=LOG2(nx);
    	for (m=0;(nx>>(m+1))>0;m++) ;

    	// Transform the rows

    	real = new double[nx];
    	imag = new double[nx];

    	if (Vor) { half1=0; half2=nx>>1;}
    	else { half1=nx>>1; half2=0;}

    	for (j=0,ofs=0;j<ny;j++,ofs+=nx) {
    		for (i=0;i<nx;i++) {
    			real[(i+half1)%nx] = Re.GetPixel(ofs+i);
    			imag[(i+half1)%nx] = Im.GetPixel(ofs+i);
    		}

        	FFT1d(Vor,m,real, imag);
    		for (i=0;i<nx;i++) {

    			Re.SetPixel((ofs+i) , real[(i+half2)%nx]);
    			Im.SetPixel((ofs+i) , imag[(i+half2)%nx]);
    		}
    	}

    	for (i=0;i<nx;i++) {
    		for (j=0,ofs=0;j<ny;j++,ofs+=nx) {
    			real[(j+half1)%nx] = Re.GetPixel(ofs+i);
    			imag[(j+half1)%nx] = Im.GetPixel(ofs+i);
    		}
        		FFT1d(Vor,m, real, imag);
    			for (j=0,ofs=0;j<ny;j++,ofs+=nx) {
    				Re.SetPixel((ofs+i), real[(j+half2)%nx]);
    				Im.SetPixel((ofs+i), imag[(j+half2)%nx]);
    			}
    	}

    }



}
