package FFT;



import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.event.MouseInputListener;
import java.awt.*;
import java.awt.event.*;

/**
 * Bei diesem Applet soll die Diskrete Fouriertransformation und deren
 * Einsatz bei der Bildverarbeitung veranschaulicht werden.
 * Diese Klasse stellt die graphische Oberflaeche und die
 * Logistik fr das fft Applet bereit. Die Oberflaeche besteht aus
 * zwei Panels. Im oberen Bereich befindet sich das Operationpanel,in dem alle
 * Werkzeuge zu finden sind. Im zweiten Panel (fftViewer) sind die 
 * Bilder zu sehen. Dies ist auch die eigentliche Arbeitsflaeche des
 * Benutzers. 
 * 
 * Zum programminternen Ablauf einer Bildmanipulation:
 * Wird vom Benutzer die Fouriertransformierte bearbeitet,so wird die Operation
 *  zwecks visueller Darstellung 
 *  zunaechst an den  iRPImage Objekten filteredAmplitude und filteredPhase
 * durchgefuehrt. Diese beiden iRPImage Objekte sind auf der Ober-
 * flaeche als Amplitude bzw. als Phase sichtbar. Damit die Operation dann
 * auch bei der Ruecktransformation wirksam wird, wird diese noch bei
 * den Objekten filteredImage1 und filteredImage2 durchgefuehrt. filteredImage1
 * stellt den Realteil und filteredImage2 den Imaginaerteil der Fouriertransformation
 * dar. Beide sind doubleiRPImage Objekte und werden bei der 
 * Ruecktransformation benoetigt.   Dies sind allerdings  nur Kopien
 * der Fouriertransformation,damit alle Aenderungen wieder rueckgaengig
 * gemacht werden koennen. Die Kopien werden angefertigt,wenn ein
 * neues Bild ausgewaehlt oder auf den reset-Button geklickt wird.
 * 
 * @author Rene Iser, Behrang Karmimibabak, Simon Winkelbach

 */

public class fftApplet extends JApplet implements MouseInputListener{
    
    // Die iRPImage Objekte sind fr die Manipulation der Bilder.
    // filteredAmplitude und filteredPhase sind fuer die Visuelle
    // darstellung von Betrag und Phase zustaendig.
    
	protected iRPImage A, B, C, D,filteredInputImage,filteredAmplitude;
	protected iRPImage filteredPhase;
	protected doubleiRPImage D1, D2, temp1, temp2, temp3, temp4;    
	protected doubleiRPImage filteredImage1,filteredImage2;
    protected JPanel operationPanel,messagePanel;
    protected JPanel[] toolMainPanel,toolSubPanel;
    protected JDialog pictureDialog,toolDialog;
    protected fftViewer viewer; // Hier werden die Bilder untergebracht.
    protected JButton sample; //startet die Abtastung
    protected JButton clear;   
    protected JButton cordSystem,choosePicture,chooseTool;
    protected JButton circleButton,rectButton,invCircButton,invRectButton,lineButton,pointPairButton;
    protected JButton[] pictureButtons;
    protected fft ft = new fft();
    protected ImageWindow input,output,amplitude,phase;
    protected JLabel circleToolLabel,pointToolLabel,rectToolLabel;
    protected JLabel message1,message2,invCircToolLabel,invRecToolLabel,lineToolLabel;
    protected final String[] pictures={"Punkte","Clown","Face","box","Empty"};
    protected final String[] tools={"circle","rect","inverse circle","inverse rect","line","points"}; 
    protected final String[] sampling={"2","3","4","5","6","7","8","9","10","11","12"};
    protected String plaf,imageToLoad;
    protected int startX,startY,endX,endY,width,height,radius; // Definition von Kreisen,linien,etc..
    protected int sRate; // die Abtastrate
    protected ImageIcon dialogIcon;
    protected DialogImageProvider imgProv;
    protected Image[] dialogImg;
    protected String[] dialogImgNames;
    
    /**
     * Die boolschen Variablen sind fuer die diversen Fallunterscheidungen innerhalb
     * des Systems. line,rect usw. unterscheiden das ausgewaehlte Tool.
     * firstMousePress ist dazu da einen Startpunkt fuer die geometrischen Figuren
     * zu markieren. Diese wird immer dann auf 'false' gesetzt sobald zum ersten 
     * Mal die mouseDragged-Methode aufgerufen wird(Bzw. wieder auf 'true' bei 
     * mouseReleased).
     * Die Picture-Variablen unterscheiden welches bild gerade bearbeitet werden soll.
     */
    boolean line,point,rect,circle,inverseRect,inverseCircle;
    boolean firstMousePress,cutedOut,chooseCordSystem;
    boolean amplitudePicture,inputPicture,outputPicture,phasePicture;
    
    public void init() { 
	    
	//////////////////////////////////////////////	

        line=false;point=false;rect=false;circle=true;
        inverseRect=false;inverseCircle=false;
        cutedOut=false;
        firstMousePress=true;
        chooseCordSystem=false;
        sRate=2;
  
        imgProv = new DialogImageProvider();
        dialogImg = imgProv.getImages();
        dialogImgNames = imgProv.getImageNames();
        
        Image dialogImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("dialogIcon.gif"));
        dialogIcon=new ImageIcon(dialogImage);
        
        this.initializeStartImages();
        this.initializeButtons();
        this.initializeLabels(); 
        this.initialzeDialog();
 


 
        messagePanel=new JPanel();
        messagePanel.setPreferredSize(new Dimension(220,50));
        messagePanel.setBorder(BorderFactory.createEtchedBorder());
        messagePanel.add(message1);
        messagePanel.add(message2);
        Dimension d = new Dimension(250,120);
        operationPanel = new JPanel();
        operationPanel.setLayout(new FlowLayout(FlowLayout.LEFT,10,10));
        operationPanel.setPreferredSize(d);
        operationPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        operationPanel.add(choosePicture);
        operationPanel.add(chooseTool);
        operationPanel.add(sample);
        operationPanel.add(cordSystem);
        operationPanel.add(clear);
        operationPanel.add(messagePanel);

 
 

	    viewer = new fftViewer(input,amplitude,phase,output);
	    viewer.setLayout(new FlowLayout(FlowLayout.LEFT,10,15));
	    viewer.add(operationPanel);

        getContentPane().add(viewer);
 
 
 
 
        this.changeLookAndFeel();
 
    		
        this.initializeActionListeners();

    	operationPanel.addMouseMotionListener(this);
    	operationPanel.addMouseListener(this);
    	addMouseListener(this);
    	addMouseMotionListener(this);

        
    }
    
    /**
     * Initialisierung der Dialogboxen,welche aufgerufen werden,
     * wenn man das Bild oder das Tool wechselt.
     */
    
    public void initialzeDialog(){
        JOptionPane picturePane = new JOptionPane();
 
        
        pictureButtons=new JButton[dialogImg.length];
        String buttonName;
        
        /*
         *Hier werden die Buttons zur Bildauswahl initialisiert.
         *In 'buttonName' wird der Name des zu ladenen Bildes gespeichert.
         *Hier wird davon ausgegangen, dass die kleinen Bilder fr die Icons
         *auf den Buttons auf '..Dialog.jpg' oder 'Dialog.gif' enden.
         *Daher auch die -10 in dem substring(..)- Aufruf.
         *Es ist Voraussetzung, dass das Iconbild und das groe Bild, welches
         *hier geladen werden soll, dasselbe Dateiformat, also '.gif' oder 'jpg'
         *haben.
         */
        for(int i=0;i<dialogImg.length;i++){
                        
            buttonName=dialogImgNames[i];
            pictureButtons[i]= new JButton(new ImageIcon(dialogImg[i]));
            pictureButtons[i].setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
            pictureButtons[i].setName(buttonName);
             
        }
        
        picturePane.setOptions(pictureButtons);
        picturePane.setMessage("");
        pictureDialog= picturePane.createDialog(this,"select input image");
        
        toolDialog=new JDialog();
 
        toolMainPanel=new JPanel[1];
        toolMainPanel[0]=new JPanel();
        toolMainPanel[0].setLayout(new BorderLayout(0,0));
        
        toolSubPanel=new JPanel[2];
        toolSubPanel[0]=new JPanel();
        toolSubPanel[0].setLayout(new FlowLayout(FlowLayout.LEFT,10,15));
        toolSubPanel[0].setPreferredSize(new Dimension(400,70));
        
        toolSubPanel[1]=new JPanel();
        toolSubPanel[1].setLayout(new FlowLayout(FlowLayout.LEFT,5,15));
        toolSubPanel[1].setPreferredSize(new Dimension(400,70));
        toolSubPanel[1].add(new JLabel(" "));
        toolSubPanel[1].add(circleToolLabel);
        toolSubPanel[1].add(invCircToolLabel);
        toolSubPanel[1].add(rectToolLabel);
        toolSubPanel[1].add(invRecToolLabel);
        toolSubPanel[1].add(pointToolLabel);
  
        toolSubPanel[1].add(new JLabel(" "));
        toolSubPanel[1].add(lineToolLabel);
  
        
        toolSubPanel[0].add(circleButton);
        toolSubPanel[0].add(invCircButton);
        toolSubPanel[0].add(rectButton);
        toolSubPanel[0].add(invRectButton);
        toolSubPanel[0].add(pointPairButton);
        toolSubPanel[0].add(lineButton);
        
        
        toolMainPanel[0].add(BorderLayout.NORTH,toolSubPanel[0]);
        toolMainPanel[0].add(BorderLayout.CENTER,toolSubPanel[1]);
        
        JOptionPane toolPane=new JOptionPane();
        toolPane.setOptions(toolMainPanel);
        toolPane.setMessage("");
        
        toolDialog=toolPane.createDialog(this,"select tool");
        
        
    }
    
    /**
     * Initialisierung der Labels.
     * Diese werden hier im wesentlichen fuer die textuelle Beschreibung der 
     * Manipulationstools benoetigt. Die Labels message1 und message2 
     * stehen in der "Statusleiste" des Operationpanels. Sie geben immer
     * den naechsten Arbeitsschritt am, der am wahrscheinlichsten erfolgen soll. 
     */
    
    public void initializeLabels(){
        
        message1 = new JLabel("Optionally select a new picture/tool");
        message2 = new JLabel("or you can start sampling the image");
        
        Image circleImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("circleToolLabel.gif"));
        ImageIcon circleIcon = new ImageIcon(circleImage);
        circleToolLabel=new JLabel(circleIcon);
        
        Image rectImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("rectToolLabel.gif"));
        ImageIcon rectIcon = new ImageIcon(rectImage);
        rectToolLabel=new JLabel(rectIcon);
        
        Image invCircImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("invCircLabel.gif"));
        ImageIcon invCircIcon = new ImageIcon(invCircImage);
        invCircToolLabel=new JLabel(invCircIcon);
        
        Image invRectImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("invRectLabl.gif"));
        ImageIcon invRectIcon = new ImageIcon(invRectImage);
        invRecToolLabel=new JLabel(invRectIcon);
        
        Image lineImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("lineLabel.gif"));
        ImageIcon lineIcon = new ImageIcon(lineImage);
        lineToolLabel=new JLabel(lineIcon);
        
        Image pointImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("pointLabel.gif"));
        ImageIcon pointIcon = new ImageIcon(pointImage);
        pointToolLabel=new JLabel(pointIcon);
        
 
 
    }
    
    /**
     * Aenderung der optischen Oberflaeche.
     */
    
    public void changeLookAndFeel(){
        //      Look and Feel der Oberflaeche.
       
    	try{
    		plaf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    		UIManager.setLookAndFeel(plaf);
    		SwingUtilities.updateComponentTreeUI(this);
    		SwingUtilities.updateComponentTreeUI(chooseTool);
       		SwingUtilities.updateComponentTreeUI(clear);
      		SwingUtilities.updateComponentTreeUI(cordSystem);
    		SwingUtilities.updateComponentTreeUI(operationPanel);
       		SwingUtilities.updateComponentTreeUI(choosePicture);
       		SwingUtilities.updateComponentTreeUI(viewer);
      		SwingUtilities.updateComponentTreeUI(sample);
     		SwingUtilities.updateComponentTreeUI(circleButton);
     		SwingUtilities.updateComponentTreeUI(rectButton);
     		SwingUtilities.updateComponentTreeUI(invCircButton);
     		SwingUtilities.updateComponentTreeUI(invRectButton);
     		SwingUtilities.updateComponentTreeUI(lineButton);
     		SwingUtilities.updateComponentTreeUI(pointPairButton);
    		for (int i=0;i<pictureButtons.length;i++){
    		    SwingUtilities.updateComponentTreeUI(pictureButtons[i]);
    		}
    		 
 
 
    		} catch (UnsupportedLookAndFeelException e) {
    		    System.err.println(e.toString());
    		} catch (ClassNotFoundException e) {
    		    System.err.println(e.toString());
    		} catch (InstantiationException e) {
    		    System.err.println(e.toString());
    		} catch (IllegalAccessException e) {
    		    System.err.println(e.toString());
    		}
    }
    
    /**
     * Erstellen der Buttons.
     * Alle Buttons werden mit Icons versehen und 
     * bekommen eine Umrandung.
     */
    
    public void initializeButtons(){
        Image resetImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("reset.gif"));
        clear=new JButton(new ImageIcon(resetImage));
        clear.setToolTipText("resets all images");
        clear.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image sampleImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("sample.gif"));
        ImageIcon sampleIcon = new ImageIcon(sampleImage);
        sample=new JButton(sampleIcon);
        sample.setToolTipText("samples the input image");
        sample.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
  
        
        Image cordImage=Toolkit.getDefaultToolkit().getImage(getClass().getResource("cordSystem.gif"));
        cordSystem= new JButton(new ImageIcon(cordImage)); 
        cordSystem.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        cordSystem.setToolTipText("activates/deactives coordinate systems");
        
        Image pictureImage=Toolkit.getDefaultToolkit().getImage(getClass().getResource("picture.gif"));
        ImageIcon pictureIcon=new ImageIcon(pictureImage);
        choosePicture=new JButton(pictureIcon);       
        choosePicture.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        choosePicture.setToolTipText("choose picture");
        
        Image toolImage=Toolkit.getDefaultToolkit().getImage(getClass().getResource("tool.jpg"));
        ImageIcon toolIcon=new ImageIcon(toolImage);
        chooseTool=new JButton(toolIcon);
        
        chooseTool.setToolTipText("choose tool");
        chooseTool.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));

        Image circleImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("circleTool.jpg"));
        ImageIcon circleIcon = new ImageIcon(circleImage);
        circleButton = new JButton(circleIcon);
        circleButton.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image rectImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("rectTool.jpg"));
        ImageIcon rectIcon = new ImageIcon(rectImage);
        rectButton = new JButton(rectIcon);
        rectButton.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image invCircleImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("inverseCircleTool.jpg"));
        ImageIcon invCircleIcon = new ImageIcon(invCircleImage);
        this.invCircButton = new JButton(invCircleIcon);
        invCircButton.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image invRectImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("inverseRectTool.jpg"));
        ImageIcon invRectIcon = new ImageIcon(invRectImage);
        this.invRectButton=new JButton(invRectIcon);
        invRectButton.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image lineImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("lineTool.jpg"));
        ImageIcon lineIcon = new ImageIcon(lineImage);
        lineButton=new JButton(lineIcon);
        lineButton.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image pointPairImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("pointTool.jpg"));
        ImageIcon pointPairIcon = new ImageIcon(pointPairImage);
        pointPairButton=new JButton(pointPairIcon);
        pointPairButton.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        
        
    }
    
    /**
     * Mit Hilfe der ActionListener werden beim
     * Klicken auf die Buttons die entsprechenden Methoden
     * aufgerufen,z.B. wird beim druecken auf den choosePicture-button
     * die Dialogbox mit der Bildauswahl geoeffnet.
     */
    
    public void initializeActionListeners(){
 
     	
    	//Raeumt die Oberflaeche auf.
    	clear.addActionListener(new ActionListener() {
    	    public void actionPerformed(ActionEvent e){
    	        resetScreen();
    	    }
    	});
    	
    	// Start der Abtastung
       sample.addActionListener(new ActionListener() {
    	    public void actionPerformed(ActionEvent e){
 
    	        sampleImage();
    	        message1.setText("select circular low pass tool to try");
    	        message2.setText("to reconstruct the original image");
    	    }
    	});
        
       choosePicture.addActionListener(new ActionListener() {
   	    public void actionPerformed(ActionEvent e){
   	        pictureDialog.show();

   	    }
   	   });
       
       chooseTool.addActionListener(new ActionListener() {
      	    public void actionPerformed(ActionEvent e){
      	        toolDialog.show();
      	    }
     	});
     	
    	cordSystem.addActionListener(new ActionListener(){
    	    public void actionPerformed(ActionEvent e){
    	        if (!chooseCordSystem){
    	            drawCoordinateSystems(true);
    	            chooseCordSystem=true;
    	            repaint();
    	        }
    	        else {
    	            drawCoordinateSystems(false);  
    	            chooseCordSystem=false;
    	            repaint();
    	        }
    	    }
        });

        circleButton.addActionListener(new ActionListener() {
       	    public void actionPerformed(ActionEvent e){
    	        toolDialog.setVisible(false);
       	        getTool("circle");

       	    }
       	   });
        
        rectButton.addActionListener(new ActionListener() {
       	    public void actionPerformed(ActionEvent e){
    	        toolDialog.setVisible(false);
       	        getTool("rect");

       	    }
       	   });
        
        invCircButton.addActionListener(new ActionListener() {
       	    public void actionPerformed(ActionEvent e){
    	        toolDialog.setVisible(false);
       	        getTool("inverse circle");

       	    }
       	   });
        
        invRectButton.addActionListener(new ActionListener() {
       	    public void actionPerformed(ActionEvent e){
    	        toolDialog.setVisible(false);
       	        getTool("inverse rect");

       	    }
       	   });
        
        lineButton.addActionListener(new ActionListener() {
       	    public void actionPerformed(ActionEvent e){
    	        toolDialog.setVisible(false);
       	        getTool("line");

       	    }
       	   });
        
        pointPairButton.addActionListener(new ActionListener() {
       	    public void actionPerformed(ActionEvent e){
    	        toolDialog.setVisible(false);
       	        getTool("points");

       	    }
       	   });
        
        for (int i=0;i<dialogImg.length;i++){
            pictureButtons[i].addActionListener(new ActionListener(){
                public void actionPerformed(ActionEvent e){
                    imageToLoad=((JButton)e.getSource()).getName();
                    changePicture(imageToLoad);
                    pictureDialog.setVisible(false);
                }
            });     	
        }
    }
    
    
    /**
     * Das Eingangsbild wird hin-und rueck transformiert.
     * filteredInputImage,filteredAmplitude,filteredPhase sind Kopien
     * des Eingangsbildes,bzw. der Fouriertransformation. Soll z.B. aus
     * der Amplitude ein Kreis ausgeschnitten werden, wird der Kreis in die
     * filteredAmplitude herausgeschnitten,statt aus B,damit die
     * urspruengliche Fouriertransformation wieder rekonstruiert werden kann.
     * Genauso verhaelt es sich mit filteredImage1 und filteredImage2.
     * Dies sind Kopien von temp1 und temp2 (Real-und Imaginaerteil),an denen
     * Aenderungen tatsaechlich durchgefuehrt werden.
     */
    public void initializeStartImages(){
        /*
         * 'Punkte' ist das Startbild. Dies wird gleich transformiert.
         */
        A=new iRPImage();
        A.LoadImage(dialogImgNames[0]);
		B = new iRPImage(A.GetSizeX(), A.GetSizeY());
		C = new iRPImage(A.GetSizeX(), A.GetSizeY());
		D = new iRPImage(A.GetSizeX(), A.GetSizeY());
		D2 = C.makedoubleiRPImage();
		
		/*
		 * Initialisiere die Startbilder
		 */
	//////////////////////////////////////////////	
		D1=A.makedoubleiRPImage();
		D2.Clear(0);
		ft.fft2D(D1,D2,true);
		temp1 = D1.copy();
		temp2 = D2.copy();
		Rect2PolarInplace(D1,D2,true);
		B = D1.makeiRPImage();
		C = D2.makeiRPImage();
		
		temp3=temp1.copy();
		temp4=temp2.copy();
		ft.fft2D(temp3,temp4,false);
	    D=temp3.makeiRPImage();
		filteredImage1 = temp1.copy();
		filteredImage2 = temp2.copy();
        filteredAmplitude=B.copy(); 
        filteredPhase=C.copy();
        filteredInputImage=A.copy();
		
	    // initialiesierung der vier ImageWindow Objekte
	    
	    input = new ImageWindow(A,10,160);
	    input.setCoordinateSystemVariable("x","y");
	    input.setTitle("input");
	    amplitude = new ImageWindow(B,380,20);
	    amplitude.setCoordinateSystemVariable("u","v");
	    amplitude.setTitle("amplitude");
	    phase = new ImageWindow(C,380,320);
	    phase.setCoordinateSystemVariable("u","v");
	    phase.setTitle("phase");
	    output = new ImageWindow(D,760,160);
	    output.setTitle("output");
	    output.setCoordinateSystemVariable("x","y");
	    
    }
    
    /**
     * Abhaengig von der Wahl des Bildes
     * wird das entsprechende Bild geladen.
     * Dieses wird sofort transformiert und das Ergebnis
     * entsprechend auf der Oberflaeche dargestellt.
     * @param s Name des Bildes
     */
    
    public void changePicture(String s)
    {
 
 /*
    	if(s=="House")
    	{
    		A.LoadImage("house.jpg");
 
       		
     	}

    	if(s=="Clown")
    	{
    		A.LoadImage("clown.gif");
 
       		
    	}

    	if(s=="Face")
    	{
    		A.LoadImage("face.jpg");
 
       		
    	}

    	if(s=="box")
    	{
    		A.LoadImage("box.jpg");
  
       		
    	}
    	
    	if(s=="boxRotated"){
    	    
    	    A.LoadImage("box_small_rotated.jpg");
    	}
    	
       	if(s=="stripeProjection"){
    	    
    	    A.LoadImage("stripeProjection.jpg");
    	}
       	
       	if(s=="box_small"){
       	        A.LoadImage("box_small.gif");
       	}
       	
       	if(s=="fingerprint"){
       	    A.LoadImage("fingerprint.jpg");
       	}


    	if(s=="Empty")
    	{
    		A = new iRPImage(A.GetSizeX(), A.GetSizeY());
 
      		 
    	}*/
        A.LoadImage(s);

        input.resetImportantFlags();
    	message1.setText("Optionally select a new picture/tool");
    	message2.setText("or you can start sampling the image");
    	resetScreen(); //Transformation des bildes
     
   	
    }
    
    /**
     * Hier wird das jeweilige Tool zum manipulieren
     * der Bilder ausgewaehlt und die entsprechenden Variablen
     * gesetzt. Wird z.B. 'circle' ausgewaehlt,so ist circle=true
     * und der Rest wird auf 'false' gesetzt.
     * @param s Name des Tools.
     */
    
    public void getTool(String s) {

        if (s=="circle") {
            
                       circle=true;
                       rect=false;
                       point=false;
                       inverseRect=false;
                       inverseCircle=false;
                       line=false;
                       
                   }
                   
                   if (s=="rect"){
                       rect=true;
                       circle=false;
                       point=false;
                       inverseRect=false;
                       inverseCircle=false;
                       line=false;
                   }
                   
                   if (s=="inverse circle"){
                       rect=false;
                       circle=false;
                       point=false;
                       inverseRect=false;
                       inverseCircle=true;
                       line=false;
                   }
                   
                   if (s=="inverse rect"){
                       rect=false;
                       circle=false;
                       point=false;
                       inverseRect=true;
                       inverseCircle=false;
                       line=false;
                   }
                   
                   if (s=="line"){
                       rect=false;
                       circle=false;
                       point=false;
                       inverseRect=false;
                       inverseCircle=false;
                       line=true;
                       
                   }
                   
                   if (s=="points"){
                       rect=false;
                       circle=false;
                       point=true;
                       inverseRect=false;
                       inverseCircle=false;
                       line=false;
            
                   }
                   
                   if(!point){
                       message1.setText("Keep mouse button pressed");
                       message2.setText("and drag it over an image");   
                   }
                   else{
                       message1.setText("Click into an image to");
                       message2.setText("set complex points");
                   }
                   repaint();
 
    }
    
    /**
     * Die Methode weist der Variablen
     * sRate die zuvor gewaehlte Abtastrate
     * zu.
     * @param rate
     */
    
    public void getSampleRate(String rate){
        sRate=Integer.parseInt(rate);
    }
    
    
    /**
     * In dieser Methode werden
     * Betrag und Phase des transformierten
     * Bildes berechnet.
     * @param Re Realteil des Bildes
     * @param Im Imaginaerteil des Bildes
     * @param logarith entscheidet ob der Logarithmus genutzt werden soll
     */
    public void Rect2PolarInplace(doubleiRPImage Re, doubleiRPImage Im,boolean logarith)
    {
        double re,im;
        for (int i=0;i<Re.GetSize();i++)
        {
            re=Re.GetPixel(i); im=Im.GetPixel(i);
            if (logarith) Re.SetPixel(i, Math.log(re*re+im*im+0.00001));   //Amplitude (log)
            else Re.SetPixel(i, re*re+im*im);                       	   //Amplitude
            Im.SetPixel(i, Math.atan2(re,im));                             //Phase
        }
    }
    

    /**
     * Diese Methode wird von mouseReleased(..) aufgerufen 
     * Abhaengig davon welches Bild gerade
     * bearbeitet wird und welches Tool gewaehlt wurde
     * werden die entsprechenden Manipulationsmethoden auf-
     * gerufen. Z.B. wenn amplitudePicture 'true' ist, wird gerade
     * das Bild der Amplitude bearbeitet. Wurde als Tool der Kreis
     * gewaehlt wird z.B. cutCircleOut aufgerufen.Auf diese
     * Weise werden alle moegliche Kombinationen ggf. abgearbeitet.
     */
    
    public void cut() {
        int xPos,yPos;
        if (amplitudePicture || phasePicture){
            if (circle){
                cutCircleOut(); 
            }   // Ende if (circle)
            
            else if(inverseCircle || inverseRect){
                cutInverseCircleOut();

            }
            
             
            else if (rect) {
                cutRectOut(); 
            } 
            
            else if(line){
                cutLineOut();
            }
            
            manipulateTransformedImage(); //Fuehrt die Ruecktransformation durch

        } // Ende if(amplitudePicture)
        
        else if(inputPicture){

            if (circle){
                cutCircleOut();
            }   // Ende if (circle)
            
            else if (rect) {
                 cutRectOut(); 
                 }

             else if(inverseCircle || inverseRect){
                 cutInverseCircleOut();
             }
             else if(line){
                 cutLineOut();
             }

            manipulateInputImage(); //Hin-und Ruecktransformation des
            // Eingangsbildes.

        } //Ende if (inputPicture)

    }
        
  
    /**
     * Soll das Koordinatensystem eingezeichet werden?
     * @param draw Gibt an ob das Koordinatensystem gezeichnet
     * werden soll oder nicht.
     */
    public void drawCoordinateSystems(boolean draw) {
		    input.setCordFlag(draw);
		    amplitude.setCordFlag(draw);
		    phase.setCordFlag(draw);
		    output.setCordFlag(draw);
    }
    
    /**
     * Methode welche den konjugiert komplexen Punkt
     * eines Punktes setzt.
     * @param x x-Koordinate des Punktes
     * @param y y-Koordinate des Punktes
     * @param X Bild in welches der Punkt gezeichnet werden soll.
     */
    public void setPixelMirror(int x, int y, iRPImage X){
    	
    	X.SetPixel(X.GetSizeX() - (x), X.GetSizeY() - (y), 255);
    	

    }
    
    /**
     * Die gleiche Methode, nur mit doubleiRPImage.
     * Der manipulierte Punkt in der komplexen Ebene 
     * bekommt einen neuen Betrag zugewiesen. 
     * Dementsprechend werden Real-und Imaginaerteil
     * (filterdImage1,filteredImage2) neu gesetzt.
     * @param x
     * @param y
     */
    public void setPixelMirror(int x, int y){
        double absolut,re,im;
        int value= filteredAmplitude.GetPixel(filteredAmplitude.GetMax());
        double phase=filteredPhase.GetPixel(filteredPhase.sizeX-x,filteredPhase.sizeY-y);
        phase=Math.toRadians(phase);
        if(amplitudePicture){
   
            filteredImage2.SetPixel(filteredImage2.sizeX-x,filteredImage2.sizeY-y,value*(-1)*Math.sin(phase));
        	filteredImage1.SetPixel(filteredImage1.GetSizeX() - (x), filteredImage1.GetSizeY() - (y), value*Math.cos(phase));
        }
        else{
           re=filteredImage1.GetPixel(x,y);
           im=filteredImage2.GetPixel(x,y);
           absolut=Math.sqrt(re*re+im*im);
           filteredImage1.SetPixel(filteredImage1.GetSizeX() - (x), filteredImage1.GetSizeY() - (y),absolut);
           filteredImage1.SetPixel(filteredImage1.GetSizeX() - (x), filteredImage1.GetSizeY() - (y),0);
        }

    }
    
    /**
     * Wurde ein bereits transformiertes Bild
     * bearbeitet wird es hier wieder zurueck
     * transformiert.
     */
    public void manipulateTransformedImage() {
      
        temp3=filteredImage1.copy();
    	temp4=filteredImage2.copy(); 
 		ft.fft2D(temp3,temp4,false);
	    D=temp3.makeiRPImage();
	    output.changeImage(D);
	    amplitude.changeImage(filteredAmplitude);
	    phase.changeImage(filteredPhase);
	    amplitude.resetImportantFlags();
	    phase.resetImportantFlags();
 	    repaint(); 
     
    }
    
    /**
     * Wurde das Eingangsbild bearbeitet wird es hier
     * hin-und zuruecktransformiert.
     */
    public void manipulateInputImage() {
   		D1=filteredInputImage.makedoubleiRPImage();
		D2.Clear(0);
		ft.fft2D(D1,D2,true);
		filteredImage1=D1.copy();
		filteredImage2=D2.copy();
		Rect2PolarInplace(D1,D2,true);
		filteredAmplitude=D1.makeiRPImage();
		filteredPhase=D2.makeiRPImage();
		temp3=filteredImage1.copy();
		temp4=filteredImage2.copy();
		ft.fft2D(temp3,temp4,false);
	    D=temp3.makeiRPImage();
	    input.resetImportantFlags();
	    input.changeImage(filteredInputImage);
	    amplitude.changeImage(filteredAmplitude);
	    phase.changeImage(filteredPhase);
        output.changeImage(D);	 
        repaint();
    }
    
    /**
     * Soll auf eines der Bilder ein  Tiefpassfilter
     * angewendet werden, werden hier,abhaengig vom Bild,die
     * entsprechenden Pixel herausgenommen.
     */
    
    public void cutInverseCircleOut() {
        int xPos,yPos;
        double absolut;
        double re,im;
        if(amplitudePicture || phasePicture){
             int a,b;
            double value,x,y;
            if (amplitudePicture){
                xPos=startX-380-radius;
                yPos=startY-20-radius;
            }
            else{
                xPos=startX-380-radius;
                yPos=startY-320-radius;
            }
 			a = radius;
			b = radius;
			for (int i=0;i<filteredAmplitude.sizeX;i++){
			    for (int j=0;j<yPos;j++){
			        if(amplitudePicture){
			            filteredAmplitude.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,0);
			            filteredImage2.SetPixel(i,j,0);
			        }
			        else{
					    
					    re=filteredImage1.GetPixel(i,j);
					    im=filteredImage1.GetPixel(i,j);
					    absolut= (Math.sqrt(re*re+im*im));
			            filteredPhase.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,absolut);
			            filteredImage2.SetPixel(i,j,0);
			        }
			    }
			}
			for (int i=0;i<xPos;i++){
			    for (int j=yPos;j<=yPos+radius*2;j++){
			        if(amplitudePicture){
			            filteredAmplitude.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,0);
			            filteredImage2.SetPixel(i,j,0);
			        }
			        else{
					    
					    re=filteredImage1.GetPixel(i,j);
					    im=filteredImage1.GetPixel(i,j);
					    absolut= (Math.sqrt(re*re+im*im));
			            filteredPhase.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,absolut);
			            filteredImage2.SetPixel(i,j,0);
			        }
			    }
			}
			if (inverseCircle){
				for (int i=0;i<=radius*2;i++){
					for (int j=0;j<=radius*2;j++){
					x=Math.abs(a-i);y=Math.abs(b-j);
						value=Math.pow(x/a,2)+Math.pow(y/b,2);
						if (value>1){
						    if(amplitudePicture){
						        filteredAmplitude.SetPixel(xPos+i,yPos+j,0);
						        filteredImage1.SetPixel(xPos+i,yPos+j,0); 
						        filteredImage2.SetPixel(xPos+i,yPos+j,0);						    
						    }
						    else{
							    
							    re=filteredImage1.GetPixel(xPos+i,yPos+j);
							    im=filteredImage1.GetPixel(xPos+i,yPos+j);
							    absolut= (Math.sqrt(re*re+im*im));
						        filteredImage1.SetPixel(xPos+i,yPos+j,absolut);
						        filteredPhase.SetPixel(xPos+i,yPos+j,0); 
						        filteredImage2.SetPixel(xPos+i,yPos+j,0);
						    }
						
						}
					}
				}
			
			}

			for (int i=0;i<filteredAmplitude.sizeX;i++){
			    for (int j=yPos+radius*2;j<filteredAmplitude.sizeY;j++){
			        if(amplitudePicture){
			            filteredAmplitude.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,0);			      
			            filteredImage2.SetPixel(i,j,0);
			        }
			        else{
					    
					    re=filteredImage1.GetPixel(i,j);
					    im=filteredImage1.GetPixel(i,j);
					    absolut= (Math.sqrt(re*re+im*im));
			            filteredPhase.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,absolut);
			            filteredImage2.SetPixel(i,j,0);
			        }		        		
			    }
			}
			for (int i=xPos+radius*2;i<filteredAmplitude.sizeX;i++){
			    for (int j=yPos;j<=yPos+radius*2;j++){
			        if(amplitudePicture){
			            filteredAmplitude.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,0);			        
			            filteredImage2.SetPixel(i,j,0);
			        }
			        else{
					    
					    re=filteredImage1.GetPixel(i,j);
					    im=filteredImage1.GetPixel(i,j);
					    absolut= (Math.sqrt(re*re+im*im));
			            filteredPhase.SetPixel(i,j,0);
			            filteredImage1.SetPixel(i,j,absolut);
			            filteredImage2.SetPixel(i,j,0);
			        }			        
			        		
			    }
			}
			

            
        } //Ende if(amplitude)
        
        else {
            int a,b;
            double value,x,y;
            xPos=startX-10-radius;
            yPos=startY-160-radius;
			a = radius;
			b = radius;
			for (int i=0;i<filteredInputImage.sizeX;i++){
			    for (int j=0;j<yPos;j++){
					    filteredInputImage.SetPixel(i,j,0);
			    }
			}
			for (int i=0;i<xPos;i++){
			    for (int j=yPos;j<=yPos+radius*2;j++){
				    filteredInputImage.SetPixel(i,j,0);
			    }
			}
			if (inverseCircle){
				for (int i=0;i<=radius*2;i++){
					for (int j=0;j<=radius*2;j++){
					x=Math.abs(a-i);y=Math.abs(b-j);
						value=Math.pow(x/a,2)+Math.pow(y/b,2);
						if (value>1){
						    filteredInputImage.SetPixel(xPos+i,yPos+j,0);
						}
					}
				}
			}
		
			for (int i=0;i<filteredInputImage.sizeX;i++){
			    for (int j=yPos+radius*2;j<filteredInputImage.sizeY;j++){
				    filteredInputImage.SetPixel(i,j,0);
			    }
			}
			for (int i=xPos+radius*2;i<filteredInputImage.sizeX;i++){
			    for (int j=yPos;j<=yPos+radius*2;j++){
				    filteredInputImage.SetPixel(i,j,0);
			    }
			}
			
           
        }
        
        
    }
    
    /**
     * Realisiert den Hochpassfilter(als Kreis).
     * @see cutInverseCircleOut()
     */
    
    public void cutCircleOut(){
        int xPos,yPos;
        double absolut;
        double re,im;
        if (amplitudePicture || phasePicture){
            int a,b;
            double value,x,y;
            if(amplitudePicture){
                xPos=startX-380-radius;
                yPos=startY-20-radius;
            }
            else{
                xPos=startX-380-radius;
                yPos=startY-320-radius;
            }
 
			a = radius;
			b = radius;
			for (int i=0;i<=radius*2;i++){
					for (int j=0;j<=radius*2;j++){
					x=Math.abs(a-i);y=Math.abs(b-j);
						value=Math.pow(x/a,2)+Math.pow(y/b,2);
						if (value<=1){
							
						    if(amplitudePicture){
						        filteredAmplitude.SetPixel(xPos+i,yPos+j,0);
						        filteredImage1.SetPixel(xPos+i,yPos+j,0); 
						        filteredImage2.SetPixel(xPos+i,yPos+j,0);						    
						    }
						    else{
						        re=filteredImage1.GetPixel(xPos+i,yPos+j);
						        im=filteredImage1.GetPixel(xPos+i,yPos+j);
						        absolut= (Math.sqrt(re*re+im*im));
						        filteredImage1.SetPixel(xPos+i,yPos+j,absolut);
						        filteredPhase.SetPixel(xPos+i,yPos+j,0); 
						        filteredImage2.SetPixel(xPos+i,yPos+j,0);
						    }
							
						}
					}
				}

        }
        else {
            int a,b;
            double value,x,y;
            xPos=startX-10-radius;
            yPos=startY-160-radius;
			a = radius;
			b = radius;
			for (int i=0;i<=radius*2;i++){
					for (int j=0;j<=radius*2;j++){
						x=Math.abs(a-i);y=Math.abs(b-j);
						value=Math.pow(x/a,2)+Math.pow(y/b,2);
						if (value<=1){
							filteredInputImage.SetPixel(xPos+i,yPos+j,0);
						}
					}
				}
 
        }
    
    }
    
    /**
     * Realisiert den Hochpassfilter(als Rechteck)
     * @see cutInverseCircleOut()
     */
    
    public void cutRectOut(){
        int xPos,yPos;
        double re,im,absolut;
        if(amplitudePicture || phasePicture){
            if(amplitudePicture){
                xPos = startX-380-radius;
                yPos = startY-20-radius;
            }
            else{
                xPos=startX-380-radius;
                yPos=startY-320-radius;
            }
            for (int i=0;i<=radius*2;i++){
                for (int j=0;j<=radius*2;j++){
				    if(amplitudePicture){
				        filteredAmplitude.SetPixel(xPos+i,yPos+j,0);
				        filteredImage1.SetPixel(xPos+i,yPos+j,0); 
				        filteredImage2.SetPixel(xPos+i,yPos+j,0);						    
				    }
				    else{
				        re=filteredImage1.GetPixel(xPos+i,yPos+j);
				        im=filteredImage1.GetPixel(xPos+i,yPos+j);
				        absolut= (Math.sqrt(re*re+im*im));
				        filteredImage1.SetPixel(xPos+i,yPos+j,absolut);
				        filteredPhase.SetPixel(xPos+i,yPos+j,0); 
				        filteredImage2.SetPixel(xPos+i,yPos+j,0);
				    }
                }
            }
        }
        else{
            
            xPos = startX-10-radius;
            yPos = startY-160-radius;
            for (int i=0;i<=radius*2;i++){
                for (int j=0;j<=radius*2;j++){
                    filteredInputImage.SetPixel(xPos+i,yPos+j,0);
                  }
            }
     
        }
    }
    
    
    
    /**
     * Zieht eine Linie durch das jeweils zu bearbeitende Bild.
     * Handelt es sich hierbei um Phase oder Amplitude,wird zusaetzlich
     * die Methode setPointsOnline(..) aufgerufen,um fuer jeden Punkt auf dieser
     * Geraden in der komplexen Ebene Real-und Imaginaerteil neu zu bestimmen.
     */
    
    public void cutLineOut() {
        int value1,value2;
        value1=(int)filteredAmplitude.GetPixel(filteredAmplitude.GetMax());
        value2=(int)filteredPhase.GetPixel(filteredPhase.GetMax());
        if(value1==0 && value2==0){
            value1=255;value2=255;
        }
        if(amplitudePicture){

            this.setPointsOnLine(startX-380,startY-20,endX-380,endY-20);
            filteredAmplitude.drawLineWithConstantValue(startX-380,startY-20,endX-380,endY-20,255);
     
        }
        else if(phasePicture){
    
            this.setPointsOnLine(startX-380,startY-320,endX-380,endY-320);
            filteredPhase.drawLineWithConstantValue(startX-380,startY-320,endX-380,endY-320,255);
            
        }
        else {
            filteredInputImage.drawLineWithConstantValue(startX-10,startY-160,endX-10,endY-160,255);
        }
    }
    
    /**
     * Das Bild wird mit der Rate der
     * Variablen sRate abgetastet.Die Abtastung
     * wird dadurch simuliert,dass nur jeder
     * (sRate-)te Pixel erhalten bleibt.
     */
    
    public void sampleImage() {
	    String rate=(String)JOptionPane.showInputDialog(this,"please choose sample rate","sample rate",
	                JOptionPane.QUESTION_MESSAGE,dialogIcon,sampling,sampling[0]);
	    if(rate !=null){
	        getSampleRate(rate);
	        filteredInputImage=new iRPImage(A.sizeX,A.sizeY);
	        int value;
	        for (int i=0;i<A.sizeX;i+=sRate){
	            for(int j=0;j<A.sizeY;j+=sRate){
	                value=A.GetPixel(i,j);
	                filteredInputImage.SetPixel(i,j,value);
	            }
	        }

	        this.manipulateInputImage();
	    }
 
    }
    
    /**
     * Wird mit der Maus einmal auf ein  transformiertes Bild
     * geklickt, so werden eventuelle Manipulationen
     * rueckgaengig gemacht.
     */
    
    public void resetTransformedImages() {
        amplitude.resetImportantFlags();
        phase.resetImportantFlags();
        cutedOut=false;
        amplitude.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        phase.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        input.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        amplitude.changeImage(B);
        phase.changeImage(C);
		temp3=temp1.copy();
		temp4=temp2.copy();
		ft.fft2D(temp3,temp4,false);
	    D=temp3.makeiRPImage();   
	    output.changeImage(D);       
        repaint();
    }
    
    /**
     * @see resetTransformedImages()
     */
    
    public void resetInputImage() {
        input.resetImportantFlags();
        cutedOut=false;
        input.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        amplitude.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        phase.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
 		D1=A.makedoubleiRPImage();
		D2.Clear(0);
		ft.fft2D(D1,D2,true);
		temp1 = D1.copy();
		temp2 = D2.copy();
		Rect2PolarInplace(D1,D2,true);
		B = D1.makeiRPImage();
		C = D2.makeiRPImage();   		
		temp3=temp1.copy();
		temp4=temp2.copy();
		ft.fft2D(temp3,temp4,false);
	    D=temp3.makeiRPImage();
	    input.changeImage(A);
	    amplitude.changeImage(B);
	    phase.changeImage(C);
	    output.changeImage(D);
	    repaint();
        
    }
    
    /**
     * Neuer Aufbau der Oberflaeche,alle
     * Veraenderungen an den Bildern werden 
     * rueckgaengig gemacht.
     */
    public void resetScreen() {
    	B.Clear(0);
    	C.Clear(0);
    	D.Clear(0);
    	temp1.Clear(0);
    	temp2.Clear(0);
  		D1=A.makedoubleiRPImage();
   		D2.Clear(0);
   		ft.fft2D(D1,D2,true);
   		temp1 = D1.copy();
   		temp2 = D2.copy();
   		Rect2PolarInplace(D1,D2,true);
   		B = D1.makeiRPImage();
   		C = D2.makeiRPImage();
   		temp3=temp1.copy();
   		temp4=temp2.copy();
   		ft.fft2D(temp3,temp4,false);
   	    D=temp3.makeiRPImage();
 	    input.changeImage(A);
	    amplitude.changeImage(B);
	    phase.changeImage(C);
	    output.changeImage(D);	    
        amplitude.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        phase.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        input.setCircleOrRectCoordinates(0,0,0,0,Color.BLACK);
        
        if (chooseCordSystem){
            this.drawCoordinateSystems(true);
        }
        else {
            this.drawCoordinateSystems(false);
        }
        

		filteredImage1 = temp1.copy();
		filteredImage2 = temp2.copy();
        filteredAmplitude=B.copy(); 
        filteredPhase=C.copy();
        filteredInputImage=A.copy();
	    repaint();
	    
	    
    }
    
 /**
  * Diese Methode wird aufgerufen,wenn eine Linie durch das Phasen-oder
  * Amplitudenbild gezogen werden soll. Bei der Amplitude wird fuer jeden Punkt 
  * in der komplexen Ebene der Betrag maximal gesetzt. Entsprechend muesen 
  * Real-und Imaginaerteil neu berechnet werden.
  * Bei der Phase wird diese fuer jeden Punkt auf der Geraden maximal, was 
  * z.B. 2*PI entspricht. Da sinus und cosinus 2*PI-periodisch sind,
  * wird dem Realteil der Betrag zugewiesen,bzw. der Imaginaerteil auf
  * null gesetzt.
  * @param a1 x-Koordinate des Startpunktes
  * @param b1 y-Koordinate des Startpunktes
  * @param a2 x-Koordinate des Zielpunktes
  * @param b2 y-Koordinate des Zielpunktes
  */
    
    public void setPointsOnLine(int a1,int b1,int a2,int b2){
      	double a,b,delta;
      	double phase,re,im;
      	double absolut=filteredAmplitude.GetPixel(filteredAmplitude.GetMax());
      	if(absolut==0) absolut=255;
    	//System.out.println("("+a1+","+b1+") ("+a2+","+b2);
      	if(Math.abs(b2-b1)<Math.abs(a2-a1))
      	{
    		if(a1>a2) delta=-1;
    		else delta=1;
      		for(a = a1; a != a2+delta; a+=delta)//for(a = a1; a < a2; a++)
        	{
    			b = (double)b1 + ((double)(b2-b1)* ((double)a-(double)a1)/((double)a2-(double)a1));
    			//Die Abfrage ist zufllig wegen ArrayindexofBoundexception!!
    			if(((int)b != A.sizeY) && ((int)a !=A.sizeX))
    			{
    			    if(amplitudePicture){
        			    phase=Math.toRadians(filteredPhase.GetPixel((int)a,(int)b));
        				filteredImage1.SetPixel((int)a,(int)b,absolut*Math.cos(phase));
        				filteredImage2.SetPixel((int)a,(int)b,absolut*(-1)*Math.sin(phase)); 
    			    }
    			    else{
    			        re=filteredImage1.GetPixel((int)a,(int)b);
    			        im=filteredImage2.GetPixel((int)a,(int)b);
    			        absolut=Math.sqrt(re*re+im*im);
    			        filteredImage1.SetPixel((int)a,(int)b,absolut);
    			        filteredImage2.SetPixel((int)a,(int)b,0);
    			    }

    			}
    		}
    	}
      	else
      	{

    		if (b1>b2) delta=-1;
    		else delta=1;
         	for(b = b1; b != b2+delta; b+=delta)
         	{
    			a =(double)a1 + ((double)(a2-a1)* ((double)b-(double)b1)/((double)b2-(double)b1));
    			if((int)b != A.sizeY && ((int)a != A.sizeX))
    			{
    			    if(amplitudePicture){
        			    phase=Math.toRadians(filteredPhase.GetPixel((int)a,(int)b));
        				filteredImage1.SetPixel((int)a,(int)b,absolut*Math.cos(phase));
        				filteredImage2.SetPixel((int)a,(int)b,absolut*(-1)*Math.sin(phase)); 
    			    }
    			    else{
    			        re=filteredImage1.GetPixel((int)a,(int)b);
    			        im=filteredImage2.GetPixel((int)a,(int)b);
    			        absolut=Math.sqrt(re*re+im*im);
    			        filteredImage1.SetPixel((int)a,(int)b,absolut);
    			        filteredImage2.SetPixel((int)a,(int)b,0);
    			    }
    			}
       		}
      	}
    }
    
    /**
     * Die Methode setzt die Punkte in das Bild, wenn das Tool 'Punkt'
     * gewaehlt wurde. 
     * Die Methode wird von mouseClicked(..) aufgerufen.
     * Bei der Amplitude wird der Betrag auf max gesetzt,bzw. bei 
     * der Phase der Winkel auf 2*PI(oder 0) gesetzt und entsprechend
     * Real-und Imaginaerteil neu gesetzt.
     * @param x die x-Koordinate der Maus
     * @param y die y-Koordinate der Maus
     */
    
    public void drawPoint(int x,int y){
        int xPos=x;
        int yPos=y;
        double absolut,re,im;
        double phase;
        absolut= filteredAmplitude.GetPixel(filteredAmplitude.GetMax());
        
        if(absolut==0){
            absolut=255;
            
        }
        if(inputPicture){
            filteredInputImage.SetPixel(xPos-10,yPos-160,255);
            setPixelMirror(xPos-10,yPos-160,filteredInputImage);
            manipulateInputImage();
     
        }
        else if(amplitudePicture){
            phase=filteredPhase.GetPixel(xPos-380,yPos-20);
            phase=Math.toRadians(phase);
            filteredAmplitude.SetPixel(xPos-380,yPos-20,255);
            setPixelMirror(xPos-380,yPos-20,filteredAmplitude);
            
            filteredImage1.SetPixel(xPos-380,yPos-20,absolut*Math.cos(phase));
            filteredImage2.SetPixel(xPos-380,yPos-20,absolut*(-1)*Math.sin(phase));
            setPixelMirror(xPos-380,yPos-20);
            manipulateTransformedImage();
        }
        else if(phasePicture){
           phase=Math.PI*2;
           re=filteredImage1.GetPixel(xPos-380,yPos-320);
           im=filteredImage2.GetPixel(xPos-380,yPos-320);
           absolut=Math.sqrt(re*re+im*im);
           filteredPhase.SetPixel(xPos-380,yPos-320,255);
           filteredImage1.SetPixel(xPos-380,yPos-320,absolut);
           filteredImage2.SetPixel(xPos-380,yPos-320,0);
           setPixelMirror(xPos-380,yPos-320);
           manipulateTransformedImage();
        }
        
        
        
    }
    
    /**
     * Liefert den Radius des Kreises um den 
     * Vektor (x,y).
     */
    public int getRadius(int x,int y){
        double r;  
        r = Math.sqrt(x*x+y*y);
        return (int)r;
    }
    
    /**
     * Ist die Maus ueber dem Amplituden Bild?
     * @param x x-Koordinate des Punktes
     * @param y y-Koordinate des Punktes
     */
    
    public boolean mouseOverAmplitudePicture(int x,int y){
        
        if (x>=380 && x<380+B.sizeX && y>=20 && y<20+B.sizeY) return true;
        else return false;
    }
    
    
    /**
     * Ist die Maus ueber dem Eingangs Bild?
     * @param x x-Koordinate des Punktes
     * @param y y-Koordinate des Punktes
     */
    
    public boolean mouseOverInputPicture(int x,int y){
        if (x>=10 && x<10+A.sizeX && y>=160 && y<160+A.sizeY) return true;
        else return false;
        
    }
    
    /**
     * Ist die Maus ueber dem Phasen Bild?
     * @param x x-Koordinate des Punktes
     * @param y y-Koordinate des Punktes
     */
    public boolean mouseOverPhasePicture(int x,int y){
        if (x>=380 && x<380+C.sizeX && y>=320 && y<320+C.sizeY) return true;
        else return false;
    }
    
    /**
     * Ist die Maus ueber dem Ausgangs Bild?
     * Die Methode wird z.Z. nicht gebraucht.
     * @param x x-Koordinate des Punktes
     * @param y y-Koordinate des Punktes
     */
    
    public boolean mouseOverOutputPicture(int x,int y){
        if (x>=760 && x<760+C.sizeX && y>=160 && y<160+C.sizeY) return true;
        else return false;
    }
    
    /**
     *Ist der 'Point'-Operator aktiv,wird ein
     *Komplexes Punktpaar in das entsprechende Bild gesetzt.
     */   

    public void mouseClicked(MouseEvent e) {
        
        amplitudePicture = mouseOverAmplitudePicture(e.getX(),e.getY());
        phasePicture=mouseOverPhasePicture(e.getX(),e.getY());
        inputPicture=mouseOverInputPicture(e.getX(),e.getY());
 
            int xPos=e.getX();
            int yPos=e.getY();
            if(point)
              drawPoint(xPos,yPos);
        

     }

    public void mouseEntered(MouseEvent e) {
        
        
    }

    public void mouseExited(MouseEvent e) {
       
        
    }

    public void mousePressed(MouseEvent e) {

    }
    
 /**
  * FirstMousePress wird auf 'true' gesetzt um ein
  * erneutes Zeichnen zu ermoeglichen. Dann wird
  * die cut-Methode aufgerufen,welche die Operation
  * durchfuehrt.
  */
    public void mouseReleased(MouseEvent e){
        firstMousePress=true;
        /*
         * Mit den geschachtelten if-Abfragen wird sichergestellt,dass
         * der Radius des Kreises,bzw. das Rechteck nicht ueber den Rand
         * des Bildes hinausgeht.
         * Die Abfrage startX>0.. ist noetig,da bei einem mouse click diese
         * Methode ebenfalls aufgerufen wird. Wird z.b. irgendwo eine Linie
         * eingezeichnet,dann der reset-button gedrueckt und anschieend 
         * wieder irgendwo ins Bild geklickt wird die alte Linie nochmal
         * eingezeichnet,da sich die Variablen startX,startY etc. noch
         * nicht veraendert haben. Dies wird mit dieser Abfrage verhindert,da
         * startX bzw. startY am Ende auf null gesetzt werden.
         */
        if(startX>0 && startY>0){
            if(!(point || line)){
                if(amplitudePicture){
                    if(startX-380-radius >=0 && startX-380+radius<B.sizeX && startY-20-radius >=0 && startY-20+radius<B.sizeY) 
                        cut();
                }
                else if(phasePicture){
                    if(startX-380-radius >=0 && startX-380+radius<B.sizeX && startY-320-radius >=0 && startY-320+radius<B.sizeY)
                        cut();
                }
                else if(inputPicture){
                    if(startX-10-radius>=0 && startX-10+radius<A.sizeX && startY-160-radius>=0 && startY-160+radius<A.sizeY)
                        cut();
                }
            }
            else
               cut();
            startX=0;startY=0;
        }

     }
    
     /**
     * Abhaengig von Bild und Tool werden die entsprechenden flags in den
     * ImageWindow Objekten gesetzt um die entsprechenden geometrischen
     * Figuren  zu zeichen.
     * Beim erstem Mausklick(firstMousePress) wird stets eine Kopie von den 
     * originalen Bildern angefertigt um diese wieder rekonstruieren zu koennen.
     * Die Abfrage if(!point) ist noetig,da diese Methode bei dem Tool 'Punkt' in-
     * aktiv sein soll.
     * 
     */

    public void mouseDragged(MouseEvent e) {
        
        amplitudePicture = mouseOverAmplitudePicture(e.getX(),e.getY());
        phasePicture=mouseOverPhasePicture(e.getX(),e.getY());
        inputPicture=mouseOverInputPicture(e.getX(),e.getY());
        if (!point){
            if ((amplitudePicture || phasePicture)){
                
                           if (firstMousePress){
                               amplitude.resetImportantFlags();
                               phase.resetImportantFlags();
                               startX=e.getX();
                               startY=e.getY();
                               firstMousePress=false;
                           
 
               				if (circle || inverseCircle){
               		           amplitude.setCircleFlag(true);
               		           phase.setCircleFlag(true);
               				}
               				else if(rect || inverseRect){
               		               amplitude.setRectFlag(true);
               		               phase.setRectFlag(true);
               				}
               				else if(line){
               		               amplitude.setLineFlag(true);
               		               phase.setLineFlag(true);
               				}
                           }
                           radius=getRadius(e.getX()-startX,e.getY()-startY);
                           width=Math.abs(e.getX()-startX);
                           height=Math.abs(e.getY()-startY);

                
                           if (!line){
                               if (amplitudePicture){ //Dann pruefen,ob der Radius nicht ueber das Bild hinaus geht.
                                   if(startX-380-radius >=0 && startX-380+radius<B.sizeX && startY-20-radius >=0 && startY-20+radius<B.sizeY){
                                       amplitude.setCircleOrRectCoordinates(startX-radius,startY-radius,radius*2,radius*2,Color.BLACK);
                                       phase.resetImportantFlags();
                       
                                   }
                          
                                   repaint();
                               }
                               else{ //Dann pruefen,ob der Radius nicht ueber das Bild hinaus geht.
                                   if(startX-380-radius >=0 && startX-380+radius<B.sizeX && startY-320-radius >=0 && startY-320+radius<B.sizeY){
                                       phase.setCircleOrRectCoordinates(startX-radius,startY-radius,radius*2,radius*2,Color.GRAY);
                                       amplitude.resetImportantFlags();
                                       
                                   }
                         
                                  repaint();
                               }
                           }
                           else {
                               if(amplitudePicture){
                                   amplitude.setLineCoordinates(startX,startY,e.getX(),e.getY(),Color.YELLOW);
                                   phase.setLineFlag(false);
                                   endX=e.getX();endY=e.getY();
                                   repaint();
                               }
                               else {
                                   phase.setLineCoordinates(startX,startY,e.getX(),e.getY(),Color.YELLOW);
                                   amplitude.setLineFlag(false);
                                   endX=e.getX();endY=e.getY();
                                   repaint();
                               }
                            }
                       }
                       else if (inputPicture){
                
                           if (firstMousePress){
                               input.resetImportantFlags();
                               startX=e.getX();
                               startY=e.getY();
                               firstMousePress=false;
                           
                               
                               if (circle || inverseCircle ){
                                   input.setCircleFlag(true);
                    
                                }

                               else if (rect || inverseRect){
                                   input.setRectFlag(true);
                    
                               }
                               else if(line){
                                   input.setLineFlag(true);
                               }
                            }
                           radius=getRadius(e.getX()-startX,e.getY()-startY);
                           width=Math.abs(e.getX()-startX);
                           height=Math.abs(e.getX()-startX);
                           
                
                           if (!line){
                               if(startX-10-radius>=0 && startX-10+radius<A.sizeX && startY-160-radius>=0 && startY-160+radius<A.sizeY){
                                   input.setCircleOrRectCoordinates(startX-radius,startY-radius,radius*2,radius*2,Color.BLACK); 
                               }
                 
                               repaint(); 
                           }
                           else {
                               input.setLineCoordinates(startX,startY,e.getX(),e.getY(),Color.YELLOW);
                               endX=e.getX();endY=e.getY();
                               repaint();
                           }
                        } //Ende if(inputPicture)
        
        }
     }
    

    /**
     * Wird die Maus ber die Bilder bewegt werden die 
     * Koordinaten bzw. der Grauwert angezeigt.
     */
    public void mouseMoved(MouseEvent e) {
        int v;
        if(mouseOverInputPicture(e.getX(),e.getY())){
            v=(input.img).GetPixel(e.getX()-10,e.getY()-160);
            input.updateMousePosition(e.getX()-10,e.getY()-160,v);
        }
        if(mouseOverAmplitudePicture(e.getX(),e.getY())){
            v=(amplitude.img).GetPixel(e.getX()-380,e.getY()-20);
            amplitude.updateMousePosition(e.getX()-380,e.getY()-20,v);
        }
        if(mouseOverPhasePicture(e.getX(),e.getY())){
            v=(phase.img).GetPixel(e.getX()-380,e.getY()-320);
            phase.updateMousePosition(e.getX()-380,e.getY()-320,v);
        }
        if(mouseOverOutputPicture(e.getX(),e.getY())){
            v=(output.img).GetPixel(e.getX()-760,e.getY()-160);
            output.updateMousePosition(e.getX()-760,e.getY()-160,v);
        }
        repaint();
        
    }

}
