package FFT;
import javax.swing.*;
import java.awt.*;

/**
 * Diese Klasse stellt das Panel dar,auf dem
 * die Bilder ausgegeben werden.
 * Die ImageWindow Objekte werden hier neu gezeichnet.
 * @author Rene Iser, Behrang Karimibabak, Simon Winkelbach
 */

public class fftViewer extends JPanel {
    
    ImageWindow input,amplitude,phase,output;
    Font hintergrund; 
    fftViewer(ImageWindow A,ImageWindow B,ImageWindow C,ImageWindow D){
        setLayout(null);
        this.input=A;
        this.amplitude=B;
        this.phase=C;
        this.output=D;
        hintergrund=new Font("Helvetica",10,14);
    }
    
    /**
     *Zeichnet neben den Bildern
     *auch den Hintergrund des fft Applets.
     */
    
    public void paintComponent(Graphics g){
        super.paintComponent(g);
        input.paintComponent(g);
        amplitude.paintComponent(g);
        phase.paintComponent(g);
        output.paintComponent(g);
        
        /*
         *        \
         *    ----
         *    |   /
         *    |
         * ---
         *    |
         *    |  \
         *    ---
         *       /
         */
        g.drawLine(270,295,320,295);//1.Horizontale
        g.drawLine(320,295,320,195);//obere Vertikale
        g.drawLine(320,295,320,395);//untere Vertikale
        g.drawLine(320,195,375,195);//obere Horizontale
        g.drawLine(320,395,375,395);//untere Horizontale
        g.drawLine(375,195,365,185);//obere Pfeilspitze (i)
        g.drawLine(375,195,365,205);//obere Pfeilspitze(ii)
        g.drawLine(375,395,365,385);//untere Pfeilspitze (i)
        g.drawLine(375,395,365,405);//untere Pfeilspitze (ii)
        g.setFont(hintergrund);
        g.drawString("FFT",330,300);
        
        /*
         * ---
         *    |   \
         *    |---
         *    |   /
         * ---
         */
        
        g.drawLine(641,195,706,195); //obere Horizontale
        g.drawLine(641,395,706,395); //untere Horizontale
        g.drawLine(706,195,706,395); //vertikale
        g.drawLine(706,295,755,295); // mittlere Horizontale
        g.drawLine(755,295,745,285); //Pfeilspitze (i)
        g.drawLine(755,295,745,305); //Pfeilspitze (ii)
        g.drawString("1/FFT",660,300);
        

    }
    

}
