
package Histogram;

/**
 * Diese Klasse erfuellt drei Funktionen
 * Zum einen werden hier die Histogramme erstellt.Dann koennen die
 * Bilder neu skaliert werden. Die dritte Funktionialitt berechnet
 * die kumulative Verteilungsfunktion.
 * 
 * @author Rene Iser, Simon Winkelbach
 *
 */
public class HistogramGenerator {

    
    protected int[] grayValueFunction;
    protected int[] histogramData;
    protected int[] normalizedData,scaleFunction;
    HistogramGenerator(int[] gvF,int[] hD){
        this.grayValueFunction=gvF;
        this.histogramData=hD;
        normalizedData=new int[256];
        scaleFunction=new int[256];
        this.initializeFunction();
    }
    
    /**
     * Erstellen des Histogramms fuer ein Bild.
     * Das Histogramm selbst wird wieder in einem Bild gespeichert.
     * Bevor die Histogrammdaten in das Bild eingetragen werden,
     * werden diese noch durch den Aufruf von normalizeHistogram()
     * normalisiert.
     * @param input  Bild fuer welches das Histogramm erstellt werden soll
     * @param histogram Bild in welchem das Histogramm dargestellt werden soll. 
     */
    public void generateHistogram(iRPImage input,iRPImage histogram){
        int value=0;
        for(int i=0;i<256;i++){
            histogramData[i]=0;
        }
        
            for (int x=0;x<input.sizeX;x++){
                for(int y=0;y<input.sizeY;y++){
                    histogramData[input.GetPixel(x,y)] +=1;
                }
            }
      
        normalizeHistogram();
        for (int i=0;i<256;i++){
            value=normalizedData[i];
            histogram.drawLineWithConstantValue(i,input.sizeY,i,input.sizeY-value,0);
        }
        
    }
    
    /**
     * Berechnet aus den aktuellen Histogrammdaten die kumulative
     * Verteilungsfunktion.
     * @param cum Array in welchem die kumulative Verteilungsfunktion gespeichert
     * werden soll.
     */
    public void generateCumulativeDistributionFunction(int[] cum){
        
        for(int i=0;i<256;i++){
            cum[i]=0;
        }
        
        for(int i=0;i<256;i++){
            for(int j=0;j<=i;j++){
                cum[i]+= histogramData[j];
            }
            
        }
        normalizeCumulativeFunction(cum);
        
    }
    
    /**
     * Berechnet an Hand der Skalierungsfunktion grayValueFunction
     * die Bilddaten neu. Da in grayValueFunction nur die 
     * Stuetzpunkte definiert sind aber die Zwischenwerte fehlen,werden 
     * diese durch den Aufruf von makeScaleFunction(..) berechnet.
     * Alle Punkte der Funktion werden in dem Array scaleFunction gespeichert.
     * 
     * @param imageToScale Bild welches skaliert werden soll.
     */
    public void scaleImage(iRPImage imageToScale){
        int startX=0;
        int startY=255;
        int endX,endY,oldValue,newValue;
        for (int x=1;x<256;x++){
            
            if(grayValueFunction[x]> -1){
                endX=x;endY=grayValueFunction[x];
                this.makeScaleFunction(startX,startY,endX,endY);
                startX=x;
                startY=grayValueFunction[x];
            }
            
        }
        scaleFunction[0]=0;
        for(int x=0;x<256;x++){
            for(int y=0;y<255;y++){
                oldValue=imageToScale.GetPixel(x,y);
                newValue=scaleFunction[oldValue];
                imageToScale.SetPixel(x,y,newValue);
            }
        }
        
    }
    
    /**
     * Diese Funktion bekommt zwei Stuetzpunkte von grayValueFunction 
     * uebergeben und berechnet jeden Punkt auf der Geraden zwischen diesen
     * Punkten,um so die komplette Skalierungsfunktion in scaleFunction
     * speichern zu koennen. Da alle Werte in grayValueFunction so gespeichert 
     * sind,dass die Funktion korrekt vom HistogramViewer gezeichnet werden kann,
     * muss der jeweilige Funktionswert von 255 abgezogen werden.
     * Soll z.B. ein Punkt der Funktion mit dem Funktionswert 0 optisch 
     * dargestellt werden,wird dieser am unteren Rand des Bildes eingezeichnet,muss
     * daher also tatsaechlich den Wert 255 bekommen.Deswegen diese Umrechnung.
     * @param a1 x-Koordinate des ersten Stuetzpunktes
     * @param b1 y-Koordinate des ersten Stuetzpunktes
     * @param a2 x-Koordinate des zweiten Stuetzpunktes
     * @param b2 y-Koordinate des ersten Stuetzpunktes
     */
    public void makeScaleFunction(int a1,int b1,int a2,int b2){
      	double a,b,delta;

    	//System.out.println("("+a1+","+b1+") ("+a2+","+b2);
      	if(Math.abs(b2-b1)<Math.abs(a2-a1))
      	{
    		if(a1>a2) delta=-1;
    		else delta=1;
      		for(a = a1; a != a2+delta; a+=delta)//for(a = a1; a < a2; a++)
        	{
    			b = (double)b1 + ((double)(b2-b1)* ((double)a-(double)a1)/((double)a2-(double)a1));
    			//Die Abfrage ist zufllig wegen ArrayindexofBoundexception!!
    			if(((int)b != 256) && ((int)a !=256))
    			{  
    				scaleFunction[(int)a]=255-(int)b;
    			}
    		}
    	}
      	else
      	{

    		if (b1>b2) delta=-1;
    		else delta=1;
         	for(b = b1; b != b2+delta; b+=delta)
         	{
    			a =(double)a1 + ((double)(a2-a1)* ((double)b-(double)b1)/((double)b2-(double)b1));
    			if((int)b != 256 && ((int)a != 256))
    			{  
      				scaleFunction[(int)a]=255-(int)b;
    			}
       		}
      	}
    }
    
    /**
     * Normaliesiert die Histogrammdaten auf
     * 0..128 und speichert das Ergebnis in 
     * normalizedData.
     */
    public void normalizeHistogram(){
        int max=getMax(histogramData);
        int min=getMin(histogramData);
        for (int i=0;i<256;i++){
            normalizedData[i]=((histogramData[i]-min)*128)/(max-min);
        }
    }
    
    /**
     * Normalisiert die Werte der kumulativen Verteilungsfunktion
     * auf 0..255 
     * @param cum kumulative Verteilungsfunktion, welche normalisiert werden soll
     */
    public void normalizeCumulativeFunction(int[] cum){
        int max=getMax(cum);
        int min=getMin(cum);
        for (int i=0;i<256;i++){
            cum[i]=((cum[i]-min)*255)/(max-min);
        }
    }
    
    /**
     * Liefert das Maximum eines Arrays
     * @param array das Array fuer welches das Maximum gesucht wird
     * @return int das Maximum
     */
    public int getMax(int[] array){
        int max=array[0];
        for(int i=1;i<256;i++){
            if(array[i]>max){
                max=array[i];
            }
        }
        return max;
    }
    
    /**
     * Liefert das Minimum eines Arrays
     * @param array das Array fuer welches das Minimum gesucht wird
     * @return int das Minimum
     */
    public int getMin(int[] array){
        int min=array[0];
        for(int i=1;i<256;i++){
            if(array[i]<min){
                min=array[i];
            }
        }
        return min;
    }
    /**
     * Initialisiert grayValueFunction neu,so dass
     * die Funtion die Identitaet ergibt.
     *
     */
    public void initializeFunction(){
        for(int i=0;i<grayValueFunction.length;i++){
            grayValueFunction[i]=-1;   
        }
        grayValueFunction[0]=255;
        grayValueFunction[255]=0;
    }
    
    
}
