package Histogram;

import javax.swing.*;
import java.awt.*;

/**
 * Mit Hilfe dieser Klasse werden die Bilder,deren
 * Histogramme und kumulativen Verteilungsfunktionen 
 * auf der Oberflaeche ausgegeben.
 * @author Rene Iser, Simon Winkelbach
 *
 */
public class histogramViewer extends JPanel{
    int[] grayValueFunction,inputCumulativeFunction,scaledCumulativeFunction;
    int[] userDefCumPoints;
    int startX,startY,endX,endY;
    boolean drawCumFunction=false;
    ImageWindow histogram,input,scaledInput,scaledHistogram;
    histogramViewer(ImageWindow histogram,ImageWindow input,ImageWindow scaledInput,ImageWindow scaledHistogram,int[] gvF,int[] icF,int[] scF){
        this.histogram=histogram;
        this.input=input;
        this.grayValueFunction=gvF;
        this.scaledInput=scaledInput;
        this.inputCumulativeFunction=icF;
        this.scaledCumulativeFunction=scF;
        this.scaledHistogram=scaledHistogram;
        this.userDefCumPoints=new int[256];
    }
    
    /**
     * Von hier werden die Methoden zum Zeichnen 
     * der verschiedenen Komponenten aufgerufen.
     * Ist die Skalierungsfunktion gleich der kumulativen 
     * Verteilungsfunktion,ist 'drawCumFunction' gleich 'true'
     * und eventuelle vom User definierten Stuetzpunkte werden
     * markiert.
     */
    public void paintComponent(Graphics g){
        super.paintComponent(g);
        histogram.paintComponent(g);
        input.paintComponent(g);
        scaledInput.paintComponent(g);
        scaledHistogram.paintComponent(g);
        paintScaleFunction(g); 
        paintInputCumulativeFunction(g);
        paintScaledCumulativeFunction(g);
        if(drawCumFunction)
            paintUserDefCumPoints(g);
    }
    
    /**
     * Zeichnet die blaue Skalierungsfunktion ein.
     * Ist 'drawCumFunction' gleich 'true' 
     * werden die Stutzpunkte der Funktion nicht mit
     * ausgegeben.
     * @param g
     */
    public void paintScaleFunction(Graphics g){
        startX=0;
        startY=255;
        g.drawRect(startX+318,startY+18,5,5);
        g.setColor(Color.BLUE);
        for (int i=1;i<256;i++){
            
            if(grayValueFunction[i]> -1){
                
                endX=i;endY=grayValueFunction[i];
                g.setColor(Color.BLACK);
                if(!drawCumFunction){
                    g.drawRect(startX+318,startY+18,5,5);
                } 
                g.setColor(Color.BLUE);
                g.drawLine(startX+320,startY+20,endX+320,endY+20);
                startX=i;
                startY=grayValueFunction[i];
            }
 
           
        }
        g.setColor(Color.BLACK);
       g.drawRect(255+318,18,5,5);
    }
    
    /**
     * Zeichnet vom Benutzer neu definierten Stuetzpunkte
     * der in die Funktion ein.
     * @param g
     */
    public void paintUserDefCumPoints(Graphics g){
        g.setColor(Color.BLACK);
        for(int i=0;i<256;i++){
            if(userDefCumPoints[i]>-1)
            g.drawRect(i+318,userDefCumPoints[i]+18,5,5);
        }
    }
    
    /**
     * Zeichnet die kumulative Verteilungsfunktion
     * des Eingangsbildes.
     * @param g
     */
    public void paintInputCumulativeFunction(Graphics g){
        int x1,y1,x2,y2;
        g.setColor(Color.WHITE);
        g.fillRect(620,20,256,256);
 
        g.setColor(Color.RED);
        for(int i=0;i<255;i++){
            x1=i;x2=i+1;
            y1=this.inputCumulativeFunction[i];
            y2=this.inputCumulativeFunction[i+1];
            g.drawLine(x1+620,275-y1,x2+620,275-y2);
        }
        
        g.setColor(Color.BLACK);
        g.drawLine(620,20,620,276);
        g.drawLine(620,276,875,276);
        g.drawLine(619,20,619,277);
        g.drawLine(619,277,875,277);
        //////////////////////////////
        g.drawLine(619,20,609,30);
        g.drawLine(619,20,629,30);
        g.drawLine(618,20,608,30);  // Obere Pfeilspitze
        g.drawLine(620,20,630,30);
        /////////////////////////////
        g.drawLine(875,277,865,287);
        g.drawLine(876,277,866,287);
        g.drawLine(875,276,865,266); //untere Pfeilspitze
        g.drawLine(876,276,866,266);
        g.setFont(new Font("helvetice",1,16));
        g.drawString("H(i)",630,45);
        g.drawString("i",855,271);
        
    }
    
    /**
     * Zeichnet die kumulative Verteilungsfunktion
     * des Ausgangsbildes.
     * @param g
     */
    public void paintScaledCumulativeFunction(Graphics g){
        int x1,y1,x2,y2;
        g.setColor(Color.WHITE);
        g.fillRect(620,330,256,256);
        g.setColor(Color.GREEN);
        for(int i=0;i<255;i++){
            x1=i;x2=i+1;
            y1=this.scaledCumulativeFunction[i];
            y2=this.scaledCumulativeFunction[i+1];
            g.drawLine(x1+620,585-y1,x2+620,585-y2);
        }
 
        g.setColor(Color.BLACK);
        g.drawLine(620,330,620,586);
        g.drawLine(620,586,876,586);
        g.drawLine(619,330,619,586);
        g.drawLine(619,587,876,587);
        ///////////////////////////
        g.drawLine(619,330,609,340);
        g.drawLine(618,330,608,340); //Obere Pfeilspitze
        g.drawLine(620,330,630,340);
        g.drawLine(621,330,631,340);
        ///////////////////////////
        g.drawLine(876,586,866,576);
        g.drawLine(876,585,866,575);
        g.drawLine(876,587,866,597); // Untere Pfeilspitze
        g.drawLine(876,588,866,598);
        g.setFont(new Font("helvetice",1,16));
        g.drawString("H(i)",630,355);
        g.drawString("i",855,581);
        
    }
    
    /**
     * Gibt an ob die Stuetzpunkte der Skalierungs-
     * funktion mit eingezeichnert werden sollen
     * oder nicht.
     * @param cum wenn cum auf 'true' gesetzt wird werden die Stuetzpunkte nicht eingezeichnet.
     */
    public void setDrawCumFunction(boolean cum){
        this.drawCumFunction=cum;
    }
    
    /**
     * Reset des Arrays mit den user defined Stuetzpunkten
     * der kumulativen Verteilungsfunktion
     *
     */
    public void initializeUserDefCumPoints(){
        for(int i=0;i<256;i++){
            this.userDefCumPoints[i]=-1;
        }
    }
    
 
    
}
