package JSci.swing;

import java.awt.*;
import javax.swing.*;

/**
* The JDoubleBufferedComponent class provides double buffering functionality.
* Painting events simply cause the offscreen buffer to be painted.
* It is the responsibility of sub-classes to explicitly update the offscreen buffer.
* The offscreen buffer can be updated in two ways.
* <ol>
* <li>Override the {@link #offscreenPaint(Graphics) offscreenPaint} method and use the {@link #redraw() redraw} method. Passive rendering.</li>
* <li>Draw to the graphics context returned by the {@link #getOffscreenGraphics() getOffscreenGraphics} method and use the {@link java.awt.Component#repaint() repaint} method. Active rendering.</li>
* </ol>
* The first way alone should be sufficient for most purposes.
* @version 1.3
* @author Mark Hale
*/
public abstract class JDoubleBufferedComponent extends JPanel {
        public final void paintComponent(Graphics g) {
			super.paintComponent(g);
			offscreenPaint(g);
		}

        public final void redraw() {
                repaint();
        }

        protected abstract void offscreenPaint(Graphics g);
}

