package fr.ensea.chart;

import java.awt.Color;

/**
 * Must be implemented by any data structure that has to be displayed in a Plot2D viewer 
 */
public interface Curve2D {
	
	/** used by getMin() and getMax() methods */
	static final int X_AXIS=0;
	
	/** used by getMin() and getMax() methods */
	static final int Y_AXIS=1;

	/**
	 * Returns the ith point
	 */
	Point2D getPoint(int i);
	
	/**
	 * Returns the number of points
	 */
	int getNbPoints();
	
	/**
	 * Returns the minimum on the given axis, either X_AXIS or Y_AXIS
	 */
	double getMin(int axis);
	
	/**
	 * Returns the maximum on the given axis, either X_AXIS or Y_AXIS
	 */
	double getMax(int axis);
	
}
