/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2004  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.canonical;

import fr.ensea.montecarlo.data.*;
import java.io.*;
import java.awt.Color;

/**
 * Superclass for canonical MC algorithms
 */
public abstract class Montecarlo  {

	protected static final boolean DEBUG = false;
	
	protected SamplesBag samplesBag; // data bag to store thermal averages

	protected double kT; // current value of kT/J (here J=1)


	/**
	 * Initialize a new MC algorithm
	 * @param lattice the lattice to be simulated
	 * @param kT default temperature
	 */
	public Montecarlo(SamplesBag bag, double kT) {
		this.samplesBag = bag;
		setTemperature(kT); // default value
	}

	/**
	 * Modifie la temprature courante
	 */
	public abstract void setTemperature(double kT);
	
	public double getTemperature(){
		return kT;
	}
	
	/**
	 * Rinitialise les compteurs (ex : mises--jours acceptes ou taille de cluster)
	 */
	public abstract void reinitCounters();
	
	/**
	 * Retourne le taux de comptage (e.g. taux d'acceptance, taille de cluster) dans une chane de caractre.
	 */
	public abstract String getCountersRateLabel();
		
	/**
	 * Gnre un nouveau nombre alatoire distribu uniformment dans l'intervalle [0,1), et le retourne.
	 */
	public abstract double createRandomNumber();

	/**
	 * Ralise un sweep de l'ensemble du rseau, i.e. tente de mettre  jour L*L spins.
	 */
	public abstract void sweep();


	
	/////////////////////////////////////////////////////////////////////////////////
	// Utilities
	/////////////////////////////////////////////////////////////////////////////////

	protected void pause(){
		try {
			System.in.read();
		}
		catch (IOException e){}
	}
}

