/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2004  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.model;

import fr.ensea.chart.*;
import fr.ensea.math.*;
import fr.ensea.montecarlo.canonical.*;
import fr.ensea.montecarlo.multicanonical.*;
import fr.ensea.montecarlo.data.*;
import java.util.*;

/**
 * Common interface for all discrete spin models
 */
public interface ILattice  {

	/**
	 * Creates a random configuration
	 */
	void createRandomConfiguration();
	
	/**
	 * Creates a ground-state configuration
	 */
	void createGroundstateConfiguration();

	/**
	 * Reinit the spin lattice
	 * @param Q number of Q states ; 2 for the Ising model
	 * @param L lattice size
	 */
	void init(int Q, int L);
	
	/////////////////////////////////////////////////////////////////
	//// Properties
	/////////////////////////////////////////////////////////////////

	/**
	 * Return the total energy
	 */
	double getEnergy();

	/**
	 * Compute then returns the magnetization, b/w 0 and 1.
	 */
	double getMagnetization();

	/**
	 * Return the number of spins in the lattice
	 */
	int getSpinCount();
	
	/**
	 * Return the number of states of the model (2 for the Ising model)
	 */
	int getPottsQ();
	
	/**
	 * Returns the lattice size (side length in D=2, chain length in D=1)
	 */
	int getLatticeSize();
	
	/**
	 * Returns the energy of the ground-state
	 */
	double getGroundstateEnergy();
	
	//////////////////////////////////////
	//// algorithms
	//////////////////////////////////////
	/**
	 * Creates a Metropolis algorithm approriate for this model
	 */
	Montecarlo createMetropolis(SamplesBag bag, double kT);
	
	/**
	 * Creates a Wolff algorithm approriate for this model, or null if there's no such algorithm.
	 */
	Montecarlo createWolffCluster(SamplesBag bag, double kT);
	
	/**
	 * Creates a Wang-Landau algorithm approriate for this model, or null if there's no such algorithm.
	 */
	//WangLandau createWangLandau(SamplesBag bag, double dE, double weight);
	WangLandau createWangLandau(SamplesBag bag, double weight);
}
