package fr.ensea.chart;

import fr.ensea.Localizer;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.*;
import javax.swing.*;

/**
 * A wrapper for a Curve2D that lumps together several decoration parameters.
 */
public class DecoratedCurve2D implements UIConstants {

	/** --- plot style --- */
	public static final int LINES = 0;
	public static final int DOTS = 1;
	public static final int DOTS_LINES = 2;
	public static final int STAIRS = 3; // aka "L" in matlab/octave plot syntax
	public static final int BARS = 4; // histogram
	public static final int BARS_FILLED = 5;
	public static final int SAMPLES = 6; // aka sampled audio signal

	public static final int[] PLOT_STYLES={LINES, DOTS, DOTS_LINES, STAIRS, BARS, BARS_FILLED, SAMPLES};
	private static final String[] PLOT_STYLES_NAMES={"LINES", "DOTS", "DOTS_LINES", "STAIRS", "BARS", "BARS_FILLED", "SAMPLES"};

	/* package access from Plot2D */ Curve2D curve;
	private String title;
	private Color color;
	private int plotStyle;
	private boolean isVisible;

	public DecoratedCurve2D(Curve2D c, String title, Color color, int plotStyle){
		this.curve = c;
		this.title = title;
		this.color = color;
		this.plotStyle = plotStyle;
		isVisible=true;
	}
	
	boolean isVisible(){
		return isVisible;
	}

	public void setTitle(String title){
		this.title=title;
	}

	public String getTitle(){
		return title;
	}

	public void setColor(Color c){
		color=c;
	}

	public Color getColor(){
		return color;
	}

	public int getPlotStyle(){
		return plotStyle;
	}

	public void setPlotStyle(int style){
		plotStyle=style;
	}


	/////////////////////////////////////////
	/// Customizer
	/////////////////////////////////////////
	/**
 	 * Creates a Panel suited for editing this curve
	 */
	public JPanel createCustomizer(Plot2D plot){
		return new Customizer(plot);
	}
	
	class Customizer extends JPanel implements ItemListener, ActionListener {
		JTextField titleTF;
		JComboBox colorCH;
		JComboBox plotStyleCH;
		JCheckBox isVisibleCB;
		Plot2D plot; // so that we can call dataChanged()

		Customizer(Plot2D plot){
			super(new GridLayout(1,8,5,5));
			this.plot=plot;
			add(new JLabel(Localizer.get("Title")+":"));
			add(titleTF=new JTextField(getTitle(),10));
			titleTF.addActionListener(this);
			add(new JLabel(Localizer.get("Color")+":"));
			createColorCH();
			add(colorCH);
			add(new JLabel(Localizer.get("PlotStyle")+":"));
			createPlotStyleCH();
			add(plotStyleCH);
			add(isVisibleCB=new JCheckBox("Visible",isVisible));
			isVisibleCB.addItemListener(this);			
		}

		void createColorCH(){
			colorCH = new JComboBox();
			int selIdx=0;
			for (int i=0; i<PREDEFINED_COLORS.length; i++){
				colorCH.addItem(PREDEFINED_COLORS_NAMES[i]);
				if (getColor().equals(PREDEFINED_COLORS[i])) selIdx=i;
			}
			colorCH.setSelectedIndex(selIdx);
			colorCH.addItemListener(this);
		}
		void createPlotStyleCH(){
			plotStyleCH = new JComboBox();
			int selIdx=0;
			for (int i=0; i<PLOT_STYLES.length; i++){
				plotStyleCH.addItem(PLOT_STYLES_NAMES[i]);
				if (getPlotStyle()==PLOT_STYLES[i]) selIdx=i;
			}
			plotStyleCH.setSelectedIndex(selIdx);
			plotStyleCH.addItemListener(this);
		}
		public void actionPerformed(ActionEvent evt){
			//System.out.println("size="+getSize().width+","+getSize().height);
			if (evt.getSource() == titleTF){
				setTitle(titleTF.getText());
				plot.dataChanged();
			}
		}
		public void itemStateChanged(ItemEvent evt){
			if (evt.getSource() == colorCH){
				setColor(PREDEFINED_COLORS[colorCH.getSelectedIndex()]);
				plot.dataChanged();
			}
			else if (evt.getSource() == plotStyleCH){
				setPlotStyle(PLOT_STYLES[plotStyleCH.getSelectedIndex()]);
				plot.dataChanged();
			}
			else if (evt.getSource() == isVisibleCB){
				isVisible=isVisibleCB.isSelected();
				plot.dataChanged();
			}
		}
	}
}

