/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2005  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.canonical;

import fr.ensea.Version;
import fr.ensea.Localizer;
import fr.ensea.chart.*;
import fr.ensea.montecarlo.*;
import fr.ensea.montecarlo.model.*;
import fr.ensea.montecarlo.data.*;
import fr.ensea.montecarlo.canonical.*;
import fr.ensea.montecarlo.misc.*;


import java.awt.*; import javax.swing.*;
import java.awt.event.*;
import java.applet.Applet;
import java.text.NumberFormat;
import java.util.Locale;

/**
 * Pop-up window that allows the user to visualize the renormalized lattice.
 * Works only if lattice = PottsLattice with Q=2
 */
public class RenormalizationPanel extends JPanel implements ActionListener {

	MCApplet controller;
	
	private JTextField rgFactorTF;
	private JCheckBox activeCB;
	LatticeViewer2D viewerRG;

	public RenormalizationPanel(MCApplet controller){
		super(new BorderLayout(5,5));
		this.controller = controller;
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setGroupingUsed(false);
		nf.setMaximumFractionDigits(3);

		// viewer pane
		JPanel viewerPane = new JPanel();
		viewerRG = new LatticeViewer2D(null);
		//viewerRG.setSize(graphPreferredSize);
		//int s = MCApplet.this.getSize().height/4;
		Dimension graphPreferredSize = new Dimension(controller.getSize().width/4, controller.getSize().height/4);
		int s = graphPreferredSize.height;
		viewerRG.setPreferredSize(new Dimension(150,150));
		viewerPane.add(viewerRG);
		this.add(viewerPane, "Center");

		// control pane
		JPanel controlPane = new JPanel();

		controlPane.add(new JLabel(Localizer.get("rgFactor")+"="));
		rgFactorTF = new JTextField(5);
		rgFactorTF.setText(Integer.toString(1));
		rgFactorTF.addActionListener(this);
		controlPane.add(rgFactorTF);

		this.add(controlPane, BorderLayout.SOUTH);
		updateGUI();
	}

	//public Dimension getMinimumSize(){ return new Dimension(100,300); }

	public Dimension getPreferredSize(){
		return new Dimension(controller.getSize().width/4, controller.getSize().height/4);
	}
	
	public void updateGUI(){
		if (viewerRG!= null) {
			if (controller.getAlgorithm() instanceof PottsMetropolis)
				viewerRG.setLattice(((PottsMetropolis)controller.getAlgorithm()).getRGLattice());
			else if (controller.getAlgorithm() instanceof PottsWolffCluster)
				viewerRG.setLattice(((PottsWolffCluster)controller.getAlgorithm()).getRGLattice());
			viewerRG.redraw();
		}
	}

	public void reinit(){
		int rgFactor = Integer.parseInt(rgFactorTF.getText());
		if (rgFactor <1) rgFactorTF.setText("1");
		((MCSimulationThread)controller.getSimulationThread()).setFactorRG(rgFactor);
		controller.getSamplesBag().resetSamplesGraphs();
		updateGUI();
		viewerRG.redraw();
	}

	public void actionPerformed(ActionEvent evt){
		if (evt.getSource() == rgFactorTF) reinit();
	}
}

