/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2004  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.model;

import JSci.swing.*;
import java.awt.*; 
import javax.swing.*;

/**
 * A viewer for 2D spin-systems
 * Spin states are figured by either gray levels, or
 * hue colours.
 */
public class LatticeViewer2D extends JDoubleBufferedComponent {

	private ILattice2D lattice;
	
	private static final Color[] couleurs = {
		Color.gray,
		Color.white,
		Color.red,
		Color.blue,
		Color.green,
		Color.yellow,
		Color.cyan,
		Color.magenta,
		Color.orange,
		Color.pink,
		Color.black
	};

	/**
	 * contruct a new 2-dimensional Viewer
	 */
	public LatticeViewer2D(ILattice2D lattice){
		setBackground(Color.white);
		this.lattice = lattice;
	}
	
	public void setLattice(ILattice2D lattice){
		this.lattice = lattice;
	}
	
	/**
	 * Fill a rectangle for each lattice site with a gray-level corresponding to its q-state.
	 */
	public void offscreenPaint(Graphics g){

		if (lattice == null) return; // security

		// compute size of the rectangle which will display a single spin cell :
		int N = lattice.getLatticeSize();
		Dimension dim = this.getSize();
		double w = ((double)dim.width)/(double)N;
		double h = ((double)dim.height)/(double)N;
		int wInt = (int)(Math.ceil(w));
		int hInt = (int)(Math.ceil(h));
		int row,col,x,y;
		for (row=0; row < N; row++){
			y = (int)(h * row);
			for (col=0; col < N; col++){
				x = (int)(w * col);
				Color c = couleurs[lattice.getSpinValue(row,col)%couleurs.length];
				g.setColor(c);
				g.fillRect(x,y,wInt,hInt);
				if (N < 31){
					g.setColor(Color.lightGray);
					g.drawRect(x,y,wInt,hInt);
				}
				// debug:
				//g.drawString(Integer.toString(lattice.getSpinValue(row,col)),x+wInt/2,y+hInt/2);
			}
		}
	}
} 
