/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2004  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea;

import java.util.*;
import java.io.*;

/** 
 * Localizer for all classes of the simulator.</b>
 * It uses "lang/i18n_xx_yy.properties" resource file, where xx_yy is the Locale.
 * If not found, uses "lang/i18n.properties" (same as i18n_en.properties)
 * @author Sylvain Reynal
 */
public class Localizer {

	static {
		init(Locale.US); // security
	}
	
    /**
	 * a ResourceBundle is loaded using the given Locale. 
     */
    public static void init(Locale l){
		try {
	    	i18n_res = ResourceBundle.getBundle(FILE_NAME,l);
		}
		catch (MissingResourceException e){
			i18n_res = ResourceBundle.getBundle(FILE_NAME,Locale.US);
		}
	}

    /** 
     * @return a localized version of the given key ; the key if no ResourceBundle was found. 
     */
    public static String get(String key){
		if (i18n_res == null) {
			System.err.println("[Error] Missing resource file name.");
			return key;// + "[i18n]";
		}
		try {
			return i18n_res.getString(key);
		}
 		catch(MissingResourceException mre){
			System.err.println("Unable to find localized version of \"" + key + "\""); 
			return key;//+"[i18n]";
		}
   	}

	/////////////////////////////////////////////////////////////////
	
    private static ResourceBundle i18n_res;
	private final static String FILE_NAME = "lang.i18n";
	
}
