/*
 Log.java - February 21, 2002 - jPicEdt 1.3.3, a picture editor for LaTeX.
 Copyright (C) 1999-2004 Sylvain Reynal

 Dpartement de Physique
 Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
 6, avenue du Ponceau
 F-95014 CERGY CEDEX

 Tel : +33 130 736 245
 Fax : +33 130 736 667
 e-mail : reynal@ensea.fr
 jPicEdt web page : http://www.jpicedt.org
  
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or any later version.
  
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
  
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package fr.ensea;

/**
 * Utility class for printing out debugging messages.
 */
public class Log {
	
	private static final boolean DEBUG = true;
	
	/**
	 * Usage : if (Log.DEBUG) Log.debug();
	 * <br>
	 * This will automatically print the calling class and method name using new JDK1.4 features. 
	 */
	public static void debug(){
		if (DEBUG){
			Throwable t = new Throwable();
			StackTraceElement elements[] = t.getStackTrace(); // elements[0]=Log.debug 
			String clazz = elements[1].getClassName(); // and elements[1]=caller.method !
			if (!enableClass(clazz)) return;
			String method = elements[1].getMethodName();
			System.out.println("--------------------------------------------------------");
			System.out.println("* " + clazz + "." + method + "()");
		}
	}

	/**
	 * Usage : if (Log.DEBUG) Log.debug("message");
	 * <br>
	 * This will automatically print the calling class and method name using new JDK1.4 features. 
	 */
	public static void debug(String msg){
		if (DEBUG){
			Throwable t = new Throwable();
			StackTraceElement elements[] = t.getStackTrace(); // elements[0]=Log.debug 
			String clazz = elements[1].getClassName(); // and elements[1]=caller.method !
			if (!enableClass(clazz)) return;
			String method = elements[1].getMethodName();
			System.out.println("--------------------------------------------------------");
			System.out.println("* " + clazz + "." + method + "()\n\t" + msg);
		}
	}
 
	/** 
	 * Usage : if (Log.DEBUG) Log.debugAppendLn("bla bla");
	 */
	public static void debugAppendLn(String msg){
		if (DEBUG){
			Throwable t = new Throwable();
			StackTraceElement elements[] = t.getStackTrace();
			String clazz = elements[1].getClassName();
			if (!enableClass(clazz)) return;
			System.out.println("\n\t" + msg);
		}
	}
	/** 
	 * use it like this : if (Log.DEBUG) Log.debugAppend(this,"bla bla"); *
	 */
	public static void debugAppend(String msg){
		if (DEBUG){
			Throwable t = new Throwable();
			StackTraceElement elements[] = t.getStackTrace();
			String clazz = elements[1].getClassName();
			if (!enableClass(clazz)) return;
			System.out.print("\n\t" + msg);
		}
	}

	public static void error(String msg){
        Throwable t = new Throwable();
        StackTraceElement elements[] = t.getStackTrace();
		String clazz = elements[1].getClassName();
        String method = elements[1].getMethodName();
		System.out.println("[Error] " + clazz + "." + method + "()\n\t" + msg);
	}
	
	public static void warning(String msg){
        Throwable t = new Throwable();
        StackTraceElement elements[] = t.getStackTrace();
		String clazz = elements[1].getClassName();
        String method = elements[1].getMethodName();
		System.out.println("[Warning] " + clazz + "." + method + "()\n\t" + msg);
	}

	private static boolean enableClass(Object caller){
 		//if (caller.getClass().getName().startsWith("fr.ensea.montecarlo")) return true;
		return true;
	}
}
