/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2005  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.event;

/**
 * a class implementing signals for communication between algorithm threads
 */
public class SignalEvent extends java.util.EventObject {

	// inherited :
	// protected Object source;
	// EventObject(Object source);
	// Object getSource();
	// String toString();

	protected int id;

	public static final int STARTED = 0;
	public static final int COMPLETED = 1;
	public static final int STEP_FORWARD = 2;
	public static final int SUSPENDED = 3;
	public static final int RESUMED = 4;

	/**
	 * @param source the source of this SignalEvent
	 * @param id this event id
	 */

	public SignalEvent(Runnable source, int id){

		super(source);
		this.id = id;
	}

	public int getID(){

		return id;
	}

}

