/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2005  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.misc;

import fr.ensea.Version;
import fr.ensea.Localizer;
import fr.ensea.chart.*;
import fr.ensea.montecarlo.*;

import java.awt.*; import javax.swing.*;
import java.awt.event.*;
import java.applet.Applet;
import java.util.Locale;

/**
 * Listen to press events and print mouse coordinates 
 */
public class GraphMouseHandler extends MouseAdapter {

	Applet applet;
	Plot2D plot;

	public GraphMouseHandler(Applet applet, Plot2D plot){
		this.plot = plot;
		this.applet = applet;
	}

	public void mousePressed(MouseEvent e){
		if (e.isPopupTrigger()) return; // open configuration pane !
		else {
			applet.showStatus(plot.toModelCoordinates(e.getPoint()).toString());
			System.out.println(plot.toModelCoordinates(e.getPoint()).toString());
		}
	}
}


