/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2005  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.canonical;

import fr.ensea.Version;
import fr.ensea.Localizer;
import fr.ensea.chart.*;
import fr.ensea.montecarlo.*;
import fr.ensea.montecarlo.data.*;
import fr.ensea.montecarlo.model.*;
import fr.ensea.montecarlo.canonical.*;
import fr.ensea.montecarlo.misc.*;

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import java.text.NumberFormat;
import java.util.Locale;

/**
 * Pop-up window that allows the user to configure quite every simulation parameters, including
 * eg sweep mode, temperature range, mcs wait steps, ...
 */
public class MCSimulationCustomizer extends Frame implements ActionListener, ItemListener {

	private MCSimulationThread algoThread; 
	private MCApplet controller;
	
	private TextField kTSingleTF, kTStartTF, kTEndTF, kTStepsTF, mcsWaitTF, mcsThermTF,nbMeasTF;
	private Button okTempBUT, okStatsBUT;
	private GridBagLayout gridbag;
	private GridBagConstraints c;
	private Choice modeCH;
	private Button unlimitedNbMeasBUT;
	private Checkbox autoComputeMCSWaitCB;
	private Label lbl1, lbl2; // for modeCH

	public MCSimulationCustomizer(MCApplet controller, MCSimulationThread algoThread, double defKT){
		super(Localizer.get("ConfigPanel"));
		this.algoThread = algoThread;
		this.controller = controller;
		
		this.setSize(600,300);
		this.setLayout(new BorderLayout(5,5));
		addWindowListener(new WindowAdapter(){public void windowClosing(WindowEvent evt){
				                  setVisible(false);
				                  //[test]System.exit(0);
			                  }});

		NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
		nf.setGroupingUsed(false);
		nf.setMaximumFractionDigits(3);

		Panel p = new Panel();
		gridbag = new GridBagLayout();
		p.setLayout(gridbag);
		c = new GridBagConstraints();

		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;	c.weighty = 1.0;

		c.gridwidth = GridBagConstraints.REMAINDER;
		modeCH = new Choice();
		modeCH.add(Localizer.get("FixedTemp"));
		modeCH.add(Localizer.get("TempSweep"));
		int mode=0;
		if (algoThread.isTemperatureSweep()) mode=1;
		modeCH.select(mode);
		addComp(p, modeCH);

		c.gridwidth = 1;
		addComp(p, lbl1=new Label("  "));
		addComp(p,new Label("kT ("+Localizer.get("fixed")+")="));
		addComp(p,kTSingleTF=new TextField(nf.format(algoThread.getSingleTemperature()),4));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p, new Label());


		c.gridwidth = 1;
		addComp(p, lbl2=new Label("  "));
		addComp(p,new Label(Localizer.get("From")+" kT="));
		addComp(p,kTStartTF = new TextField(nf.format(algoThread.getKTStart()),4));
		addComp(p,new Label(" "+Localizer.get("to")+" kT="));
		addComp(p,kTEndTF = new TextField(nf.format(algoThread.getKTEnd()),4));
		addComp(p,new Label(" "+Localizer.get("in")+" n="));
		addComp(p,kTStepsTF = new TextField(Integer.toString(algoThread.getKTSteps()),4));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p,new Label(Localizer.get("steps")+"."));

		c.gridwidth = 2;
		addComp(p,okTempBUT=new Button(Localizer.get("Apply")));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p,new Label());

		addComp(p,new Label(Localizer.get("Statistics")+" :"));

		c.gridwidth = 2;
		addComp(p,new Label(Localizer.get("SimulationSteps")+"="));
		c.gridwidth = 1;
		addComp(p,nbMeasTF = new TextField(Integer.toString(algoThread.getNumberMCSSteps()),4));
		addComp(p,unlimitedNbMeasBUT = new Button(Localizer.get("unlimited")));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p, new Label());

		c.gridwidth = 2;
		addComp(p,new Label(Localizer.get("SampleEvery")));
		c.gridwidth = 1;
		addComp(p,mcsWaitTF = new TextField(Integer.toString(controller.getSamplesBag().getMCSWait()),4));
		addComp(p,new Label(" "+Localizer.get("steps")+"."));
		c.gridwidth = GridBagConstraints.REMAINDER;;
		addComp(p,autoComputeMCSWaitCB=new Checkbox(Localizer.get("Automatic")));
		if (controller.getSamplesBag().getMCSWait()<0) autoComputeMCSWaitCB.setState(true);
		mcsWaitTF.setEnabled(!autoComputeMCSWaitCB.getState());
		//c.gridwidth = GridBagConstraints.REMAINDER;addComp(p, new Label());

		c.gridwidth = 2;
		addComp(p,new Label(Localizer.get("Thermalization")+" :"));
		c.gridwidth = 1;
		addComp(p, mcsThermTF=new TextField(Integer.toString(controller.getSamplesBag().getThermalizationTime()),6));
		addComp(p,new Label(" "+Localizer.get("steps")+"."));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p, new Label());

		c.gridwidth = 2;
		addComp(p, okStatsBUT=new Button(Localizer.get("Apply")));

		// listeners:
		modeCH.addItemListener(this);
		okTempBUT.addActionListener(this);
		okStatsBUT.addActionListener(this);
		autoComputeMCSWaitCB.addItemListener(this);
		unlimitedNbMeasBUT.addActionListener(this);

		updateControls(mode); // see "modeCH"
		this.add(p, "North");
	}

	private void addComp(Panel p, Component comp){
		gridbag.setConstraints(comp,c);
		p.add(comp);
	}
	public void actionPerformed(ActionEvent evt){
		if (evt.getSource() == okTempBUT){
			okTemp();
		}
		else if (evt.getSource() == okStatsBUT){
			okStats();
		}
		else if (evt.getSource() == unlimitedNbMeasBUT){
			nbMeasTF.setText("-1");
		}
	}

	public void itemStateChanged(ItemEvent evt){
		if (evt.getSource() == modeCH){
			updateControls(modeCH.getSelectedIndex());
		}
		else if (evt.getSource() == autoComputeMCSWaitCB){
			mcsWaitTF.setEnabled(!autoComputeMCSWaitCB.getState());
		}
	}

	// enable/de-enable controls related to modeCH selected index
	private void updateControls(int mode){
		boolean b = (mode==1);
		kTSingleTF.setEnabled(!b);
		kTStartTF.setEnabled(b);
		kTEndTF.setEnabled(b);
		kTStepsTF.setEnabled(b);
		if (b){
			lbl1.setText("  ");
			lbl2.setText("=>");
		}
		else {
			lbl1.setText("=>");
			lbl2.setText("  ");
		}
	}

	private void okTemp(){
		if (modeCH.getSelectedIndex()==0){ // single kT
			algoThread.setSingleTemperature(Double.valueOf(kTSingleTF.getText()).doubleValue());
			controller.showStatus("kT ("+Localizer.get("fixed")+")="+kTSingleTF.getText());
		}
		else { // kT sweep
			// check nbmeas:
			int nbmeas = algoThread.getNumberMCSSteps();
			if (nbmeas == Integer.MAX_VALUE) {
				nbMeasTF.setText("1000");
				algoThread.setNumberMCSteps(1000);
			}
			algoThread.setTemperatureRange(
			    Double.valueOf(kTStartTF.getText()).doubleValue(),
			    Double.valueOf(kTEndTF.getText()).doubleValue(),
			    Integer.parseInt(kTStepsTF.getText()));
			controller.showStatus("kT ("+Localizer.get("sweep")+") : "+Localizer.get("From")+" "+kTStartTF.getText()+" "+Localizer.get("to")+" "+kTEndTF.getText() + " "+Localizer.get("in")+" " +
			           kTStepsTF.getText() + " "+Localizer.get("steps"));
		}
	}

	private void okStats(){
		String s=Localizer.get("Update")+" : ";
		// nbMeas:
		int nbmeas = Integer.parseInt(nbMeasTF.getText());
		algoThread.setNumberMCSteps(nbmeas);
		s += Localizer.get("stepCount")+" = " + (nbmeas < 1 ? Localizer.get("unlimited") : nbMeasTF.getText());
		// mcs wait:
		if (autoComputeMCSWaitCB.getState()){
			controller.getSamplesBag().setMCSWait(-1); // auto mode
			s += " ; "+Localizer.get("decorrelTime")+" = "+Localizer.get("Automatic");
		}
		else {
			controller.getSamplesBag().setMCSWait(Integer.parseInt(mcsWaitTF.getText()));
			s += " ; "+Localizer.get("decorrelTime")+" = " + mcsWaitTF.getText();
		}
		// mcTherm:
		controller.getSamplesBag().setThermalizationTime(Integer.parseInt(mcsThermTF.getText()));
		s += " ; "+Localizer.get("thermTime")+" = " + mcsThermTF.getText();
		controller.showStatus(s);
	}
	
	//[test] public static void main(String[] args){new ConfigurationPanel(1.0).show();}

}

