/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2004  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.multicanonical;

import java.io.*;
import java.awt.Color;
import java.text.*;

import fr.ensea.Localizer;
import fr.ensea.montecarlo.model.*;
import fr.ensea.montecarlo.data.*;
import fr.ensea.montecarlo.canonical.*;
import fr.ensea.montecarlo.misc.*;

/**
 * Wang-Landau algorithm for the 2D antiferromagnetic Ising model
 */
public class AFIsingWL extends WangLandau  {

	private AFIsingLattice lattice;
	
	/**
	 * Init a new WL algorithm
	 * @param weight initial weight for updating S(E), i.e. S(E)+=weight.
	 * @param dE histogram bin width
	 */
	public AFIsingWL(AFIsingLattice lattice, SamplesBag bag, double dE, double weight) {
		super(bag, dE, weight);
		this.lattice = lattice;
	}
	
	/**
	 * Attempts updating L*L spins. 
	 */
	public void sweep(){

		int row,col, neighborVal;
		double dE, oldSE, newSE;
		final int L = lattice.size;
		final int L2 = lattice.size2;

		for (int step=0; step < L2; step++){

			attemptedMoves++;

			// pick at random a spin to be updated:
			row = (int)(L * createRandomNumber());
			col = (int)(L * createRandomNumber());

			oldSE = wlDosHistogram.getSE(lattice.getEnergy());
			dE = lattice.getEnergyChange(row,col); // virtually toggle spin (row,col)
			newSE = wlDosHistogram.getSE(lattice.getEnergy()+dE);

			// attempt move:
			if (newSE <= oldSE || createRandomNumber() <= Math.exp(oldSE-newSE)){
				acceptedMoves++;
				lattice.toggleSpin(row,col);
				lattice.energy += dE;
			}
		}
		samplesBag.addEnergySample(lattice.getEnergy()/lattice.size2);
		samplesBag.addMagnetizationSample(lattice.getMagnetization());
		wlDosHistogram.fill(lattice.getEnergy());
	}
}

