/*  Monte-Carlo simulation code for statistical physics
    Copyright (C) 2001-2005  Sylvain Reynal
    
    Dpartement de Physique
    Ecole Nationale Suprieure de l'Electronique et de ses Applications (ENSEA)
    6, avenue du Ponceau,    
    F-95014 CERGY CEDEX

    et
    
    Laboratoire de Physique Thorique et Modlisation (LPTM)
    Universit de Cergy-Pontoise - Site de Neuville
    F-95031 CERGY CEDEX
    
	
    Tel : 00 +33 130 736 245
    Fax : 00 +33 130 736 667
    e-mail : reynal@ensea.fr
    web page : http://www.ensea.fr/staff/reynal/
*/

package fr.ensea.montecarlo.multicanonical;

import fr.ensea.Version;
import fr.ensea.Localizer;
import fr.ensea.chart.*;
import fr.ensea.montecarlo.*;
import fr.ensea.montecarlo.data.*;
import fr.ensea.montecarlo.model.*;
import fr.ensea.montecarlo.canonical.*;
import fr.ensea.montecarlo.misc.*;

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import java.text.NumberFormat;
import java.util.Locale;

/**
 * Pop-up window that allows the user to configure quite every simulation parameters, including
 * eg sweep mode, temperature range, mcs wait steps, ...
 */
public class WLSimulationCustomizer extends Frame implements ActionListener {

	private WLSimulationThread algoThread; 
	private WLApplet controller;
	
	private TextField kTStartTF, kTEndTF, kTStepsTF, weightTF, maxFlatnessTF,nbMeasTF;
	private Button okTempBUT, okAlgoBUT;
	private GridBagLayout gridbag;
	private GridBagConstraints c;

	public WLSimulationCustomizer(WLApplet controller, WLSimulationThread algoThread){
		super(Localizer.get("ConfigPanel"));
		this.algoThread = algoThread;
		this.controller = controller;
		
		this.setSize(600,300);
		this.setLayout(new BorderLayout(5,5));
		addWindowListener(new WindowAdapter(){public void windowClosing(WindowEvent evt){
				                  setVisible(false);
				                  //[test]System.exit(0);
			                  }});

		NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
		nf.setGroupingUsed(false);
		nf.setMaximumFractionDigits(3);

		Panel p = new Panel();
		gridbag = new GridBagLayout();
		p.setLayout(gridbag);
		c = new GridBagConstraints();

		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;	c.weighty = 1.0;

		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p,new Label(Localizer.get("Reweighting")+" :"));

		c.gridwidth = 1;
		addComp(p, new Label("  "));
		addComp(p,new Label(Localizer.get("From")+" kT="));
		addComp(p,kTStartTF = new TextField(nf.format(algoThread.getKTStart()),4));
		addComp(p,new Label(" "+Localizer.get("to")+" kT="));
		addComp(p,kTEndTF = new TextField(nf.format(algoThread.getKTEnd()),4));
		addComp(p,new Label(" "+Localizer.get("in")+" n="));
		addComp(p,kTStepsTF = new TextField(Integer.toString(algoThread.getKTSteps()),4));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p,new Label(Localizer.get("steps")+"."));

		c.gridwidth = 2;
		addComp(p,okTempBUT=new Button(Localizer.get("Apply")));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p,new Label());

		addComp(p,new Label(Localizer.get("Iterations")+" :"));

		c.gridwidth = 2;
		addComp(p,new Label(Localizer.get("SimulationSteps")+"="));
		c.gridwidth = 1;
		addComp(p,nbMeasTF = new TextField(Integer.toString(algoThread.getNumberMCSSteps()),4));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p, new Label());

		c.gridwidth = 2;
		addComp(p,new Label(Localizer.get("WLWeight")));
		c.gridwidth = 1;
		addComp(p,weightTF = new TextField(Double.toString(algoThread.getWLDOSHistogram().getWeight()),8));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p, new Label());

		c.gridwidth = 2;
		addComp(p,new Label(Localizer.get("MaxFlatness")+" :"));
		c.gridwidth = 1;
		addComp(p, maxFlatnessTF=new TextField(Double.toString(algoThread.getMaxFlatness()),6));
		c.gridwidth = GridBagConstraints.REMAINDER;
		addComp(p, new Label());

		c.gridwidth = 2;
		addComp(p, okAlgoBUT=new Button(Localizer.get("Apply")));

		// listeners:
		okTempBUT.addActionListener(this);
		okAlgoBUT.addActionListener(this);

		this.add(p, "North");
	}

	private void addComp(Panel p, Component comp){
		gridbag.setConstraints(comp,c);
		p.add(comp);
	}
	public void actionPerformed(ActionEvent evt){
		if (evt.getSource() == okTempBUT){
			okTemp();
		}
		else if (evt.getSource() == okAlgoBUT){
			okAlgo();
		}
	}

	public void updateWeightTextField(double w){
		weightTF.setText(Double.toString(w));
	}
	
		
	private void okTemp(){
		algoThread.setTemperatureRange(
			    Double.valueOf(kTStartTF.getText()).doubleValue(),
			    Double.valueOf(kTEndTF.getText()).doubleValue(),
			    Integer.parseInt(kTStepsTF.getText()));
		controller.showStatus("kT ("+Localizer.get("sweep")+") : "+Localizer.get("From")+" "+kTStartTF.getText()+" "+Localizer.get("to")+" "+kTEndTF.getText() + " "+Localizer.get("in")+" " +
			           kTStepsTF.getText() + " "+Localizer.get("steps"));
	}

	private void okAlgo(){
		String s=Localizer.get("Update")+" : ";
		// nbMeas:
		int nbmeas = Integer.parseInt(nbMeasTF.getText());
		algoThread.setNumberMCSteps(nbmeas);
		s += Localizer.get("stepCount")+" = " + nbMeasTF.getText();
		// maxFlatness
		algoThread.setMaxFlatness(Double.parseDouble(maxFlatnessTF.getText()));
		s += " ; "+Localizer.get("MaxFlatness")+" = " + maxFlatnessTF.getText();
		// WL-weight
		algoThread.setWeight(Double.parseDouble(weightTF.getText()));
		s += " ; "+Localizer.get("WLWeight")+" = " + weightTF.getText();
		controller.showStatus(s);
	}
	

}

