
package Convolution;
import javax.swing.*;
import java.awt.*;

/**
 * Die Klasse dient zur Unterstuetzung der optischen
 * Darstellung. Hier werden Eingangs-und Ausgangsbild sowie
 * die Bilder der Gradientenoperationen gezeichnet.
 * Der benutzerdefinierte Faltungskern wird durch Textfelder
 * dargestellt, welche in der Mitte zwischen Eingangs-und Ausgangsbild
 * plaziert werden. Zu Anfang ist fuer alle Textfelder'setVisible' 
 * auf false gesetzt,da diese nur sichtbar werden sollen,wenn als 
 * Operator der benuterdefinierte Faltungskern gewaehlt wurde.
 * Um die Textfelder praeziese setzen zu koennen wurde in dieser
 * KLasse der Layoutmanage auf null gesetzt.
 *  
 * @author Rene Iser, Behrang Karimibabak, Simon Winkelbach
 *
 */

public class ConvolutionViewer extends JPanel {
    
    ImageWindow inputImage,outputImage;
    boolean roberts,sobel,laPlace,userDef;
    int rows,cols;
    Image operator;
    MediaTracker media;
    JTextField[][] mask;
    Font background;
    
    ConvolutionViewer(ImageWindow inputImage,ImageWindow outputImage){
        setLayout(null);
        sobel=true;
        roberts=false;
        laPlace=false;
        userDef=false;
        rows=3;
        cols=3;
        this.inputImage=inputImage;
        this.outputImage=outputImage;
        background = new Font("Helvetica",30,30);
        
        media=new MediaTracker(this);
        operator=Toolkit.getDefaultToolkit().getImage(getClass().getResource("Sobel.jpg"));
        media.addImage(operator,0);
        try{
            media.waitForID(0);
        }
        catch (Exception e){}
        
        /*
         * Definiert die Textfelder.Die Sichtbarkeit ist
         * zunaechst 'false'.Sie wird erst auf 'true' wenn
         * im Hauptprogramm der User-defined-Operator gewaehlt
         * wurde.
         */
        mask=new JTextField[3][3];
        for (int i=0;i<rows;i++){
            for (int j=0;j<cols;j++){
                mask[i][j]=new JTextField();
                mask[i][j].setSize(40,40);
                mask[i][j].setLocation(330+40*i,85+40*j);
                mask[i][j].setBackground(Color.WHITE);
                mask[i][j].setVisible(false);
                add(mask[i][j]);
            }
        }
        
    }
    
    /**
     * Zeichnet Eingangs-und Ausgangsbild,sowie
     * die Bilder der Operatoren.
     * Ist der benutzerdefinierte Faltungskern aktiv,
     * werden vor der Eingabemaske die '**' gesetzt und
     * dahinter das '='.
     * @param g
     */
    public void paintComponent(Graphics g){
        
        inputImage.paintComponent(g);
        if(!userDef){
            g.drawImage(operator,280,43,this);
        }
        else{
            g.setFont(background);
            g.drawString("* *",280,158);
            g.drawString("=",465,158);
        }
        outputImage.paintComponent(g);
        
        
    }
    
    /**
     * Setzt das boolsche Flag fuer den Sobel-Operator.
     * Fuer die bessere Verstaendlichkeit wird das Bild
     * des Faltungskern mit ausgegeben.
     * @param s
     */
    public void setSobel(boolean s){
        this.sobel=s;
        if(sobel) {
            operator=Toolkit.getDefaultToolkit().getImage(getClass().getResource("Sobel.jpg"));
            media.addImage(operator,0);
            try{
                media.waitForID(0);
            }
            catch (Exception e){}
        }
    }
    
    /**
     * @see setSobel(..)
     */
    public void setRoberts(boolean r){
        this.roberts=r;
        if(roberts) {
            operator=Toolkit.getDefaultToolkit().getImage(getClass().getResource("Roberts.jpg"));
            media.addImage(operator,0);
            try{
                media.waitForID(0);
            }
            catch (Exception e){}
            
        }
    }
    
    /**
     * @see setSobel(..)
     */
    
    public void setLaPlace(boolean lP){
        this.laPlace=lP;
        if(laPlace) {
            operator=Toolkit.getDefaultToolkit().getImage(getClass().getResource("laplace.jpg"));
            media.addImage(operator,0);
            try{
                media.waitForID(0);
            }
            catch (Exception e){}            
        }
    }
    
    /**
     * Setzt den boolsche Flag fuer den 
     * benutzerdefinierten Faltungskern.
     * Setzt die Sichtbarkeit der Textfelder auf 'true'
     * da diese auf dem Bildschirm ausgegeben werden sollen.
     */
    
    public void setUserDef(boolean user){
        /*
         * Mit der ersten if-Abfrage wird erreicht, dass
         * beim Wechsel eines Bildes die Eingabemaske nicht 
         * komplett auf 0 zurckgesetzt wird.
         */
        if (this.userDef != user){
            this.userDef = user;
            for(int i=0;i<rows;i++){
                for (int j=0;j<cols;j++){
                    if(userDef){
                        mask[i][j].setText("0");
                        mask[i][j].setVisible(true);
                    }

                    else mask[i][j].setVisible(false);
                }
             }
        }
        else this.userDef=user;
 
        
        
    }
    
    /**
     * Im Hautprogramm soll der user-defined-Faltungskern durch
     * ein iRPImage dargestellt werden.In dieser Methode werden die
     * Werte aus den Textfeldern ausgelesen und als Pixelwerte in dem
     * Bild gespeichert
     * @return convArray der Faltungskern als Bild dargestellt
     */
    public iRPImage getMask() {
        int value;
        iRPImage convArray=new iRPImage(rows,cols);
        
        for (int i=0;i<cols;i++){
            for(int j=0;j<rows;j++){
                String s=mask[j][i].getText();
                value=Integer.parseInt(s);
                convArray.SetPixel(j,i,value);
            }
        }
        return convArray;
    }
    

}
