package MedianAveraging;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Arrays;
import java.util.Random;

/**
 * Dieses Applet zeigt den Median-und Averagefilter bei Fotos. Zur Auswahl
 * stehen verschiedene Bilder und Filtergroessen. Ausserdem kann gaussches 
 * Rauschen hinzugefuegt werden,bzw. das Eingangsbild kann gesalzen werden.
 * Beim Medianfilter werden p Elemente innerhalb eines lokalen Operator-
 * fensters der Groesse nach geordnet.Das Ausgangsbildelement ist der 
 * (p+1)/2 groesste Wert der Reihe.Beim Averaging wird der Durchschnittswert
 * genommen. 
 * 
 * 
 * @author Rene Iser, Behrang Karmimibabak, Simon Winkelbach
 *
 */

public class MedianAndAveraging extends JApplet implements MouseInputListener {

    protected JPanel operationPanel,messagePanel;
    protected Dialog pictureDialog;
    protected filterViewer viewer;
    protected iRPImage inputImage,MedianImage,AveragingImage;
    protected zoomediRPImage zoomedMedianImage,zoomedAveragingImage;
    protected ImageWindow input,median,averaging,zoomedMedian,zoomedAveraging;
    protected JButton addGaus,addSalt,choosePicture,chooseMask;
    protected JButton[] pictureButtons;
    protected boolean mouseOverMedian=false,mouseOverInput=false,mouseOverAverage=false;
    protected int sizeOfWindow=5;
    protected int gausStrength=25;
    protected final String[] pictures={"Face","Fonts","Boxes"};
    protected final String[] mask={"3x3", "5x5", "7x7", "9x9"};
    protected String plaf;
    protected ImageIcon dialogIcon;
    protected JLabel message1,message2;
    protected DialogImageProvider imgProv;
    protected Image[] dialogImg;
    protected String[] dialogImgNames;
    protected String imageToLoad;
    
    public void init() {
        
         
        Image dialogImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("dialogIcon.gif"));
        dialogIcon=new ImageIcon(dialogImage);    
        Dimension d = new Dimension(240,120);
        operationPanel = new JPanel();
        operationPanel.setLayout(new FlowLayout(FlowLayout.LEFT,10,10));
        operationPanel.setPreferredSize(d);
        operationPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
 
        imgProv = new DialogImageProvider();
        dialogImg = imgProv.getImages();
        dialogImgNames = imgProv.getImageNames();
        
        this.initializeImages();
        this.initializeButtons();
        this.initializeDialog();
 
        message1 = new JLabel("Select filter size or add some");
        message2 = new JLabel(" noise to the input image");
        messagePanel=new JPanel();
        messagePanel.setPreferredSize(new Dimension(220,50));
        messagePanel.setBorder(BorderFactory.createEtchedBorder());
        //messagePanel.setLayout(new FlowLayout(FlowLayout.LEFT,3,3));
        messagePanel.add(message1);
        messagePanel.add(message2);
        
        operationPanel.add(choosePicture);
        operationPanel.add(chooseMask);
        operationPanel.add(addGaus);
        operationPanel.add(addSalt);
        operationPanel.add(messagePanel);
        viewer= new filterViewer(input,median,averaging,zoomedMedianImage,zoomedAveragingImage);
        viewer.setLayout(new FlowLayout(FlowLayout.LEFT,10,15));
        viewer.add(operationPanel);
        
 

        //getContentPane().add("North",operationPanel);
        getContentPane().add(viewer);
        

 
        this.initializeActionListeners();
        this.changeLookAndFeel();
        addMouseListener(this);
        addMouseMotionListener(this);
        
        
        
    }
    /**
     * Initialisierung der Dialogbox,welche aufgerufen wird,
     * wenn man das Bild  wechselt.
     */
    
    public void initializeDialog(){
        
        pictureButtons=new JButton[dialogImg.length];
        String buttonName;
        
        /*
         *Hier werden die Buttons zur Bildauswahl initialisiert.
         *In 'buttonName' wird der Name des zu ladenen Bildes gespeichert.
         */
        for(int i=0;i<dialogImg.length;i++){
                        
            buttonName=dialogImgNames[i];
            pictureButtons[i]= new JButton(new ImageIcon(dialogImg[i]));
            pictureButtons[i].setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
            pictureButtons[i].setName(buttonName);
             
        }
        
        JOptionPane picturePane=new JOptionPane();
        picturePane.setOptions(pictureButtons);
        picturePane.setMessage("");
        
        pictureDialog=picturePane.createDialog(this,"select input image");
        
    }
    

    /**
     * Laden des Anfangsbildes.
     * Dieses wird auch gleich gefiltert.
     *
     */
    public void initializeImages(){
        
        inputImage=new iRPImage();
        inputImage.LoadImage(dialogImgNames[0]);
        input= new ImageWindow(inputImage,10,180);
        
        MedianImage = Median(inputImage,sizeOfWindow,sizeOfWindow);
        median = new ImageWindow(MedianImage,460,20);
          
        AveragingImage = Averaging(inputImage,sizeOfWindow,sizeOfWindow);
        averaging = new ImageWindow(AveragingImage,460,320);
         
        zoomedMedianImage = new zoomediRPImage();
        zoomedMedianImage.LoadImage("schwarz.jpg");
        
        zoomedAveragingImage = new zoomediRPImage();
        zoomedAveragingImage.LoadImage("schwarz.jpg");
 
    }
    
    /**
     * Erstellen der Buttons.
     * Alle Buttons werden mit Icons versehen und 
     * bekommen eine Umrandung.
     */
    
    public void initializeButtons(){
        Image gaussImage=Toolkit.getDefaultToolkit().getImage(getClass().getResource("gauss.gif"));
        addGaus = new JButton(new ImageIcon(gaussImage));
        addGaus.setToolTipText("adds gaussian noise");
        addGaus.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image saltImage=Toolkit.getDefaultToolkit().getImage(getClass().getResource("salt.gif"));
        addSalt=new JButton(new ImageIcon(saltImage));
        addSalt.setToolTipText("adds salt & pepper");
        addSalt.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
        Image pictureImage=Toolkit.getDefaultToolkit().getImage(getClass().getResource("picture.gif"));
        ImageIcon pictureIcon=new ImageIcon(pictureImage);
        choosePicture=new JButton(pictureIcon);       
        choosePicture.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        choosePicture.setToolTipText("choose picture");
        
        Image maskImage=Toolkit.getDefaultToolkit().getImage(getClass().getResource("mask.gif"));
        ImageIcon maskIcon=new ImageIcon(maskImage);
        chooseMask=new JButton(maskIcon);
        chooseMask.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        chooseMask.setToolTipText("choose mask size");
        
 
    }
    
    
    /**
     * Mit Hilfe der ActionListener werden beim
     * Klicken auf die Buttons die entsprechenden Methoden
     * aufgerufen,z.B. wird beim druecken auf den choosePicture-button
     * die Dialogbox mit der Bildauswahl geoeffnet.
     */
    
    public void initializeActionListeners(){
     
         
        //Hinzufuegen von gausschem Rauschen
        addGaus.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                  addGaussianNoise(inputImage,(double)gausStrength);
                  input.changeImage(inputImage);
                  MedianImage=Median(inputImage,sizeOfWindow,sizeOfWindow);
                  AveragingImage=Averaging(inputImage,sizeOfWindow,sizeOfWindow);
                  median.changeImage(MedianImage);
                  averaging.changeImage(AveragingImage);
                  repaint();  
            }
        });
        
        // Hinzufuegen von salt&pepper
        addSalt.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                  addRandomNoise(inputImage,gausStrength*50);
                  input.changeImage(inputImage);
                  MedianImage=Median(inputImage,sizeOfWindow,sizeOfWindow);
                  AveragingImage=Averaging(inputImage,sizeOfWindow,sizeOfWindow);
                  median.changeImage(MedianImage);
                  averaging.changeImage(AveragingImage);
                  repaint(); 
            }
        });
        
        choosePicture.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                pictureDialog.show();
            }
        });
        
        chooseMask.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                changeMask(); 
            }
        });  

 
        for (int i=0;i<dialogImg.length;i++){
            pictureButtons[i].addActionListener(new ActionListener(){
                public void actionPerformed(ActionEvent e){
                    imageToLoad=((JButton)e.getSource()).getName();
                    changePicture(imageToLoad);
                    pictureDialog.setVisible(false);
                }
            });     	
        }
    }
    
    /**
     * Aenderung der Optik
     *
     */
    public void changeLookAndFeel(){
        try{
        	plaf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";

        	UIManager.setLookAndFeel(plaf);
        	SwingUtilities.updateComponentTreeUI(this);
        	SwingUtilities.updateComponentTreeUI(operationPanel);
        	SwingUtilities.updateComponentTreeUI(choosePicture);
        	SwingUtilities.updateComponentTreeUI(addGaus);
        	SwingUtilities.updateComponentTreeUI(addSalt);
        	SwingUtilities.updateComponentTreeUI(chooseMask);

       		for (int i=0;i<pictureButtons.length;i++){
    		    SwingUtilities.updateComponentTreeUI(pictureButtons[i]);
    		}
 
             } catch (UnsupportedLookAndFeelException e) {
               System.err.println(e.toString());
             } catch (ClassNotFoundException e) {
               System.err.println(e.toString());
             } catch (InstantiationException e) {
               System.err.println(e.toString());
             } catch (IllegalAccessException e) {
               System.err.println(e.toString());
             }
    }
    
    /**
     * Wechsel der Filtergroesse.Beide Filteroperatoren
     * werden nach Auswahl sofort durchgefuehrt.
     */
    public void changeMask(){
        
 	   String m=(String)JOptionPane.showInputDialog(this,"please choose mask size",
	                "Mask size",JOptionPane.QUESTION_MESSAGE,
	                dialogIcon,mask,mask[0]);
        
 	   if(m!=null){
 	       if(m=="3x3"){
 	          sizeOfWindow=3;
 	        }
 	        if(m=="5x5"){
 	           sizeOfWindow=5;           
 	        }
 	        if(m=="7x7"){
 	            sizeOfWindow=7;
 	        }
 	        if(m=="9x9"){
 	            sizeOfWindow=9;
 	        }
 	        
 	        MedianImage=Median(inputImage,sizeOfWindow,sizeOfWindow);
 	        AveragingImage=Averaging(inputImage,sizeOfWindow,sizeOfWindow);
 	        median.changeImage(MedianImage);
 	        averaging.changeImage(AveragingImage);
 	   }
 
        repaint();
        
    }
    
    /**
     * Wechsel des Bildes.Anschlieend werden die
     * Filteroperationen durchgefuehrt.
     * @param pic Name des Bildes
     */
    
    public void changePicture(String pic){
        
        inputImage.LoadImage(pic);
        input.changeImage(inputImage);
        MedianImage=Median(inputImage,sizeOfWindow,sizeOfWindow);
        AveragingImage=Averaging(inputImage,sizeOfWindow,sizeOfWindow);
        median.changeImage(MedianImage);
        averaging.changeImage(AveragingImage);
        repaint();        
    }
    
    /**
     * Die Methode fuehrt den Medianfilter an einem Bild durch.
     * @param A das Eingangsbild
     * @param i Laenge der Filtermaske
     * @param j Breite der Filtermaske
     */
    public iRPImage Median(iRPImage A, int i, int j)
    {
    	int[] Adder = new int[i*j];
    	int SizeX = A.GetSizeX();
    	int SizeY = A.GetSizeY();
    	int HX = i/2;
    	int HY = j/2;
    	int middle = (i*j)/2;
    	iRPImage R = new iRPImage(SizeX, SizeX);

    	for(int y=HY, c=HX+y*SizeX; y<SizeY-(j-HY) ; y++)
    	{
    		for(int x=HX; x<SizeX-(i-HX); x++,c++)
    		{
    			for(int n=0, c2=0; n<j; n++)
    			{
    				for(int m=0; m<i; m++,c2++)
    				{
    					Adder[c2] = A.GetPixel(x-m+HX+(y-n+HY)*SizeX);
    				}
    			}
    			//sort the values
    			Arrays.sort(Adder);
    			R.SetPixel(c,Adder[middle]);

    		}
    		c+=i;
    	}
    	return R;
    }
    
    
    /**
     * Die Methode fuehrt den Averagefilter an einem Bild durch.
     * @param A das Eingangsbild
     * @param i Laenge der Filtermaske
     * @param j Breite der Filtermaske
     */
    
    public iRPImage Averaging(iRPImage A, int i, int j)
    {
    	int Adder;
    	int SizeX = A.GetSizeX();
    	int SizeY = A.GetSizeY();
    	int HX = i/2;
    	int HY = j/2;
    	int middle = (i*j)/2;
    	iRPImage R = new iRPImage(SizeX, SizeX);

    	for(int y=HY, c=HX+y*SizeX; y<SizeY-(j-HY) ; y++)
    	{
    		for(int x=HX; x<SizeX-(i-HX); x++,c++)
    		{
    			Adder=0;
    			for(int n=0, c2=0; n<j; n++)
    			{
    				for(int m=0; m<i; m++,c2++)
    				{
    					Adder+= A.GetPixel(x-m+HX+(y-n+HY)*SizeX);
    				}
    			}
    			//sort the values
    			R.SetPixel(c,Adder/i*j);

    		}
    		c+=i;
    	}
    	return R;
    }
    
    /**
     * Fuegt gaussches Rauschen zu dem Eingangsbild hinzu.
     * @param A das Eingangsbild.
     * @param strength Staerke des Rauschens.
     */
    public void addGaussianNoise(iRPImage A,double strength)
    {
    	Random randomizer = new Random();

    	for(int y=0; y<A.GetSizeY(); y++)
    	{
    		for(int x=0; x<A.GetSizeX(); x++)
    		{
    			A.SetPixel(x,y,A.GetPixel(x,y)+(int)(strength*randomizer.nextGaussian()));
    		}
    	}

    }
    
    /**
     * Hinzufuegen von salt&pepper
     */
    public void addRandomNoise(iRPImage A, int intensity)
    {
    	Random randomizer = new Random();
    	int randomNumber1, randomNumber2;
    	boolean black;

    	for(int y=0; y<intensity; y++)
    	{
    		randomNumber1 = Math.abs(randomizer.nextInt()%256);
    		randomNumber2 = Math.abs(randomizer.nextInt()%256);
    		black = randomizer.nextBoolean();
    		if(black)
    		{
    			A.SetPixel(randomNumber1, randomNumber2, 0);
    		}
    		else
    		{
    			A.SetPixel(randomNumber1, randomNumber2, 255);
    		}
    	}
    }
    
    /**
     * Zoomed das Bild an der Stelle (x,y) heran.
     * @param x
     * @param y
     */

    
    protected void ChangeZoomPics(int x, int y){

    	MedianImage.Normalize();
    	AveragingImage.Normalize();

    	if((x>4) && (x<(inputImage.GetSizeX()-4)) && (y>4) && (y<(inputImage.GetSizeY()-4)))
    	{

    		int[][] values = new int[10][10];
    		int[][] avvalues = new int[10][10];
    		for(int i = -4; i<=4; i++)
    		{
    			for(int j=-4; j<=4; j++)
    			{
    				values[i+4][j+4] = MedianImage.GetPixel(x+i, y+j);
    				avvalues[i+4][j+4] = AveragingImage.GetPixel(x+i,y+j);
    				//System.out.println(values[i+4][j+4]);
    				for(int k=(i+4)*10 ; k <(i+6)*10 ; k++)//for(int k = ((i+2)*10); k<(((i+3)*10)+50);k++)
    				{
    					for(int l=(j+4)*10 ; l <(j+6)*10 ; l++)//for(int	l = ((j+2)*10); l<(((j+3)*10)+50); l++)
    					{
    					    zoomedMedianImage.SetPixel(k,l,values[i+4][j+4]);
    					    zoomedAveragingImage.SetPixel(k,l,avvalues[i+4][j+4]);
    					}

    				}
    			}

    		}

    	}

    }


 
    /**
     * Gibt 'true' zurueck,falls die Maus ueber dem Eingangsbild
     * ist,sonst 'false'.
     * @param x
     * @param y
     */
    public boolean mouseOverInputImage(int x,int y){
        if(x>=10 && x<266 && y>=180 && y<180+inputImage.sizeY) return true;
        else return false;
    }
    
    /**
     * Gibt 'true' zurueck,falls die Maus ueber dem median-
     * gefilteretem Bild ist,sonst 'false'.
     * @param x
     * @param y
     */
    public boolean mouseOverMedianImage(int x,int y){
        if(x>=460 && x<716 && y>=20 && y<20+MedianImage.sizeY) return true;
        else return false;
    }
    
    /**
     * Gibt 'true' zurueck,falls die Maus ueber dem average-
     * gefilteretem Bild ist,sonst 'false'.
     * @param x
     * @param y
     */
    public boolean mouseOverAverageImage(int x,int y){
        if(x>=460 && x<716 && y>=320 && y<320+AveragingImage.sizeY) return true;
        else return false;
    }
    
    /**
     * Befindet sich die Maus ueber dem Median-oder Averagebild,so
     * wird das gezoomte Bild an der (x,y)-Position der Maus neu berechnet.
     * Desweiteren wird der Grauwert,sowie (x,y)-Position auf der Oberflaeche
     * mit ausgegeben.
     */
    public void mouseMoved(MouseEvent e) {
        int xPos=e.getX();
        int yPos=e.getY();
        int value;
        mouseOverInput=mouseOverInputImage(xPos,yPos);
        mouseOverMedian=mouseOverMedianImage(xPos,yPos);
        mouseOverAverage=mouseOverAverageImage(xPos,yPos);
        if(mouseOverInput){
            value=inputImage.GetPixel(xPos-10,yPos-180);
            input.updateMousePosition(xPos-10,yPos-180,value);
            repaint();
        }
        if(mouseOverMedian){
            value=MedianImage.GetPixel(xPos-460,yPos-20);
            median.updateMousePosition(xPos-460,yPos-20,value);
            this.ChangeZoomPics(xPos-460,yPos-20);
            repaint();
        }
        if(mouseOverAverage){
            value=AveragingImage.GetPixel(xPos-460,yPos-320);
            averaging.updateMousePosition(xPos-460,yPos-320,value);
            this.ChangeZoomPics(xPos-460,yPos-320);
            repaint();
        }
        
        
        
    }
    public void mouseClicked(MouseEvent e) {}
 

    public void mouseEntered(MouseEvent e) {}
 
    public void mouseExited(MouseEvent e) {}


    public void mousePressed(MouseEvent e) {}

    public void mouseReleased(MouseEvent e) {}
 

    public void mouseDragged(MouseEvent e) {}



 

}
