package MedianAveraging;
/**
* This class is an underclass of iRPImage. It describes a zoomed image.
* The class is needed while the zoomed image is not normalized
*/

import java.awt.*;
import java.awt.image.MemoryImageSource;

public class zoomediRPImage extends iRPImage
{


/**
* Creates a new zoomediRPImage given the parameters
*
* @param x sizeX of the image
* @param y sizeY of the image
*/
public zoomediRPImage(int x, int y)
{
	super.sizeX = x;
	super.sizeY = y;
	super.image = new int[x*y];
}

/**
* Creates an empty zoomediRPImage
*/
public zoomediRPImage()
{
	super.sizeX=0;
	super.sizeY=0;
	super.image = new int[0];

}

/**
 * Draws the iRPImage to the screen, given a point (x,y) where
 * (x,y) specifies the upper left corner position of the picture.
 * This method normalizes the image[] array and creates an Image from
 * it using the MemoryImageSource-class.
 *
 * @param	g	the Graphics context of the screen
 * @param	x	x-position to draw from (upper left corner)
 * @param	y	y-position to draw from (upper left corner)
 */
  public void PaintImage(Graphics g, int x, int y){
	Image OutPut;

	//Convert grey values to color:
	for (int i=0;i<sizeX*sizeY;i++)
	{
			  this.SetPixel(i,
			  			   ( (this.GetPixel(i) & 0xff) << 16) //red
			  			 + ( (this.GetPixel(i)& 0xff) << 8)  //green
			  			 + ( this.GetPixel(i) & 0xff)		  //blue
			  			 + 0xff000000);				  //alpha
	}

	MemoryImageSource mis = new MemoryImageSource(sizeX, sizeY, image, 0, sizeX);
	OutPut = createImage(mis);

    MediaTracker mt = new MediaTracker(this);
	mt.addImage(OutPut, 0);
	try { mt.waitForAll(); } catch (InterruptedException e) {}

    g.drawImage(OutPut , x , y, this);
  }


}